/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.DecoratedCurve;

public class Zykloide
extends DecoratedCurve {
    private RealParamAnimateable radius;
    private RealParamAnimateable stick;

    public Zykloide() {
        this.tResolution.setValueAndDefault(300);
        this.radius = new RealParamAnimateable("vmm.planecurve.parametric.Zykloide.radius", 3.0, 3.0, 3.0);
        this.stick = new RealParamAnimateable("vmm.planecurve.parametric.Zykloide.stick", 1.0, 0.2, 4.0);
        this.addParameter(this.radius);
        this.addParameter(this.stick);
        this.tmin.setValueAndDefaultFromString("-8*pi");
        this.tmax.setValueAndDefaultFromString("8*pi");
        this.setDefaultWindow(-20.0, 20.0, -6.0, 6.0);
    }

    @Override
    public double xValue(double t) {
        double r = this.radius.getValue();
        double l = this.stick.getValue();
        return t + l * r * Math.cos(t / r);
    }

    @Override
    public double yValue(double t) {
        double r = this.radius.getValue();
        double l = this.stick.getValue();
        return -l * r * Math.sin(t / r) + r;
    }

    @Override
    protected void drawNeededStuff(Graphics2D g, View view, Transform limits, double t) {
        Color saveColor = g.getColor();
        double r = this.radius.getValue();
        double l = this.stick.getValue();
        double tx = 1.0 - l * Math.sin(t / r);
        double ty = -l * Math.cos(t / r);
        g.setColor(Color.red);
        if (r > 0.0) {
            g.draw(new Ellipse2D.Double(t - r, 0.0, 2.0 * r, 2.0 * r));
        } else {
            g.draw(new Ellipse2D.Double(t + r, 2.0 * r, -2.0 * r, -2.0 * r));
        }
        g.setColor(Color.blue);
        g.draw(new Line2D.Double(this.xValue(t), this.yValue(t), t, 0.0));
        g.draw(new Line2D.Double(this.xValue(t) - 2.0 * tx, this.yValue(t) - 2.0 * ty, this.xValue(t) + 2.0 * tx, this.yValue(t) + 2.0 * ty));
        g.setColor(Color.green);
        g.draw(new Line2D.Double(t, r, this.xValue(t), this.yValue(t)));
        g.setColor(saveColor);
    }
}

