/*
 * Decompiled with CFR 0.152.
 */
package vmm.latticemodel;

import java.awt.Graphics2D;
import vmm.core.I18n;
import vmm.core.RealParam;
import vmm.core.View;
import vmm.core3D.Transform3D;
import vmm.core3D.View3D;
import vmm.latticemodel.LatticeModel;

public class FermiPastaUlam
extends LatticeModel {
    protected RealParam a = new RealParam("vmm.latticeModel.FermiPastaUlam.a", 1.0);
    protected RealParam b = new RealParam("vmm.latticeModel.FermiPastaUlam.b", 0.25);
    protected RealParam c = new RealParam("vmm.latticeModel.FermiPastaUlam.c", 0.0);
    protected RealParam d = new RealParam("vmm.latticeModel.FermiPastaUlam.d", 0.0);

    @Override
    protected double potentialEnergy(double x, double theLatticeSpacing) {
        return x * x * (this.a.getValue() / 2.0 + x * (this.b.getValue() / 3.0 + x * (this.c.getValue() / 4.0 + x * this.d.getValue() / 5.0))) / (16.0 * theLatticeSpacing);
    }

    @Override
    protected double internalForceLaw(double x, double theLatticeSpacing) {
        return -x * (this.a.getValue() + x * (this.b.getValue() + x * (this.c.getValue() + x * this.d.getValue()))) / (16.0 * theLatticeSpacing);
    }

    @Override
    protected double externalForceLaw(double x, double theLatticeSpacing) {
        return 0.0;
    }

    public FermiPastaUlam() {
        this.canShowNormalModeDisplay = true;
        this.defaultAmplitude = 1.0;
        this.addParameter(this.d);
        this.addParameter(this.c);
        this.addParameter(this.b);
        this.addParameter(this.a);
    }

    @Override
    protected void doDraw3D(Graphics2D g, View3D view, Transform3D transform) {
        int displayStyle = ((LatticeModel.LMView)view).getDisplayStyle();
        if (displayStyle != 5) {
            super.doDraw3D(g, view, transform);
            return;
        }
        view.drawString("FPU Graph Display", 0.0, 1.0);
        if (((LatticeModel.LMView)view).getShowNormalModeDisplay()) {
            // empty if block
        }
    }

    @Override
    public View getDefaultView() {
        return new FPUView();
    }

    public class FPUView
    extends LatticeModel.LMView {
        public FPUView() {
            super(FermiPastaUlam.this);
            this.displayStyleSelect.addItem(I18n.tr("vmm.latticemodel.FermiPastaUlam.FPUGraphDisplay"));
        }

        @Override
        public LatticeModel.LatticeData getLatticeData() {
            if (this.latticeData == null) {
                this.latticeData = new FPULatticeData(this);
            }
            return this.latticeData;
        }
    }

    protected class FPULatticeData
    extends LatticeModel.LatticeData {
        FPULatticeData(FPUView view) {
            super(FermiPastaUlam.this, view);
            this.youngsModulus = FermiPastaUlam.this.a.getValue();
        }

        @Override
        public void step(LatticeModel.LMView view) {
            super.step(view);
            FPUView fpuView = (FPUView)view;
        }
    }
}

