/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.SaveAndRestore;
import vmm.core.UserExhibit;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;

public interface UserExhibit3D
extends UserExhibit {
    public Vector3D getDefaultViewpoint();

    public void setDefaultViewpoint(Vector3D var1);

    public static class Support
    extends UserExhibit.Support {
        private boolean showViewpoint = true;
        private ViewpointInput viewpointInput;
        private final UserExhibit3D exhibit3D;

        public Support(UserExhibit3D exhibit3D) {
            super(exhibit3D);
            this.exhibit3D = exhibit3D;
        }

        public boolean getShowViewpoint() {
            return this.showViewpoint;
        }

        public void setShowViewpoint(boolean showViewpoint) {
            this.showViewpoint = showViewpoint;
        }

        @Override
        protected UserExhibit.Support.Dialog createDialog(Display display, View view, boolean creating) {
            UserExhibit.Support.Dialog dialog = super.createDialog(display, view, creating);
            if (this.showViewpoint && view instanceof View3D) {
                Vector3D v = creating ? this.exhibit3D.getDefaultViewpoint() : ((View3D)view).getViewPoint();
                if (v == null) {
                    v = new Vector3D(20.0, 0.0, 0.0);
                }
                this.viewpointInput = new ViewpointInput(v);
                dialog.addExtraPanel(this.viewpointInput);
            }
            return dialog;
        }

        @Override
        protected void finish(UserExhibit.Support.Dialog dialog, View view, boolean creating) {
            super.finish(dialog, view, creating);
            if (this.showViewpoint && view instanceof View3D) {
                ((View3D)view).setViewPoint(this.viewpointInput.viewpoint);
                this.exhibit3D.setDefaultViewpoint(this.viewpointInput.viewpoint);
            }
        }

        @Override
        public void addToXML(Document containingDocument, Element userDataElement) {
            super.addToXML(containingDocument, userDataElement);
            SaveAndRestore.addProperty(this, "showViewpoint", containingDocument, userDataElement);
        }

        private class ViewpointInput
        extends UserExhibit.Support.ExtraPanel {
            private JTextField[] viewpointInputs;
            private Vector3D viewpoint;

            private ViewpointInput(Vector3D v) {
                super(I18n.tr("vmm.core.UserExhibitDialog.ViewpointPanelTitle"));
                this.setLayout(new GridLayout(0, 4, 5, 5));
                this.viewpointInputs = new JTextField[3];
                this.viewpointInputs[0] = new JTextField("" + v.x);
                this.viewpointInputs[1] = new JTextField("" + v.y);
                this.viewpointInputs[2] = new JTextField("" + v.z);
                this.add(new JLabel(I18n.tr("vmm.core.UserExhibitDialog.ViewFrom") + ": ", 4));
                this.add(this.viewpointInputs[0]);
                this.add(this.viewpointInputs[1]);
                this.add(this.viewpointInputs[2]);
            }

            @Override
            public void checkData() {
                double[] vp = new double[3];
                for (int i = 0; i < 3; ++i) {
                    try {
                        vp[i] = Double.parseDouble(this.viewpointInputs[i].getText());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.viewpointInputs[i].requestFocus();
                        this.viewpointInputs[i].selectAll();
                        throw new IllegalArgumentException(I18n.tr("vmm.core.UserExhibitDialog.error.badViewpoint"));
                    }
                }
                this.viewpoint = new Vector3D(vp[0], vp[1], vp[2]);
            }
        }
    }
}

