/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import vmm.core.Complex;
import vmm.core.I18n;
import vmm.core.MouseTask;
import vmm.core.ParameterInput;
import vmm.core.RealParam;
import vmm.functions.ComplexExpression;
import vmm.functions.Expression;
import vmm.functions.ParseError;
import vmm.functions.Parser;
import vmm.functions.Variable;

public class Util {
    private static Parser constantParser;
    private static Parser constantParserWithNanAndInf;
    private static char isMac;
    private static String commandKey;

    public static Expression parseConstantExpression(String expressionAsString) throws ParseError {
        if (constantParser == null) {
            constantParser = new Parser();
        }
        return constantParser.parseExpression(expressionAsString);
    }

    public static ComplexExpression parseComplexConstantExpression(String expressionAsString) throws ParseError {
        if (constantParser == null) {
            constantParser = new Parser();
        }
        return constantParser.parseComplexExpression(expressionAsString);
    }

    public static Cursor createCursorFromResource(String imageResourceFileName, int activeX, int activeY) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ClassLoader cl = MouseTask.class.getClassLoader();
            URL imageURL = cl.getResource(imageResourceFileName);
            if (imageURL == null) {
                return null;
            }
            Image image = toolkit.createImage(imageURL);
            return toolkit.createCustomCursor(image, new Point(activeX, activeY), imageResourceFileName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isMacOS() {
        if (isMac == '?') {
            try {
                String macTest = System.getProperty("mrj.version");
                isMac = macTest != null ? (char)89 : (char)78;
            }
            catch (Exception e) {
                isMac = (char)78;
            }
        }
        return isMac == 'Y';
    }

    public static KeyStroke getAccelerator(String description) {
        if (commandKey == null) {
            commandKey = Util.isMacOS() ? "meta " : "control ";
        }
        return KeyStroke.getKeyStroke(commandKey + description);
    }

    public static long availableMemory() {
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        long memoryInUse = runtime.totalMemory() - runtime.freeMemory();
        long maxMem = runtime.maxMemory();
        long mem = maxMem == Long.MAX_VALUE ? runtime.freeMemory() : maxMem - memoryInUse;
        return mem;
    }

    public static Point2D getPoint2DFromUser(Component parent, String prompt) {
        return Util.getPoint2DFromUser(parent, prompt, Double.NaN, Double.NaN);
    }

    public static Point2D getPoint2DFromUser(Component parent, String prompt, double initialX, double initialY) {
        return Util.getPoint2DFromUser(parent, prompt, initialX, initialY, "x", "y");
    }

    public static Point2D getPoint2DFromUser(Component parent, String prompt, double initialX, double initialY, String nameForX, String nameForY) {
        double newY;
        double newX;
        RealParam xVal = new RealParam(nameForX, initialX);
        RealParam yVal = new RealParam(nameForY, initialY);
        ParameterInput xIn = new ParameterInput(xVal);
        ParameterInput yIn = new ParameterInput(yVal);
        xIn.setColumns(15);
        yIn.setColumns(15);
        if (Double.isNaN(initialX)) {
            xIn.setText("");
        }
        if (Double.isNaN(initialY)) {
            yIn.setText("");
        }
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout(3, 3));
        top.add((Component)new JLabel(xVal.getTitle() + " = "), "West");
        top.add((Component)xIn, "Center");
        JPanel bottom = new JPanel();
        bottom.setLayout(new BorderLayout(3, 3));
        bottom.add((Component)new JLabel(yVal.getTitle() + " = "), "West");
        bottom.add((Component)yIn, "Center");
        JPanel input = new JPanel();
        input.setLayout(new GridLayout(2, 1, 10, 10));
        input.add(top);
        input.add(bottom);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout(10, 10));
        content.add((Component)input, "Center");
        content.add((Component)new JLabel(prompt, 2), "North");
        int response = JOptionPane.showConfirmDialog(parent, content, "", 2, -1);
        if (response == 2) {
            return null;
        }
        String xStr = xIn.getText();
        String yStr = yIn.getText();
        try {
            newX = Double.parseDouble(xStr);
            newY = Double.parseDouble(yStr);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(parent, I18n.tr("vmm.core.Util.getPoint2D.error.illegalnumbers"));
            return null;
        }
        return new Point2D.Double(newX, newY);
    }

    public static String[] explode(String str, String separators) {
        if (str == null) {
            return null;
        }
        if (separators == null) {
            return new String[]{str};
        }
        StringTokenizer tokenizer = new StringTokenizer(str, separators);
        int ct = tokenizer.countTokens();
        String[] tokens = new String[ct];
        for (int i = 0; i < ct; ++i) {
            tokens[i] = tokenizer.nextToken();
        }
        return tokens;
    }

    public static String toExternalString(Object value) {
        try {
            if (value == null) {
                return "##NULL##";
            }
            if (value instanceof Double) {
                double x = (Double)value;
                if (Double.isNaN(x)) {
                    return "NaN";
                }
                if (x == Double.POSITIVE_INFINITY) {
                    return "+INF";
                }
                if (x == Double.NEGATIVE_INFINITY) {
                    return "-INF";
                }
                if (x == Double.MIN_VALUE) {
                    return "EPSILON";
                }
                return "" + x;
            }
            if (value instanceof Float) {
                float x = ((Float)value).floatValue();
                if (Float.isNaN(x)) {
                    return "NaN";
                }
                if (x == Float.POSITIVE_INFINITY) {
                    return "+INF";
                }
                if (x == Float.NEGATIVE_INFINITY) {
                    return "-INF";
                }
                if (x == Float.MIN_VALUE) {
                    return "EPSILON";
                }
                return "" + x;
            }
            if (value instanceof Color) {
                Color c = (Color)value;
                return c.getRed() + " " + c.getGreen() + " " + c.getBlue();
            }
            if (value instanceof Point2D) {
                Point2D v = (Point2D)value;
                return Util.toExternalString(v.getX()) + " " + Util.toExternalString(v.getY());
            }
            if (value instanceof double[]) {
                String s = "";
                double[] d = (double[])value;
                for (int i = 0; i < d.length; ++i) {
                    s = s + Util.toExternalString(d[i]);
                    if (i >= d.length - 1) continue;
                    s = s + " ";
                }
                return s;
            }
            if (value instanceof int[]) {
                String s = "";
                int[] d = (int[])value;
                for (int i = 0; i < d.length; ++i) {
                    s = s + d[i];
                    if (i >= d.length - 1) continue;
                    s = s + " ";
                }
                return s;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value.toString();
    }

    public static Object externalStringToValue(String str, Class valueType) throws IllegalArgumentException {
        try {
            if (valueType.isPrimitive()) {
                if (valueType.equals(Boolean.TYPE)) {
                    return new Boolean(str);
                }
                if (valueType.equals(Integer.TYPE)) {
                    return new Integer(str);
                }
                if (valueType.equals(Double.TYPE)) {
                    if ("NaN".equalsIgnoreCase(str)) {
                        return Double.NaN;
                    }
                    if ("+INF".equalsIgnoreCase(str)) {
                        return Double.POSITIVE_INFINITY;
                    }
                    if ("-INF".equalsIgnoreCase(str)) {
                        return Double.NEGATIVE_INFINITY;
                    }
                    if ("EPSILON".equalsIgnoreCase(str)) {
                        return Double.MIN_VALUE;
                    }
                    return new Double(str);
                }
                if (valueType.equals(Float.TYPE)) {
                    if ("NaN".equalsIgnoreCase(str)) {
                        return Float.valueOf(Float.NaN);
                    }
                    if ("+INF".equalsIgnoreCase(str)) {
                        return Float.valueOf(Float.POSITIVE_INFINITY);
                    }
                    if ("-INF".equalsIgnoreCase(str)) {
                        return Float.valueOf(Float.NEGATIVE_INFINITY);
                    }
                    if ("EPSILON".equalsIgnoreCase(str)) {
                        return Float.valueOf(Float.MIN_VALUE);
                    }
                    return new Float(str);
                }
                if (valueType.equals(Long.TYPE)) {
                    return new Long(str);
                }
                if (valueType.equals(Short.TYPE)) {
                    return new Short(str);
                }
                if (valueType.equals(Byte.TYPE)) {
                    return new Byte(str);
                }
                return new Character(str.charAt(0));
            }
            if (str.equalsIgnoreCase("##NULL##")) {
                return null;
            }
            if (valueType.equals(Double.class)) {
                return Util.externalStringToValue(str, Double.TYPE);
            }
            if (valueType.equals(Float.class)) {
                return Util.externalStringToValue(str, Float.TYPE);
            }
            if (valueType.equals(String.class)) {
                return str;
            }
            if (valueType.equals(Complex.class)) {
                if (constantParserWithNanAndInf == null) {
                    constantParserWithNanAndInf = new Parser();
                    constantParserWithNanAndInf.add(new Variable("NaN", Double.NaN));
                    constantParserWithNanAndInf.add(new Variable("INF", Double.POSITIVE_INFINITY));
                }
                return constantParserWithNanAndInf.parseComplexExpression(str).value();
            }
            if (valueType.equals(Color.class)) {
                StringTokenizer tokenizer = new StringTokenizer(str, " ,\t");
                String redString = tokenizer.nextToken();
                String greenString = tokenizer.nextToken();
                String blueString = tokenizer.nextToken();
                return new Color(Integer.parseInt(redString), Integer.parseInt(greenString), Integer.parseInt(blueString));
            }
            if (valueType.equals(double[].class)) {
                StringTokenizer tokenizer = new StringTokenizer(str, ", \t");
                int ct = tokenizer.countTokens();
                double[] numbers = new double[ct];
                for (int i = 0; i < ct; ++i) {
                    String s = tokenizer.nextToken();
                    numbers[i] = (Double)Util.externalStringToValue(s, Double.TYPE);
                }
                return numbers;
            }
            if (valueType.equals(int[].class)) {
                StringTokenizer t = new StringTokenizer(str, " ,\t");
                int[] a = new int[t.countTokens()];
                for (int i = 0; i < a.length; ++i) {
                    a[i] = Integer.parseInt(t.nextToken());
                }
                return a;
            }
            if (valueType.equals(Point2D.class)) {
                double[] nums = (double[])Util.externalStringToValue(str, double[].class);
                if (nums.length != 2) {
                    throw new Exception();
                }
                return new Point2D.Double(nums[0], nums[1]);
            }
            Method fromExternalString = null;
            try {
                fromExternalString = valueType.getDeclaredMethod("fromString", String.class);
            }
            catch (Exception a) {
                // empty catch block
            }
            if (fromExternalString != null) {
                Object obj = fromExternalString.invoke(null, str);
                if (valueType.isInstance(obj)) {
                    return obj;
                }
                throw new Exception();
            }
            Constructor constructor = valueType.getConstructor(String.class);
            return constructor.newInstance(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(I18n.tr("vmm.core.Util.error.BadString", str));
        }
    }

    static {
        isMac = (char)63;
        commandKey = null;
    }
}

