/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import vmm.core3D.Vector3D;

public class Quaternion {
    public static final Quaternion ZERO = new Quaternion();
    public static final Quaternion q1 = new Quaternion(1.0, 0.0, 0.0, 0.0);
    public static final Quaternion qI = new Quaternion(0.0, 1.0, 0.0, 0.0);
    public static final Quaternion qJ = new Quaternion(0.0, 0.0, 1.0, 0.0);
    public static final Quaternion qK = new Quaternion(0.0, 0.0, 0.0, 1.0);
    public double a;
    public double b;
    public double c;
    public double d;

    public Quaternion() {
    }

    public Quaternion(double a, double b, double c, double d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public Quaternion(Quaternion source) {
        this.a = source.a;
        this.b = source.b;
        this.c = source.c;
        this.d = source.d;
    }

    public boolean equals(Object obj) {
        try {
            Quaternion q = (Quaternion)obj;
            return this.a == q.a && this.b == q.b && this.c == q.c && this.d == q.d;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return "(" + this.a + "," + this.b + "," + this.c + "," + this.d + ")";
    }

    public double dot(Quaternion q) {
        return this.a * q.a + this.b * q.b + this.c * q.c + this.d * q.d;
    }

    public double norm() {
        return Math.sqrt(this.a * this.a + this.b * this.b + this.c * this.c + this.d * this.d);
    }

    public Quaternion conj() {
        return new Quaternion(this.a, -this.b, -this.c, -this.d);
    }

    public Quaternion plus(Quaternion q) {
        return new Quaternion(this.a + q.a, this.b + q.b, this.c + q.c, this.d + q.d);
    }

    public Quaternion minus(Quaternion q) {
        return new Quaternion(this.a - q.a, this.b - q.b, this.c - q.c, this.d - q.d);
    }

    public Quaternion times(Quaternion q) {
        return new Quaternion(this.a * q.a - this.b * q.b - this.c * q.c - this.d * q.d, this.a * q.b + this.b * q.a + this.c * q.d - this.d * q.c, this.a * q.c - this.b * q.d + this.c * q.a + this.d * q.b, this.a * q.d + this.b * q.c - this.c * q.b + this.d * q.a);
    }

    public Quaternion times(double x) {
        return new Quaternion(this.a * x, this.b * x, this.c * x, this.d * x);
    }

    public Quaternion inverse() {
        double denom = this.a * this.a + this.b * this.b + this.c * this.c + this.d * this.d;
        return new Quaternion(this.a / denom, -this.b / denom, -this.c / denom, -this.d / denom);
    }

    public Quaternion dividedBy(Quaternion q) {
        return this.times(q.inverse());
    }

    public Quaternion rotateAroundHopfFibre(double phi) {
        return new Quaternion(this.a, this.b, this.c * Math.cos(phi) - this.d * Math.sin(phi), this.c * Math.sin(phi) + this.d * Math.cos(phi));
    }

    public Quaternion rotateAroundHopfFibre(double phi, Quaternion q0) {
        Quaternion p = new Quaternion(this.times(q0.inverse()));
        p = p.rotateAroundHopfFibre(phi);
        return p.times(q0);
    }

    public Vector3D StereographicProjection() {
        return new Vector3D(this.b / (1.0 + this.a), this.c / (1.0 + this.a), this.d / (1.0 + this.a));
    }
}

