/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.Util;
import vmm.functions.Expression;
import vmm.functions.ParseError;

public class IntegerParam
extends Parameter {
    private int minimumValueForInput = Integer.MIN_VALUE;
    private int maximumValueForInput = Integer.MAX_VALUE;

    public IntegerParam() {
        this((String)null, 0);
    }

    public IntegerParam(String name, int initialValue) {
        super(name, new Integer(initialValue));
    }

    public IntegerParam(String name, String valueAsString) throws NumberFormatException {
        super(name, valueAsString);
    }

    public void reset(int value) {
        this.reset(new Integer(value));
    }

    public void setValue(int val) {
        this.setValueObject(new Integer(val));
    }

    public int getValue() {
        Integer obj = (Integer)this.getValueObject();
        if (obj == null) {
            return 0;
        }
        return obj;
    }

    public void setDefaultValue(int val) {
        this.setDefaultValueObject(new Integer(val));
    }

    public void setValueAndDefault(int val) {
        Integer v = new Integer(val);
        this.setValueObject(v);
        this.setDefaultValueObject(v);
    }

    public int getDefaultValue() {
        Object object = this.getDefaultValueObject();
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    public int getMaximumValueForInput() {
        return this.maximumValueForInput;
    }

    public void setMaximumValueForInput(int maximumValueForInput) {
        this.maximumValueForInput = maximumValueForInput;
    }

    public int getMinimumValueForInput() {
        return this.minimumValueForInput;
    }

    public void setMinimumValueForInput(int minimumValueForInput) {
        this.minimumValueForInput = minimumValueForInput;
    }

    @Override
    protected Object stringToValueObject(String str) throws NumberFormatException {
        try {
            return new Integer(str);
        }
        catch (NumberFormatException numberFormatException) {
            Expression exp;
            try {
                exp = Util.parseConstantExpression(str);
            }
            catch (ParseError e) {
                throw new NumberFormatException(I18n.tr("vmm.core.IntegerParam.badExpression", str, e.getMessage()));
            }
            double d = exp.value();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                throw new NumberFormatException(I18n.tr("vmm.core.IntegerParam.undefined", str));
            }
            int i = d > 0.0 ? (int)(d + 1.0E-8) : (int)(d - 1.0E-8);
            if (Math.abs((double)i - d) > 5.0E-9) {
                throw new NumberFormatException(I18n.tr("vmm.core.IntegerParam.notAnInteger", str));
            }
            return new Integer(i);
        }
    }
}

