/*
 * Decompiled with CFR 0.152.
 */
package vmm.conformalmap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.actions.ToggleAction;
import vmm.conformalmap.ConformalMapFigure;
import vmm.core.Animation;
import vmm.core.BasicMouseTask2D;
import vmm.core.Complex;
import vmm.core.Decoration;
import vmm.core.Display;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.IntegerParam;
import vmm.core.MouseTask;
import vmm.core.RealParamAnimateable;
import vmm.core.SaveAndRestore;
import vmm.core.ThreadedAnimation;
import vmm.core.TwoPointInput;
import vmm.core.Util;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.BasicMouseTask3D;
import vmm.core3D.Exhibit3D;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;

public abstract class ConformalMap
extends Exhibit3D {
    public static final int IDENTITY = 0;
    public static final int INVERSION = 1;
    public static final int FRACTIONAL = 2;
    public static final int SQRROOT = 3;
    public static final int CARTESIAN = 0;
    public static final int POLAR = 1;
    public static final int POLARCONFORMAL = 2;
    private double[][] gridData = new double[][]{{-1.0, 1.0, -1.0, 1.0, 20.0, 20.0}, {0.0, 1.0, 0.0, Math.PI * 2, 7.0, 42.0}, {-0.5, 0.5, 0.0, Math.PI * 2, 7.0, 42.0}};
    protected RealParamAnimateable umin = new RealParamAnimateable("vmm.conformalmap.ConformalMap.umin", -1.0);
    protected RealParamAnimateable umax = new RealParamAnimateable("vmm.conformalmap.ConformalMap.umax", 1.0);
    protected RealParamAnimateable vmin = new RealParamAnimateable("vmm.conformalmap.ConformalMap.vmin", -1.0);
    protected RealParamAnimateable vmax = new RealParamAnimateable("vmm.conformalmap.ConformalMap.vmax", 1.0);
    protected IntegerParam ures = new IntegerParam("vmm.conformalmap.ConformalMap.ures", 20);
    protected IntegerParam vres = new IntegerParam("vmm.conformalmap.ConformalMap.vres", 20);
    protected static final int POINTS_PER_INTERVAL = 4;
    protected int pointsOnCircleFigure = 256;
    protected int pointsOnLineFigure = 500;
    protected int pointsOnLineSegmentFigure = 250;
    protected Complex[][] argumentGrid;
    protected Complex[][] valueGrid;
    @VMMSave
    private int preCompFunction = 0;
    @VMMSave
    private int postCompFunction = 0;
    @VMMSave
    private int gridType = 0;
    private ActionRadioGroup preCompSelect;
    private ActionRadioGroup postCompSelect;
    protected ActionRadioGroup gridTypeSelect;
    private double[] defaultWindow2D = new double[]{-3.0, 3.0, -3.0, 3.0};

    protected abstract Complex function(Complex var1);

    public ConformalMap() {
        this.setDefaultBackground(Color.BLACK);
        this.addParameter(this.vres);
        this.addParameter(this.ures);
        this.addParameter(this.vmax);
        this.addParameter(this.vmin);
        this.addParameter(this.umax);
        this.addParameter(this.umin);
        this.vres.setMinimumValueForInput(1);
        this.ures.setMinimumValueForInput(1);
        this.setDefaultWindow(-1.5, 1.5, -1.5, 1.5);
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setUseFilmstripForMorphing(true);
        this.setFramesForMorphing(25);
        ActionRadioGroup group = new ActionRadioGroup(){

            @Override
            public void optionSelected(int selectedIndex) {
                ConformalMap.this.setPreCompFunction(selectedIndex);
            }
        };
        group.addItem(I18n.tr("vmm.conformalmap.ConformalMap.id"));
        group.addItem(I18n.tr("vmm.conformalmap.ConformalMap.inverse"));
        group.addItem(I18n.tr("vmm.conformalmap.ConformalMap.fractlin"));
        group.addItem(I18n.tr("vmm.conformalmap.ConformalMap.sqrt"));
        group.setSelectedIndex(0);
        this.preCompSelect = group;
        group = new ActionRadioGroup(){

            @Override
            public void optionSelected(int selectedIndex) {
                ConformalMap.this.setPostCompFunction(selectedIndex);
            }
        };
        group.addItem(I18n.tr("vmm.conformalmap.ConformalMap.id"));
        group.addItem(I18n.tr("vmm.conformalmap.ConformalMap.inverse"));
        group.addItem(I18n.tr("vmm.conformalmap.ConformalMap.fractlin"));
        group.addItem(I18n.tr("vmm.conformalmap.ConformalMap.sqrt"));
        group.setSelectedIndex(0);
        this.postCompSelect = group;
        group = new ActionRadioGroup(){

            @Override
            public void optionSelected(int selectedIndex) {
                ConformalMap.this.setGridType(selectedIndex);
            }
        };
        group.addItem(I18n.tr("vmm.conformalmap.ConformalMap.cartesian"));
        group.addItem(I18n.tr("vmm.conformalmap.ConformalMap.polar"));
        group.addItem(I18n.tr("vmm.conformalmap.ConformalMap.polarconformal"));
        group.setSelectedIndex(0);
        this.gridTypeSelect = group;
    }

    public int getPostCompFunction() {
        return this.postCompFunction;
    }

    public void setPostCompFunction(int postCompFunction) {
        if (this.postCompFunction != postCompFunction) {
            this.postCompFunction = postCompFunction;
            this.postCompSelect.setSelectedIndex(postCompFunction);
            this.forceRedraw();
        }
    }

    public int getPreCompFunction() {
        return this.preCompFunction;
    }

    public void setPreCompFunction(int preCompFunction) {
        if (this.preCompFunction != preCompFunction) {
            this.preCompFunction = preCompFunction;
            this.preCompSelect.setSelectedIndex(preCompFunction);
            this.forceRedraw();
        }
    }

    public int getGridType() {
        return this.gridType;
    }

    public void setGridType(int gridType) {
        if (gridType != 0 && gridType != 1 && gridType != 2) {
            return;
        }
        if (this.gridType != gridType) {
            this.gridData[this.gridType][0] = this.umin.getValue();
            this.gridData[this.gridType][1] = this.umax.getValue();
            this.gridData[this.gridType][2] = this.vmin.getValue();
            this.gridData[this.gridType][3] = this.vmax.getValue();
            this.gridData[this.gridType][4] = this.ures.getValue();
            this.gridData[this.gridType][5] = this.vres.getValue();
            this.gridType = gridType;
            this.umin.reset(this.gridData[this.gridType][0]);
            this.umax.reset(this.gridData[this.gridType][1]);
            this.vmin.reset(this.gridData[this.gridType][2]);
            this.vmax.reset(this.gridData[this.gridType][3]);
            this.ures.reset((int)this.gridData[this.gridType][4]);
            this.vres.reset((int)this.gridData[this.gridType][5]);
            this.gridTypeSelect.setSelectedIndex(gridType);
            this.forceRedraw();
        }
    }

    protected void resetGridType(int gridType) {
        this.gridType = gridType;
        this.gridTypeSelect.setSelectedIndex(gridType);
    }

    protected Complex composedFunction(Complex z) {
        Complex w = null;
        switch (this.preCompFunction) {
            case 0: {
                w = z;
                break;
            }
            case 1: {
                w = z.inverse();
                break;
            }
            case 2: {
                w = z.minus(1.0).dividedBy(z.plus(1.0)).times(-1.0);
                break;
            }
            case 3: {
                w = z.power(0.5);
            }
        }
        z = this.function(w);
        switch (this.postCompFunction) {
            case 0: {
                w = z;
                break;
            }
            case 1: {
                w = z.inverse();
                break;
            }
            case 2: {
                w = z.minus(1.0).dividedBy(z.plus(1.0)).times(-1.0);
                break;
            }
            case 3: {
                w = z.power(0.5);
            }
        }
        return w;
    }

    public double[] getDefaultWindow2D() {
        return this.defaultWindow2D;
    }

    public void setDefaultWindow2D(double[] defaultWindow2D) {
        if (defaultWindow2D != null) {
            if (defaultWindow2D.length < 4) {
                throw new IllegalArgumentException("Internal Error: Array is too short.");
            }
            this.defaultWindow2D = defaultWindow2D;
        }
    }

    public void setDefaultWindow2D(double xmin, double xmax, double ymin, double ymax) {
        this.setDefaultWindow2D(new double[]{xmin, xmax, ymin, ymax});
    }

    protected Complex gridMap(double u, double v) {
        Complex w = new Complex(u, v);
        switch (this.gridType) {
            case 0: {
                break;
            }
            case 1: {
                w.re = u * Math.cos(v);
                w.im = u * Math.sin(v);
                break;
            }
            case 2: {
                w = w.exponential();
            }
        }
        return w;
    }

    @Override
    protected void computeDrawData3D(View3D view, boolean exhibitNeedsRedraw, Transform3D previousTransform3D, Transform3D newTransform3D) {
        if (exhibitNeedsRedraw) {
            int uCount = this.ures.getValue() * 4;
            int vCount = this.vres.getValue() * 4;
            this.valueGrid = new Complex[uCount + 1][vCount + 1];
            this.argumentGrid = new Complex[uCount + 1][vCount + 1];
            double uStart = this.umin.getValue();
            double vStart = this.vmin.getValue();
            double uEnd = this.umax.getValue();
            double vEnd = this.vmax.getValue();
            double du = (uEnd - uStart) / (double)uCount;
            double dv = (vEnd - vStart) / (double)vCount;
            for (int i = 0; i <= uCount; ++i) {
                for (int j = 0; j <= vCount; ++j) {
                    this.argumentGrid[i][j] = this.gridMap(uStart + (double)i * du, vStart + (double)j * dv);
                    this.valueGrid[i][j] = this.composedFunction(this.argumentGrid[i][j]);
                }
            }
        }
    }

    @Override
    protected void doDraw3D(Graphics2D g, View3D view, Transform3D transform) {
        int uCount = this.ures.getValue() * 4;
        int vCount = this.vres.getValue() * 4;
        if (!(view instanceof ConformalMapView) || ((ConformalMapView)view).getDrawValueGrid()) {
            if (!view.getEnableThreeD()) {
                this.drawGrid(g, view, this.valueGrid, uCount, vCount);
            } else {
                this.drawGrid3D(g, view, this.valueGrid, uCount, vCount);
            }
        } else {
            this.drawGrid(g, view, this.argumentGrid, uCount, vCount);
        }
    }

    private void drawGrid(Graphics2D g, View3D view, Complex[][] grid, int uCount, int vCount) {
        int j;
        int brightness;
        Color c;
        boolean hilited;
        Point2D[] curve;
        int i;
        boolean whiteBackground = Color.WHITE.equals(view.getBackground());
        boolean useColor = true;
        int uHilite = -1;
        int vHilite = -1;
        Color saveColor = view.getColor();
        if (view instanceof ConformalMapView) {
            useColor = ((ConformalMapView)view).getUseColor();
            uHilite = ((ConformalMapView)view).getUHilite();
            vHilite = ((ConformalMapView)view).getVHilite();
        }
        boolean useHilite = uHilite >= 0 || vHilite >= 0;
        for (i = 0; i <= uCount; i += 4) {
            curve = new Point2D[vCount + 1];
            hilited = uHilite == i;
            c = null;
            if (useColor) {
                if (!useHilite || !hilited) {
                    brightness = useHilite && !whiteBackground ? 175 : 255;
                    c = new Color(brightness, (int)((double)brightness * ((double)(uCount - i) / (double)uCount)), 0);
                }
            } else if (useHilite && hilited) {
                c = Color.RED;
            }
            view.setColor(c);
            for (j = 0; j <= vCount; ++j) {
                curve[j] = new Point2D.Double(grid[i][j].re, grid[i][j].im);
            }
            if (useHilite && hilited) {
                view.setStrokeSizeMultiplier(2);
                view.drawCurve(curve);
                view.setStrokeSizeMultiplier(1);
                continue;
            }
            view.drawCurve(curve);
        }
        for (i = 0; i <= vCount; i += 4) {
            curve = new Point2D[uCount + 1];
            hilited = vHilite == i;
            c = null;
            if (useColor) {
                if (!useHilite || !hilited) {
                    brightness = useHilite && !whiteBackground ? 175 : 255;
                    c = new Color(brightness / 3, (int)((double)brightness * ((double)(vCount - i) / (double)vCount)), (int)((double)brightness * ((double)i / (double)vCount)));
                }
            } else if (useHilite && hilited) {
                c = Color.RED;
            }
            view.setColor(c);
            for (j = 0; j <= uCount; ++j) {
                curve[j] = new Point2D.Double(grid[j][i].re, grid[j][i].im);
            }
            if (useHilite && hilited) {
                view.setStrokeSizeMultiplier(2);
                view.drawCurve(curve);
                view.setStrokeSizeMultiplier(1);
                continue;
            }
            view.drawCurve(curve);
        }
        view.setColor(saveColor);
    }

    private void drawGrid3D(Graphics2D g, View3D view, Complex[][] grid, int uCount, int vCount) {
        double[] p;
        int j;
        int brightness;
        Color c;
        boolean hilited;
        Vector3D[] curve;
        int i;
        boolean whiteBackground = Color.WHITE.equals(view.getBackground());
        boolean useColor = true;
        int uHilite = -1;
        int vHilite = -1;
        if (view instanceof ConformalMapView) {
            useColor = ((ConformalMapView)view).getUseColor();
            uHilite = ((ConformalMapView)view).getUHilite();
            vHilite = ((ConformalMapView)view).getVHilite();
        }
        boolean useHilite = uHilite >= 0 || vHilite >= 0;
        Color saveColor = view.getColor();
        for (i = 0; i <= uCount; i += 4) {
            curve = new Vector3D[vCount + 1];
            hilited = uHilite == i;
            c = null;
            if (useColor) {
                if (!useHilite || !hilited) {
                    brightness = useHilite && !whiteBackground ? 175 : 255;
                    c = new Color(brightness, (int)((double)brightness * ((double)(uCount - i) / (double)uCount)), 0);
                }
            } else if (useHilite && hilited) {
                c = Color.RED;
            }
            view.setColor(c);
            for (j = 0; j <= vCount; ++j) {
                if (grid[i][j].abs2() > 1000000.0) {
                    curve[j] = new Vector3D(0.0, 0.0, 1.0);
                    continue;
                }
                p = grid[i][j].stereographicProjection();
                curve[j] = new Vector3D(p[0], p[1], p[2]);
            }
            if (useHilite && hilited) {
                view.setStrokeSizeMultiplier(2);
                view.drawCurve(curve);
                view.setStrokeSizeMultiplier(1);
                continue;
            }
            view.drawCurve(curve);
        }
        for (i = 0; i <= vCount; i += 4) {
            curve = new Vector3D[uCount + 1];
            hilited = vHilite == i;
            c = null;
            if (useColor) {
                if (!useHilite || !hilited) {
                    brightness = useHilite && !whiteBackground ? 175 : 255;
                    c = new Color(brightness / 3, (int)((double)brightness * ((double)(vCount - i) / (double)vCount)), (int)((double)brightness * ((double)i / (double)vCount)));
                }
            } else if (useHilite && hilited) {
                c = Color.RED;
            }
            view.setColor(c);
            for (j = 0; j <= uCount; ++j) {
                if (grid[j][i].abs2() > 1000000.0) {
                    curve[j] = new Vector3D(0.0, 0.0, 1.0);
                    continue;
                }
                p = grid[j][i].stereographicProjection();
                curve[j] = new Vector3D(p[0], p[1], p[2]);
            }
            if (useHilite && hilited) {
                view.setStrokeSizeMultiplier(2);
                view.drawCurve(curve);
                view.setStrokeSizeMultiplier(1);
                continue;
            }
            view.drawCurve(curve);
        }
        view.setColor(saveColor);
    }

    @Override
    public Animation getCreateAnimation(View view) {
        if (!(view instanceof ConformalMapView)) {
            return null;
        }
        final ConformalMapView cmView = (ConformalMapView)view;
        if (cmView.getViewStyle() != 0 && cmView.getViewStyle() != 1) {
            return null;
        }
        return new ThreadedAnimation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runAnimation() {
                try {
                    int i;
                    int pauseTime = cmView.getShowBothArgAndValue() ? 100 : 50;
                    int uCount = ConformalMap.this.ures.getValue() * 4;
                    int vCount = ConformalMap.this.vres.getValue() * 4;
                    if (!cmView.getShowBothArgAndValue()) {
                        cmView.setDrawValueGrid(false);
                    }
                    this.pause(300);
                    for (i = 0; i <= uCount; i += 4) {
                        cmView.setHilite(i, vCount + 1);
                        this.pause(pauseTime);
                    }
                    cmView.setHilite(uCount + 1, vCount + 1);
                    this.pause(120);
                    for (i = 0; i <= vCount; i += 4) {
                        cmView.setHilite(uCount + 1, i);
                        this.pause(pauseTime);
                    }
                    if (cmView.getShowBothArgAndValue()) {
                        return;
                    }
                    cmView.setHilite(-1, -1);
                    this.pause(300);
                    cmView.setDrawValueGrid(true);
                    this.pause(300);
                    pauseTime = 80;
                    for (i = 0; i <= uCount; i += 4) {
                        cmView.setHilite(i, vCount + 1);
                        this.pause(pauseTime);
                    }
                    cmView.setHilite(uCount + 1, vCount + 1);
                    this.pause(120);
                    for (i = 0; i <= vCount; i += 4) {
                        cmView.setHilite(uCount + 1, i);
                        this.pause(pauseTime);
                    }
                }
                finally {
                    cmView.setHilite(-1, -1);
                    cmView.setDrawValueGrid(true);
                }
            }
        };
    }

    @Override
    public View getDefaultView() {
        ConformalMapView view = new ConformalMapView();
        view.setShowBothArgAndValue(true);
        return view;
    }

    @Override
    public ActionList getActionsForView(final View view) {
        ActionList actions = super.getActionsForView(view);
        if (!(view instanceof ConformalMapView)) {
            return actions;
        }
        actions.add(null);
        actions.add(new AbstractActionVMM(I18n.tr("vmm.conformalmap.ConformalMap.GetLineSegment")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new GetFigure((ConformalMapView)view, 0, 1);
            }
        });
        actions.add(new AbstractActionVMM(I18n.tr("vmm.conformalmap.ConformalMap.GetLine")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new GetFigure((ConformalMapView)view, 1, 1);
            }
        });
        actions.add(new AbstractActionVMM(I18n.tr("vmm.conformalmap.ConformalMap.GetLCircle")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new GetFigure((ConformalMapView)view, 2, 2);
            }
        });
        actions.add(new AbstractActionVMM(I18n.tr("vmm.conformalmap.ConformalMap.RemoveFigures")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((ConformalMapView)view).removeFigures();
            }
        });
        actions.add(null);
        ActionList submenu = new ActionList(I18n.tr("vmm.conformalmap.ConformalMap.preComp"));
        submenu.add(this.preCompSelect);
        actions.add(submenu);
        submenu = new ActionList(I18n.tr("vmm.conformalmap.ConformalMap.postComp"));
        submenu.add(this.postCompSelect);
        actions.add(submenu);
        submenu = new ActionList(I18n.tr("vmm.conformalmap.ConformalMap.gridChoice"));
        submenu.add(this.gridTypeSelect);
        actions.add(submenu);
        return actions;
    }

    @Override
    public void addExtraXML(Document containingDocument, Element exhibitElement) {
        super.addExtraXML(containingDocument, exhibitElement);
        this.gridData[this.gridType][0] = this.umin.getValue();
        this.gridData[this.gridType][1] = this.umax.getValue();
        this.gridData[this.gridType][2] = this.vmin.getValue();
        this.gridData[this.gridType][3] = this.vmax.getValue();
        this.gridData[this.gridType][4] = this.ures.getValue();
        this.gridData[this.gridType][5] = this.vres.getValue();
        Element gridElement = containingDocument.createElement("gridLimits");
        gridElement.setAttribute("cartesian", Util.toExternalString(this.gridData[0]));
        gridElement.setAttribute("polar", Util.toExternalString(this.gridData[1]));
        gridElement.setAttribute("polarconformal", Util.toExternalString(this.gridData[2]));
        exhibitElement.appendChild(gridElement);
    }

    @Override
    public void readExtraXML(Element exhibitInfo) throws IOException {
        super.readExtraXML(exhibitInfo);
        Element gridElement = SaveAndRestore.getChildElement(exhibitInfo, "gridLimits");
        if (gridElement == null) {
            return;
        }
        String s = gridElement.getAttribute("cartesian").trim();
        if (s.length() == 0) {
            throw new IOException(I18n.tr("vmm.conformalmap.ConformalMap.MissingAttributeError", "cartesian"));
        }
        double[] cartesian = (double[])Util.externalStringToValue(s, double[].class);
        if (cartesian.length != 6) {
            throw new IOException(I18n.tr("vmm.conformalmap.ConformalMap.IncorrectArrayLength", "cartesian"));
        }
        s = gridElement.getAttribute("polar").trim();
        if (s.length() == 0) {
            throw new IOException(I18n.tr("vmm.conformalmap.ConformalMap.MissingAttributeError", "polar"));
        }
        double[] polar = (double[])Util.externalStringToValue(s, double[].class);
        if (polar.length != 6) {
            throw new IOException(I18n.tr("vmm.conformalmap.ConformalMap.IncorrectArrayLength", "polar"));
        }
        s = gridElement.getAttribute("polarconformal").trim();
        if (s.length() == 0) {
            throw new IOException(I18n.tr("vmm.conformalmap.ConformalMap.MissingAttributeError", "polarconformal"));
        }
        double[] polarconformal = (double[])Util.externalStringToValue(s, double[].class);
        if (polarconformal.length != 6) {
            throw new IOException(I18n.tr("vmm.conformalmap.ConformalMap.IncorrectArrayLength", "polarconformal"));
        }
        this.gridData = new double[][]{cartesian, polar, polarconformal};
        this.umin.reset(this.gridData[this.gridType][0]);
        this.umax.reset(this.gridData[this.gridType][1]);
        this.vmin.reset(this.gridData[this.gridType][2]);
        this.vmax.reset(this.gridData[this.gridType][3]);
        this.ures.reset((int)this.gridData[this.gridType][4]);
        this.vres.reset((int)this.gridData[this.gridType][5]);
    }

    public static class ConformalMapView
    extends View3D {
        @VMMSave
        private boolean use3D;
        @VMMSave
        private boolean useColor = true;
        private boolean drawValueGrid = true;
        private int uHilite = -1;
        private int vHilite = -1;
        @VMMSave
        private boolean showBothArgAndValue;
        private ConformalMapView argView;
        private boolean isArgView;
        private ToggleAction useColorToggle = new ToggleAction(I18n.tr("vmm.conformalmap.ConformalMap.ToggleUseColor"), true){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConformalMapView.this.setUseColor(!ConformalMapView.this.useColor);
            }
        };
        private ToggleAction showArgAndValueToggle = new ToggleAction(I18n.tr("vmm.conformalmap.ConformalMap.ToggleShowArgAndValue"), false){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ConformalMapView.this.getDisplay() != null) {
                    ConformalMapView.this.getDisplay().stopAnimation();
                }
                ConformalMapView.this.setShowBothArgAndValue(this.getState());
            }
        };
        protected ToggleAction use3DToggle = new ToggleAction(I18n.tr("vmm.conformalmap.ConformalMap.ToggleUse3D"), false){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ConformalMapView.this.getDisplay() != null) {
                    ConformalMapView.this.getDisplay().stopAnimation();
                }
                ConformalMapView.this.setUse3D(ConformalMapView.this.use3DToggle.getState());
            }
        };

        public ConformalMapView() {
            this.setAntialiased(true);
            this.setEnableThreeD(false);
            this.setShowAxes(true);
        }

        public void removeFigures() {
            Decoration[] decs = this.getDecorations();
            for (int i = decs.length - 1; i >= 0; --i) {
                if (!(decs[i] instanceof ConformalMapFigure)) continue;
                this.removeDecoration(decs[i]);
            }
            if (this.argView != null) {
                this.argView.removeFigures();
            }
        }

        @Override
        public void setExhibit(Exhibit exhibit) {
            if (exhibit == this.getExhibit()) {
                return;
            }
            super.setExhibit(exhibit);
            if (exhibit != null && exhibit instanceof ConformalMap) {
                ConformalMap c = (ConformalMap)exhibit;
                double[] d = c.getDefaultWindow2D();
                this.setWindowForUseWhileThreeDDisabled(d[0], d[1], d[2], d[3]);
                if (this.showBothArgAndValue) {
                    this.setUpArgView();
                }
            }
        }

        public boolean getUseColor() {
            return this.useColor;
        }

        public void setUseColor(boolean useColor) {
            if (useColor == this.useColor) {
                return;
            }
            this.useColorToggle.setState(useColor);
            this.forceRedraw();
            this.useColor = useColor;
            if (this.argView != null) {
                this.argView.useColor = useColor;
                this.argView.forceRedraw();
            }
        }

        public synchronized boolean getDrawValueGrid() {
            return this.drawValueGrid;
        }

        private synchronized void setDrawValueGrid(boolean drawValues) {
            if (drawValues != this.drawValueGrid) {
                this.drawValueGrid = drawValues;
                if (this.use3D) {
                    this.setEnableThreeD(this.drawValueGrid);
                }
                this.forceRedraw();
            }
        }

        @Override
        public MouseTask getDefaultMouseTask() {
            if (this.isArgView) {
                return new BasicMouseTask2D();
            }
            if (this.showBothArgAndValue) {
                if (this.use3D) {
                    return new BasicMouseTask3D();
                }
                return new BasicMouseTask2D();
            }
            if (this.use3D) {
                return new ConformalMapMouseTask3D();
            }
            return new ConformalMapMouseTask2D();
        }

        @Override
        public ActionList getActions() {
            ActionList actions = super.getActions();
            actions.add(this.showArgAndValueToggle);
            actions.add(this.useColorToggle);
            actions.add(this.use3DToggle);
            return actions;
        }

        @Override
        public void takeExhibit(View view, boolean shareTransform) {
            super.takeExhibit(view, shareTransform);
            if (shareTransform && view instanceof ConformalMapView) {
                this.setUse3D(((ConformalMapView)view).getUse3D());
            }
        }

        public boolean getUse3D() {
            return this.use3D;
        }

        public void setUse3D(boolean use3D) {
            if (this.use3D == use3D) {
                return;
            }
            this.use3D = use3D;
            this.use3DToggle.setState(use3D);
            this.setEnableThreeD(use3D);
            if (this.getDisplay() != null) {
                this.getDisplay().installMouseTask(this.getDefaultMouseTask());
            }
            if (this.showBothArgAndValue) {
                this.viewStyleCommands.setEnabled(false);
            }
        }

        private synchronized void setHilite(int uHilite, int vHilite) {
            this.uHilite = uHilite;
            this.vHilite = vHilite;
            this.forceRedraw();
            if (this.argView != null) {
                this.argView.uHilite = uHilite;
                this.argView.vHilite = vHilite;
                this.argView.forceRedraw();
            }
        }

        private synchronized int getUHilite() {
            return this.uHilite;
        }

        private synchronized int getVHilite() {
            return this.vHilite;
        }

        public boolean getShowBothArgAndValue() {
            return this.showBothArgAndValue;
        }

        public void setShowBothArgAndValue(boolean showBothArgAndValue) {
            if (this.showBothArgAndValue == showBothArgAndValue) {
                return;
            }
            this.showBothArgAndValue = showBothArgAndValue;
            this.showArgAndValueToggle.setState(showBothArgAndValue);
            if (showBothArgAndValue) {
                this.argView = new ConformalMapView();
                this.argView.isArgView = true;
                this.setUpArgView();
                if (this.getDisplay() != null) {
                    this.getDisplay().installMouseTask(this.getDefaultMouseTask());
                    this.getDisplay().installAuxiliaryView(this, this.argView);
                }
            } else {
                if (this.getDisplay() != null) {
                    this.getDisplay().installMouseTask(this.getDefaultMouseTask());
                    this.getDisplay().installAuxiliaryView(this, null);
                }
                this.argView = null;
                if (this.getUse3D()) {
                    this.viewStyleCommands.setEnabled(true);
                }
            }
        }

        private void setUpArgView() {
            if (this.argView != null) {
                if (this.getUse3D()) {
                    this.setViewStyle(0);
                }
                this.viewStyleCommands.setEnabled(false);
                if (this.getExhibit() != null) {
                    this.argView.takeExhibit(this, true);
                }
                this.argView.setUse3D(false);
                this.argView.setDrawValueGrid(false);
                this.argView.setBackground(this.getBackground());
                this.argView.setShowAxes(this.getShowAxes());
                this.argView.useColor = this.useColor;
                for (Decoration d : this.getDecorations()) {
                    if (!(d instanceof ConformalMapFigure)) continue;
                    ConformalMapFigure orig = (ConformalMapFigure)d;
                    ConformalMapFigure copy = new ConformalMapFigure(orig.getP1(), orig.getP2(), orig.getShape(), orig.getPointCount());
                    copy.setColor(orig.getColor());
                    this.argView.addDecoration(copy);
                }
            }
        }

        @Override
        public void setDisplay(Display display) {
            super.setDisplay(display);
            if (display != null) {
                display.setStopAnimationsOnResize(false);
            }
            if (display != null && this.showBothArgAndValue) {
                display.installAuxiliaryView(this, this.argView);
            }
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            if (this.argView != null) {
                this.argView.setBackground(c);
            }
        }

        @Override
        public void setShowAxes(boolean show) {
            super.setShowAxes(show);
            if (this.argView != null) {
                this.argView.setShowAxes(show);
            }
        }

        @Override
        public void addDecoration(Decoration d) {
            super.addDecoration(d);
            if (d instanceof ConformalMapFigure && this.argView != null) {
                ConformalMapFigure orig = (ConformalMapFigure)d;
                ConformalMapFigure copy = new ConformalMapFigure(orig.getP1(), orig.getP2(), orig.getShape(), orig.getPointCount());
                copy.setColor(orig.getColor());
                this.argView.addDecoration(copy);
            }
        }

        @Override
        public void readExtraXML(Element viewInfo) throws IOException {
            super.readExtraXML(viewInfo);
            if (this.showBothArgAndValue) {
                this.argView.setTransform(this.getEnableThreeD() ? this.getSavedAuxiliaryTransformForEnableThreeD() : this.getTransform());
            }
        }
    }

    private class GetFigure
    extends TwoPointInput {
        boolean canceled = true;
        int shape;
        int pointCount;
        ConformalMapView mainView;
        boolean forAuxiliaryView;

        GetFigure(ConformalMapView view, int shape, int whatToDraw) {
            this.mainView = view;
            view.getDisplay().stopAnimation();
            view.use3DToggle.setEnabled(false);
            this.shape = shape;
            this.pointCount = shape == 2 ? ConformalMap.this.pointsOnCircleFigure : (shape == 1 ? ConformalMap.this.pointsOnLineFigure : ConformalMap.this.pointsOnLineSegmentFigure);
            this.setFigureToDraw(whatToDraw);
            this.setDrawColor(view.getForeground());
            if (view.getShowBothArgAndValue()) {
                view.getDisplay().installAuxiliaryOneShotMouseTask(this);
                this.forAuxiliaryView = true;
            } else {
                view.setDrawValueGrid(false);
                view.getDisplay().installOneShotMouseTask(this);
                this.forAuxiliaryView = false;
            }
        }

        @Override
        protected void gotPoints(Display display, View viewWhereDragged, int startX, int startY, int endX, int endY) {
            this.canceled = false;
            Point2D.Double p1 = new Point2D.Double(startX, startY);
            Point2D.Double p2 = new Point2D.Double(endX, endY);
            viewWhereDragged.getTransform().viewportToWindow(p1);
            viewWhereDragged.getTransform().viewportToWindow(p2);
            ConformalMapFigure dec = new ConformalMapFigure(p1, p2, this.shape, this.pointCount);
            if (this.shape == 2) {
                dec.setColor(Color.GREEN);
            } else {
                dec.setColor(Color.RED);
            }
            this.mainView.addDecoration(dec);
            if (!this.forAuxiliaryView) {
                display.installAnimation(new ThreadedAnimation(){

                    @Override
                    protected void runAnimation() {
                        try {
                            this.pause(1000);
                        }
                        finally {
                            GetFigure.this.mainView.setDrawValueGrid(true);
                        }
                    }
                });
            }
        }

        @Override
        public void finish(Display display, View view) {
            if (this.canceled && !this.forAuxiliaryView) {
                this.mainView.setDrawValueGrid(true);
            }
            this.mainView.use3DToggle.setEnabled(true);
        }

        @Override
        public String getStatusText() {
            return I18n.tr("vmm.conformalmap.ConformalMap.inputFigurePrompt");
        }
    }

    private static class ConformalMapMouseTask3D
    extends BasicMouseTask3D {
        private boolean commandShifted;

        private ConformalMapMouseTask3D() {
        }

        @Override
        public boolean doMouseDown(MouseEvent evt, Display display, View view, int width, int height) {
            if (evt.isShiftDown() && evt.isMetaDown()) {
                ConformalMapView cmView = (ConformalMapView)display.getView();
                cmView.setDrawValueGrid(false);
                cmView.forceRedraw();
                this.commandShifted = true;
                return true;
            }
            this.commandShifted = false;
            return super.doMouseDown(evt, display, view, width, height);
        }

        @Override
        public void doMouseDrag(MouseEvent evt, Display display, View view, int width, int height) {
            if (!this.commandShifted) {
                super.doMouseDrag(evt, display, view, width, height);
            }
        }

        @Override
        public void doMouseUp(MouseEvent evt, Display display, View view, int width, int height) {
            if (this.commandShifted) {
                ConformalMapView cmView = (ConformalMapView)display.getView();
                cmView.setDrawValueGrid(true);
                cmView.drawValueGrid = true;
                cmView.forceRedraw();
            } else {
                super.doMouseUp(evt, display, view, width, height);
            }
        }
    }

    private static class ConformalMapMouseTask2D
    extends BasicMouseTask2D {
        private boolean commandShifted;

        private ConformalMapMouseTask2D() {
        }

        @Override
        public boolean doMouseDown(MouseEvent evt, Display display, View view, int width, int height) {
            if (evt.isShiftDown() && evt.isMetaDown()) {
                ConformalMapView cmView = (ConformalMapView)display.getView();
                cmView.setDrawValueGrid(false);
                cmView.forceRedraw();
                this.commandShifted = true;
                return true;
            }
            this.commandShifted = false;
            return super.doMouseDown(evt, display, view, width, height);
        }

        @Override
        public void doMouseDrag(MouseEvent evt, Display display, View view, int width, int height) {
            if (!this.commandShifted) {
                super.doMouseDrag(evt, display, view, width, height);
            }
        }

        @Override
        public void doMouseUp(MouseEvent evt, Display display, View view, int width, int height) {
            if (this.commandShifted) {
                ConformalMapView cmView = (ConformalMapView)display.getView();
                cmView.setDrawValueGrid(true);
                cmView.forceRedraw();
            } else {
                super.doMouseUp(evt, display, view, width, height);
            }
        }
    }
}

