/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jfree.ui.Drawable;
import org.jfree.ui.ExtendedDrawable;

public class ScalingDrawable
implements Drawable {
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private ExtendedDrawable drawable;

    public void draw(Graphics2D g2, Rectangle2D area) {
        if (this.drawable == null) {
            return;
        }
        Graphics2D derived = (Graphics2D)g2.create();
        derived.scale(this.scaleX, this.scaleY);
        Rectangle2D scaledArea = (Rectangle2D)area.clone();
        scaledArea.setRect(scaledArea.getX() * (double)this.scaleX, scaledArea.getY() * (double)this.scaleY, scaledArea.getWidth() * (double)this.scaleX, scaledArea.getHeight() * (double)this.scaleY);
        this.drawable.draw(derived, scaledArea);
        derived.dispose();
    }

    public ExtendedDrawable getDrawable() {
        return this.drawable;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setDrawable(ExtendedDrawable drawable) {
        this.drawable = drawable;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }
}

