/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.jfree.ui.ExtendedDrawable;
import org.jfree.util.Log;

public class ComponentDrawable
implements ExtendedDrawable {
    private boolean preserveAspectRatio;
    private Component component;
    private JFrame peerSupply = new JFrame();
    private JPanel contentPane;
    private PainterRunnable runnable;
    private boolean paintSynchronously;
    private boolean allowOwnPeer;

    public ComponentDrawable() {
        this.peerSupply.pack();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(null);
        this.peerSupply.setContentPane(this.contentPane);
        this.runnable = new PainterRunnable();
    }

    private void cleanUp() {
        if (this.component instanceof JComponent && !this.isOwnPeerConnected()) {
            JComponent jc = (JComponent)this.component;
            RepaintManager.currentManager(jc).removeInvalidComponent(jc);
            RepaintManager.currentManager(jc).markCompletelyClean(jc);
        }
        this.contentPane.removeAll();
        RepaintManager.currentManager(this.contentPane).removeInvalidComponent(this.contentPane);
        RepaintManager.currentManager(this.contentPane).markCompletelyClean(this.contentPane);
        this.peerSupply.dispose();
    }

    public synchronized void draw(Graphics2D g2, Rectangle2D area) {
        if (this.component == null) {
            return;
        }
        this.runnable.setArea(area);
        this.runnable.setGraphics(g2);
        if (SwingUtilities.isEventDispatchThread() || !this.paintSynchronously) {
            this.runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(this.runnable);
            }
            catch (Exception exception) {
                Log.warn((Object)"Failed to redraw the component.");
            }
        }
        this.cleanUp();
    }

    public Component getComponent() {
        return this.component;
    }

    public synchronized Dimension getPreferredSize() {
        if (this.component == null) {
            return new Dimension(0, 0);
        }
        if (!(this.component instanceof Window) && !this.isOwnPeerConnected()) {
            this.peerSupply.pack();
            this.contentPane.add(this.component);
            this.contentPane.validate();
            this.component.validate();
        } else {
            if (this.isOwnPeerConnected()) {
                return this.component.getSize();
            }
            this.component.validate();
        }
        Dimension retval = this.component.getPreferredSize();
        this.cleanUp();
        return retval;
    }

    protected static Window getWindowAncestor(Component component) {
        Container parent = component.getParent();
        while (parent != null) {
            if (parent instanceof Window) {
                return (Window)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public boolean isAllowOwnPeer() {
        return this.allowOwnPeer;
    }

    private boolean isOwnPeerConnected() {
        if (!this.allowOwnPeer) {
            return false;
        }
        Window windowAncestor = ComponentDrawable.getWindowAncestor(this.component);
        return windowAncestor != null && windowAncestor != this.peerSupply;
    }

    public boolean isPaintSynchronously() {
        return this.paintSynchronously;
    }

    public boolean isPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    private void prepareComponent(Component c) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.setDoubleBuffered(false);
            Component[] childs = jc.getComponents();
            int i = 0;
            while (i < childs.length) {
                Component child = childs[i];
                this.prepareComponent(child);
                ++i;
            }
        }
    }

    public void setAllowOwnPeer(boolean allowOwnPeer) {
        this.allowOwnPeer = allowOwnPeer;
    }

    public void setComponent(Component component) {
        this.component = component;
        this.prepareComponent(component);
    }

    public void setPaintSynchronously(boolean paintSynchronously) {
        this.paintSynchronously = paintSynchronously;
    }

    public void setPreserveAspectRatio(boolean preserveAspectRatio) {
        this.preserveAspectRatio = preserveAspectRatio;
    }

    private class PainterRunnable
    implements Runnable {
        private Rectangle2D area;
        private Graphics2D graphics;

        public Rectangle2D getArea() {
            return this.area;
        }

        public Graphics2D getGraphics() {
            return this.graphics;
        }

        public void run() {
            if (ComponentDrawable.this.component instanceof Window) {
                ComponentDrawable.this.component.addNotify();
            } else if (ComponentDrawable.this.isOwnPeerConnected()) {
                Window w = ComponentDrawable.getWindowAncestor(ComponentDrawable.this.component);
                w.validate();
            } else {
                ComponentDrawable.this.peerSupply.pack();
                ComponentDrawable.this.contentPane.add(ComponentDrawable.this.component);
            }
            ComponentDrawable.this.component.setBounds((int)this.area.getX(), (int)this.area.getY(), (int)this.area.getWidth(), (int)this.area.getHeight());
            ComponentDrawable.this.component.validate();
            ComponentDrawable.this.component.paint(this.graphics);
        }

        public void setArea(Rectangle2D area) {
            this.area = area;
        }

        public void setGraphics(Graphics2D graphics) {
            this.graphics = graphics;
        }
    }
}

