/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.extwriter;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.jfree.report.Band;
import org.jfree.report.Element;
import org.jfree.report.Group;
import org.jfree.report.JFreeReport;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.extwriter.AbstractXMLDefinitionWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriterException;
import org.jfree.report.modules.parser.extwriter.StyleWriter;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.xml.writer.XMLWriterSupport;

public class StylesWriter
extends AbstractXMLDefinitionWriter {
    private static final CommentHintPath STYLES_HINT_PATH = new CommentHintPath(new String[]{"report-definition", "styles"});
    private final ArrayList reportStyles = new ArrayList();

    public StylesWriter(ReportWriter reportWriter, int indentLevel) {
        super(reportWriter, indentLevel);
    }

    private void addCollectableStyleSheet(ElementStyleSheet es) {
        if (es.isGlobalDefault()) {
            return;
        }
        ElementStyleSheet[] parents = es.getParents();
        int i = 0;
        while (i < parents.length) {
            ElementStyleSheet parentsheet = parents[i];
            this.addCollectableStyleSheet(parentsheet);
            ++i;
        }
        if (!this.reportStyles.contains(es)) {
            this.reportStyles.add(es);
        }
    }

    private ElementStyleSheet[] collectStyles() {
        JFreeReport report = this.getReport();
        this.collectStylesFromBand(report.getReportHeader());
        this.collectStylesFromBand(report.getReportFooter());
        this.collectStylesFromBand(report.getPageHeader());
        this.collectStylesFromBand(report.getPageFooter());
        this.collectStylesFromBand(report.getItemBand());
        int i = 0;
        while (i < report.getGroupCount()) {
            Group g = report.getGroup(i);
            this.collectStylesFromBand(g.getHeader());
            this.collectStylesFromBand(g.getFooter());
            ++i;
        }
        ElementStyleSheet[] styles = this.reportStyles.toArray(new ElementStyleSheet[this.reportStyles.size()]);
        return styles;
    }

    private void collectStylesFromBand(Band band) {
        this.collectStylesFromElement(band);
        Element[] elements = band.getElementArray();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Band) {
                this.collectStylesFromBand((Band)elements[i]);
            } else {
                this.collectStylesFromElement(elements[i]);
            }
            ++i;
        }
    }

    private void collectStylesFromElement(Element element) {
        ElementStyleSheet elementSheet = element.getStyle();
        ElementStyleSheet[] parents = elementSheet.getParents();
        int i = 0;
        while (i < parents.length) {
            ElementStyleSheet es = parents[i];
            this.addCollectableStyleSheet(es);
            ++i;
        }
    }

    public void write(Writer writer) throws IOException, ReportWriterException {
        this.writeComment(writer, STYLES_HINT_PATH, "parser.comment.open");
        ElementStyleSheet[] styles = this.collectStyles();
        if (styles.length == 0) {
            return;
        }
        this.writeTag(writer, "styles");
        int i = 0;
        while (i < styles.length) {
            ElementStyleSheet style = styles[i];
            CommentHintPath stylePath = STYLES_HINT_PATH.getInstance();
            stylePath.addName(style);
            this.writeComment(writer, stylePath, "parser.comment.open");
            this.writeTag(writer, "style", "name", style.getName(), false);
            StyleWriter stW = new StyleWriter(this.getReportWriter(), style, this.getIndentLevel(), stylePath);
            stW.write(writer);
            this.writeComment(writer, stylePath, "parser.comment.close");
            this.writeCloseTag(writer, "style");
            ++i;
        }
        this.writeComment(writer, STYLES_HINT_PATH, "parser.comment.close");
        this.writeCloseTag(writer, "styles");
        writer.write(XMLWriterSupport.getLineSeparator());
    }
}

