/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.extwriter;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.report.ShapeElement;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.extwriter.AbstractXMLDefinitionWriter;
import org.jfree.report.modules.parser.extwriter.ObjectWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriterException;
import org.jfree.report.style.BandDefaultStyleSheet;
import org.jfree.report.style.ElementDefaultStyleSheet;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.StyleKey;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.factory.objects.ClassFactoryCollector;
import org.jfree.xml.factory.objects.ObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;
import org.jfree.xml.writer.AttributeList;

public class StyleWriter
extends AbstractXMLDefinitionWriter {
    private ElementStyleSheet elementStyleSheet;
    private CommentHintPath commentPath;
    static /* synthetic */ Class class$java$lang$String;

    public StyleWriter(ReportWriter reportWriter, ElementStyleSheet elementStyleSheet, int indentLevel, CommentHintPath commentPath) {
        super(reportWriter, indentLevel);
        if (elementStyleSheet == null) {
            throw new NullPointerException();
        }
        this.elementStyleSheet = elementStyleSheet;
        this.commentPath = commentPath.getInstance();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private ObjectDescription findObjectDescription(StyleKey key, Object o) {
        ClassFactoryCollector cc = this.getReportWriter().getClassFactoryCollector();
        ObjectDescription od = cc.getDescriptionForClass(o.getClass());
        if (od != null) {
            return od;
        }
        od = cc.getDescriptionForClass(key.getValueType());
        od = cc.getSuperClassObjectDescription(o.getClass(), od);
        od = cc.getSuperClassObjectDescription(key.getValueType(), od);
        return od;
    }

    private ArrayList getParameterNames(ObjectDescription d) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = d.getParameterNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            list.add(name);
        }
        return list;
    }

    private boolean isBasicKey(List parameters, ObjectDescription od) {
        String param;
        return parameters.size() == 1 && (param = (String)parameters.get(0)).equals("value") && od.getParameterDefinition("value").equals(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = StyleWriter.class$("java.lang.String")));
    }

    private boolean isDefaultStyleSheet(ElementStyleSheet es) {
        if (es == BandDefaultStyleSheet.getBandDefaultStyle()) {
            return true;
        }
        if (es == ElementDefaultStyleSheet.getDefaultStyle()) {
            return true;
        }
        return es == ShapeElement.getDefaultStyle();
    }

    private boolean isUseKeyObjectDescription(StyleKey key, Object o) {
        ClassFactoryCollector cc = this.getReportWriter().getClassFactoryCollector();
        ObjectDescription odObject = cc.getDescriptionForClass(o.getClass());
        ObjectDescription odKey = cc.getDescriptionForClass(key.getValueType());
        if (odObject == null) {
            odObject = cc.getSuperClassObjectDescription(o.getClass(), odObject);
        }
        if (odKey == null) {
            odKey = cc.getSuperClassObjectDescription(key.getValueType(), odKey);
        }
        return ObjectUtilities.equal((Object)odKey, (Object)odObject);
    }

    public void write(Writer writer) throws IOException, ReportWriterException {
        ElementStyleSheet[] parents = this.elementStyleSheet.getParents();
        int p = 0;
        while (p < parents.length) {
            ElementStyleSheet parent = parents[p];
            if (!this.isDefaultStyleSheet(parent)) {
                CommentHintPath extendsPath = this.commentPath.getInstance();
                extendsPath.addName(parent.getName());
                this.writeComment(writer, extendsPath, "parser.comment.open");
                this.writeTag(writer, "extends", "name", parent.getName(), true);
            }
            ++p;
        }
        Iterator keys = this.elementStyleSheet.getDefinedPropertyNames();
        while (keys.hasNext()) {
            Object value;
            StyleKey key = (StyleKey)keys.next();
            if (key.isTransient() || (value = this.elementStyleSheet.getStyleProperty(key)) == null) continue;
            this.writeKeyValue(writer, key, value);
        }
    }

    private void writeKeyValue(Writer w, StyleKey key, Object o) throws IOException, ReportWriterException {
        ObjectDescription od = this.findObjectDescription(key, o);
        if (od == null) {
            throw new ReportWriterException("Unable to find object description for key: " + key.getName());
        }
        try {
            od.setParameterFromObject(o);
        }
        catch (ObjectFactoryException e) {
            throw new ReportWriterException("Unable to fill the parameters for key: " + key.getName(), (Exception)((Object)e));
        }
        StyleKey keyFromFactory = this.getReportWriter().getStyleKeyFactoryCollector().getStyleKey(key.getName());
        if (keyFromFactory == null) {
            throw new ReportWriterException("The stylekey " + key.getName() + " has no corresponding key description.");
        }
        AttributeList p = new AttributeList();
        p.setAttribute("name", key.getName());
        if (!this.isUseKeyObjectDescription(key, o)) {
            p.setAttribute("class", o.getClass().getName());
        }
        CommentHintPath styleKeyPath = this.commentPath.getInstance();
        styleKeyPath.addName(key);
        ArrayList parameterNames = this.getParameterNames(od);
        if (this.isBasicKey(parameterNames, od)) {
            this.writeComment(w, styleKeyPath, "parser.comment.open");
            this.writeTag(w, "basic-key", p, false);
            w.write(AbstractXMLDefinitionWriter.normalize((String)od.getParameter("value")));
            this.writeComment(w, styleKeyPath, "parser.comment.close");
            this.writeCloseTag(w, "basic-key");
        } else {
            this.writeComment(w, styleKeyPath, "parser.comment.open");
            this.writeTag(w, "compound-key", p, false);
            ObjectWriter objWriter = new ObjectWriter(this.getReportWriter(), o, od, this.getIndentLevel(), styleKeyPath);
            objWriter.write(w);
            this.writeComment(w, styleKeyPath, "parser.comment.close");
            this.writeCloseTag(w, "compound-key");
        }
    }
}

