/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.base.common;

import java.beans.IntrospectionException;
import org.jfree.report.function.Expression;
import org.jfree.report.modules.parser.base.AbstractPropertyXmlReadHandler;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.base.common.ExpressionPropertiesReadHandler;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.ParseException;
import org.jfree.xml.ParserUtil;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.SAXException;

public class ExpressionReadHandler
extends AbstractPropertyXmlReadHandler {
    public static final String DEPENCY_LEVEL_ATT = "deplevel";
    private Expression expression;

    protected XmlReadHandler getHandlerForChild(String tagName, PropertyAttributes atts) throws XmlReaderException, SAXException {
        if (tagName.equals("properties")) {
            try {
                return new ExpressionPropertiesReadHandler(this.expression);
            }
            catch (IntrospectionException introspectionException) {
                throw new XmlReaderException("Unable to create Introspector for the specified expression.");
            }
        }
        return null;
    }

    public Object getObject() throws XmlReaderException {
        return this.expression;
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        int depLevel = ParserUtil.parseInt((String)attrs.getValue(DEPENCY_LEVEL_ATT), (int)0);
        String expressionName = attrs.getValue("name");
        if (expressionName == null) {
            throw new ElementDefinitionException("Required attribute 'name' is missing.");
        }
        String className = attrs.getValue("class");
        if (className == null) {
            throw new ElementDefinitionException("Required attribute 'class' is missing.");
        }
        try {
            Class<?> fnC = ObjectUtilities.getClassLoader(((Object)((Object)this)).getClass()).loadClass(className);
            this.expression = (Expression)fnC.newInstance();
            this.expression.setName(expressionName);
            this.expression.setDependencyLevel(depLevel);
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("Expression '" + className + "' is not valid. The specified class was not found.", (Exception)e, this.getRootHandler().getLocator());
        }
        catch (IllegalAccessException e) {
            throw new ParseException("Expression " + className + "' is not valid. The specified class does not define a public default constructor.", (Exception)e, this.getRootHandler().getLocator());
        }
        catch (InstantiationException e) {
            throw new ParseException("Expression '" + className + "' is not valid. The specified class cannot be instantiated.", (Exception)e, this.getRootHandler().getLocator());
        }
        catch (ClassCastException e) {
            throw new ParseException("Expression '" + className + "' is not valid. The specified class is not an expression or function.", (Exception)e, this.getRootHandler().getLocator());
        }
    }

    protected void storeComments() throws SAXException {
        this.defaultStoreComments(new CommentHintPath(this.expression));
    }
}

