/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.html;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.jfree.io.IOUtils;
import org.jfree.report.ImageContainer;
import org.jfree.report.URLImageContainer;
import org.jfree.report.modules.output.table.html.HtmlFilesystem;
import org.jfree.report.modules.output.table.html.ref.EmptyContentReference;
import org.jfree.report.modules.output.table.html.ref.HtmlImageReference;
import org.jfree.report.modules.output.table.html.ref.HtmlReference;
import org.jfree.report.modules.output.table.html.ref.InternalStyleSheetReference;

public class StreamHtmlFilesystem
implements HtmlFilesystem {
    private final OutputStream root;
    private final boolean allowFileSources;
    private final URL baseURL;

    public StreamHtmlFilesystem(OutputStream root) {
        this(root, false, null);
    }

    public StreamHtmlFilesystem(OutputStream root, boolean allowFiles, URL baseURL) {
        if (root == null) {
            throw new NullPointerException("root stream is null");
        }
        this.root = root;
        this.allowFileSources = allowFiles;
        this.baseURL = baseURL;
    }

    public void close() throws IOException {
        this.root.flush();
    }

    public HtmlReference createCSSReference(String styleSheet) throws IOException {
        return new InternalStyleSheetReference(styleSheet);
    }

    public HtmlReference createImageReference(ImageContainer reference) throws IOException {
        if (!(reference instanceof URLImageContainer)) {
            return new EmptyContentReference();
        }
        URLImageContainer urlImageContainer = (URLImageContainer)reference;
        URL src = urlImageContainer.getSourceURL();
        if (src != null) {
            if (this.isValidSource(src)) {
                if (this.baseURL != null) {
                    return new HtmlImageReference(IOUtils.getInstance().createRelativeURL(src, this.baseURL));
                }
                return new HtmlImageReference(src.toExternalForm());
            }
        } else if (urlImageContainer.getSourceURLString() != null) {
            return new HtmlImageReference(urlImageContainer.getSourceURLString());
        }
        return new EmptyContentReference();
    }

    public OutputStream getRootStream() throws IOException {
        return this.root;
    }

    public boolean isAllowFileSources() {
        return this.allowFileSources;
    }

    private boolean isValidSource(URL src) {
        String protocol = src.getProtocol();
        return protocol.equals("http") || protocol.equals("https") || protocol.equals("ftp") || this.isAllowFileSources() && protocol.equals("file");
    }
}

