/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.html;

import java.awt.Color;
import java.awt.Stroke;
import org.jfree.report.modules.output.table.html.HtmlStyle;
import org.jfree.report.modules.output.table.html.HtmlStyleCollection;
import org.jfree.report.modules.output.table.html.HtmlTableCellStyle;
import org.jfree.report.modules.output.table.html.StyleBuilder;
import org.jfree.report.util.StrokeUtility;
import org.jfree.util.ObjectUtilities;

public class HtmlTableRowStyle
implements HtmlStyle {
    private int height;
    private Color background;
    private Color colorTop;
    private Color colorBottom;
    private Stroke borderStrokeTop;
    private Stroke borderStrokeBottom;
    private boolean tableRowBorderDefinition;

    public HtmlTableRowStyle(int height, Color background, boolean tableRowBorderDefinition) {
        this.height = height;
        this.background = background;
        this.tableRowBorderDefinition = tableRowBorderDefinition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HtmlTableRowStyle)) {
            return false;
        }
        HtmlTableRowStyle htmlTableRowStyle = (HtmlTableRowStyle)o;
        if (this.tableRowBorderDefinition) {
            if (!ObjectUtilities.equal((Object)this.borderStrokeTop, (Object)htmlTableRowStyle.borderStrokeTop)) {
                return false;
            }
            if (!ObjectUtilities.equal((Object)this.borderStrokeBottom, (Object)htmlTableRowStyle.borderStrokeBottom)) {
                return false;
            }
        }
        if (this.height != htmlTableRowStyle.height) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.background, (Object)htmlTableRowStyle.background)) {
            return false;
        }
        if (this.tableRowBorderDefinition) {
            if (!ObjectUtilities.equal((Object)this.colorBottom, (Object)htmlTableRowStyle.colorBottom)) {
                return false;
            }
            if (!ObjectUtilities.equal((Object)this.colorTop, (Object)htmlTableRowStyle.colorTop)) {
                return false;
            }
        }
        return true;
    }

    public Color getBackground() {
        return this.background;
    }

    public Stroke getBorderStrokeBottom() {
        return this.borderStrokeBottom;
    }

    public Stroke getBorderStrokeTop() {
        return this.borderStrokeTop;
    }

    public String getCSSString(boolean compact) {
        StyleBuilder styleBuilder = new StyleBuilder(compact);
        styleBuilder.append("height", String.valueOf(this.height), "pt");
        if (this.background != null) {
            styleBuilder.append("background-color", HtmlStyleCollection.getColorString(this.background));
        }
        if (this.tableRowBorderDefinition) {
            if (this.colorTop != null) {
                styleBuilder.append("border-top-width", String.valueOf(StrokeUtility.getStrokeWidth(this.borderStrokeTop)), "pt");
                styleBuilder.append("border-top-style", HtmlTableCellStyle.translateStrokeStyle(this.borderStrokeTop));
                styleBuilder.append("border-top-color", HtmlStyleCollection.getColorString(this.getColorTop()));
            }
            if (this.getColorBottom() != null) {
                styleBuilder.append("border-top-width", String.valueOf(StrokeUtility.getStrokeWidth(this.borderStrokeBottom)), "pt");
                styleBuilder.append("border-top-style", HtmlTableCellStyle.translateStrokeStyle(this.borderStrokeBottom));
                styleBuilder.append("border-bottom-color", HtmlStyleCollection.getColorString(this.getColorBottom()));
            }
        }
        return styleBuilder.toString();
    }

    public Color getColorBottom() {
        return this.colorBottom;
    }

    public Color getColorTop() {
        return this.colorTop;
    }

    public int getHeight() {
        return this.height;
    }

    public int hashCode() {
        int result = this.height;
        result = 29 * result + (this.background != null ? this.background.hashCode() : 0);
        result = 29 * result + (this.colorTop != null ? this.colorTop.hashCode() : 0);
        result = 29 * result + (this.colorBottom != null ? this.colorBottom.hashCode() : 0);
        result = 29 * result + (this.borderStrokeTop != null ? this.borderStrokeTop.hashCode() : 0);
        result = 29 * result + (this.borderStrokeBottom != null ? this.borderStrokeBottom.hashCode() : 0);
        return result;
    }

    public void setBorderBottom(Color bottom, Stroke size) {
        this.colorBottom = bottom;
        this.borderStrokeBottom = size;
    }

    public void setBorderTop(Color top, Stroke size) {
        this.colorTop = top;
        this.borderStrokeTop = size;
    }
}

