/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.base;

import java.awt.Color;
import java.awt.Stroke;
import java.util.AbstractCollection;
import java.util.HashSet;
import org.jfree.report.Anchor;
import org.jfree.report.content.Content;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.util.ObjectUtilities;

public class TableCellBackground
extends MetaElement
implements Cloneable {
    private HashSet anchors;
    private Stroke borderStrokeTop;
    private Stroke borderStrokeBottom;
    private Stroke borderStrokeLeft;
    private Stroke borderStrokeRight;
    private Color colorTop;
    private Color colorLeft;
    private Color colorBottom;
    private Color colorRight;
    private Color color;
    private static final Anchor[] EMPTY_ANCHOR_ARRAY = new Anchor[0];

    public TableCellBackground(Content elementContent, ElementStyleSheet style, Color color) {
        super(elementContent, style);
        this.color = color;
    }

    public void addAnchor(Anchor anchor) {
        if (anchor == null) {
            throw new NullPointerException();
        }
        if (this.anchors == null) {
            this.anchors = new HashSet();
        }
        this.anchors.add(anchor);
    }

    private static Color addColor(Color base, Color paint) {
        if (paint.getAlpha() == 255) {
            return paint;
        }
        float baseAlpha = (float)base.getAlpha() / 255.0f;
        float paintAlpha = (float)paint.getAlpha() / 255.0f;
        float effectiveAlpha = 1.0f - baseAlpha * paintAlpha;
        double deltaAlpha = 1.0 - (double)effectiveAlpha;
        int red = (int)((double)base.getRed() * deltaAlpha + (double)((float)paint.getRed() * effectiveAlpha));
        int green = (int)((double)base.getGreen() * deltaAlpha + (double)((float)paint.getGreen() * effectiveAlpha));
        int blue = (int)((double)base.getBlue() * deltaAlpha + (double)((float)paint.getBlue() * effectiveAlpha));
        return new Color((float)red, (float)green, (float)blue, effectiveAlpha * 255.0f);
    }

    public Object clone() throws CloneNotSupportedException {
        TableCellBackground tb = (TableCellBackground)super.clone();
        if (this.anchors != null) {
            tb.anchors = (HashSet)this.anchors.clone();
        }
        return tb;
    }

    public TableCellBackground createSplittedInstance(StrictBounds bounds) {
        try {
            StrictBounds originalBounds = this.getBounds();
            TableCellBackground bg = (TableCellBackground)this.clone();
            bg.setBounds((StrictBounds)bounds.clone());
            if (!bounds.contains(originalBounds.getX(), originalBounds.getY()) && bg.anchors != null) {
                bg.anchors.clear();
            }
            long orgX2 = originalBounds.getX() + originalBounds.getWidth();
            long orgY2 = originalBounds.getY() + originalBounds.getHeight();
            if (bounds.getX() > orgX2 || bounds.getY() > orgY2 || bounds.getX() == orgX2 && bounds.getY() == orgY2) {
                bg.setBorderTop(null, null);
                bg.setBorderBottom(null, null);
                bg.setBorderLeft(null, null);
                bg.setBorderRight(null, null);
                bg.setColor(null);
            } else {
                if (bg.getTopBorderPos() != this.getTopBorderPos()) {
                    bg.setBorderTop(null, null);
                }
                if (bg.getLeftBorderPos() != this.getLeftBorderPos()) {
                    bg.setBorderLeft(null, null);
                }
                bg.setBorderRight(null, null);
                bg.setBorderBottom(null, null);
            }
            return bg;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone caused an unexpected error.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableCellBackground)) {
            return false;
        }
        TableCellBackground tableCellBackground = (TableCellBackground)o;
        if (!ObjectUtilities.equal((Object)this.borderStrokeBottom, (Object)tableCellBackground.borderStrokeBottom)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.borderStrokeLeft, (Object)tableCellBackground.borderStrokeLeft)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.borderStrokeRight, (Object)tableCellBackground.borderStrokeRight)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.borderStrokeTop, (Object)tableCellBackground.borderStrokeTop)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.color, (Object)tableCellBackground.color)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.colorBottom, (Object)tableCellBackground.colorBottom)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.colorRight, (Object)tableCellBackground.colorRight)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.colorLeft, (Object)tableCellBackground.colorLeft)) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.colorTop, (Object)tableCellBackground.colorTop);
    }

    public Anchor[] getAnchors() {
        if (this.anchors == null) {
            return EMPTY_ANCHOR_ARRAY;
        }
        return ((AbstractCollection)this.anchors).toArray(new Anchor[this.anchors.size()]);
    }

    public Stroke getBorderStrokeBottom() {
        return this.borderStrokeBottom;
    }

    public Stroke getBorderStrokeLeft() {
        return this.borderStrokeLeft;
    }

    public Stroke getBorderStrokeRight() {
        return this.borderStrokeRight;
    }

    public Stroke getBorderStrokeTop() {
        return this.borderStrokeTop;
    }

    public long getBottomBorderPos() {
        StrictBounds bounds = this.getBounds();
        return bounds.getY() + bounds.getHeight();
    }

    public Color getColor() {
        return this.color;
    }

    public Color getColorBottom() {
        return this.colorBottom;
    }

    public Color getColorLeft() {
        return this.colorLeft;
    }

    public Color getColorRight() {
        return this.colorRight;
    }

    public Color getColorTop() {
        return this.colorTop;
    }

    public long getLeftBorderPos() {
        StrictBounds cellBounds = this.getBounds();
        return cellBounds.getX();
    }

    public long getRightBorderPos() {
        StrictBounds cellBounds = this.getBounds();
        return cellBounds.getX() + cellBounds.getWidth();
    }

    public long getTopBorderPos() {
        StrictBounds cellBounds = this.getBounds();
        return cellBounds.getY();
    }

    public boolean hasAnchors() {
        if (this.anchors == null) {
            return false;
        }
        return !this.anchors.isEmpty();
    }

    public int hashCode() {
        int result = this.borderStrokeBottom != null ? this.borderStrokeBottom.hashCode() : 0;
        result = 29 * result + (this.borderStrokeTop != null ? this.borderStrokeTop.hashCode() : 0);
        result = 29 * result + (this.borderStrokeLeft != null ? this.borderStrokeLeft.hashCode() : 0);
        result = 29 * result + (this.borderStrokeRight != null ? this.borderStrokeRight.hashCode() : 0);
        result = 29 * result + (this.colorTop != null ? this.colorTop.hashCode() : 0);
        result = 29 * result + (this.colorLeft != null ? this.colorLeft.hashCode() : 0);
        result = 29 * result + (this.colorBottom != null ? this.colorBottom.hashCode() : 0);
        result = 29 * result + (this.colorRight != null ? this.colorRight.hashCode() : 0);
        result = 29 * result + (this.color != null ? this.color.hashCode() : 0);
        return result;
    }

    public TableCellBackground merge(TableCellBackground background, StrictBounds cellBounds) {
        StrictBounds bounds = this.getBounds();
        StrictBounds backgroundBounds = background.getBounds();
        boolean thisIsALine = bounds.getHeight() == 0L || bounds.getWidth() == 0L;
        boolean otherIsALine = backgroundBounds.getHeight() == 0L || backgroundBounds.getWidth() == 0L;
        TableCellBackground merged = background.normalize(cellBounds);
        Color orgColor = this.getColor();
        if (!otherIsALine && !thisIsALine) {
            if (orgColor == null) {
                merged.setColor(background.getColor());
            } else if (background.getColor() != null) {
                Color color = TableCellBackground.addColor(orgColor, background.getColor());
                merged.setColor(color);
            } else {
                merged.setColor(orgColor);
            }
        } else if (!thisIsALine) {
            merged.setColor(orgColor);
        }
        if (cellBounds.contains(backgroundBounds.getX(), backgroundBounds.getY()) && background.anchors != null) {
            if (merged.anchors == null) {
                merged.anchors = new HashSet(background.anchors);
            } else {
                merged.anchors.addAll(background.anchors);
            }
        }
        if (merged.getColorTop() == null) {
            merged.setBorderTop(this.getColorTop(), this.getBorderStrokeTop());
        }
        if (merged.getColorLeft() == null) {
            merged.setBorderLeft(this.getColorLeft(), this.getBorderStrokeLeft());
        }
        return merged;
    }

    public TableCellBackground normalize(StrictBounds bounds) {
        try {
            StrictBounds originalBounds = this.getBounds();
            TableCellBackground bg = (TableCellBackground)this.clone();
            bg.setBounds((StrictBounds)bounds.clone());
            if (!bounds.contains(originalBounds.getX(), originalBounds.getY()) && bg.anchors != null) {
                bg.anchors.clear();
            }
            long orgX2 = originalBounds.getX() + originalBounds.getWidth();
            long orgY2 = originalBounds.getY() + originalBounds.getHeight();
            if (bounds.getX() > orgX2 || bounds.getY() > orgY2 || bounds.getX() == orgX2 && bounds.getY() == orgY2) {
                bg.setBorderTop(null, null);
                bg.setBorderBottom(null, null);
                bg.setBorderLeft(null, null);
                bg.setBorderRight(null, null);
                bg.setColor(null);
            } else if (bounds.getX() == orgX2) {
                bg.setBorderTop(null, null);
                bg.setBorderBottom(null, null);
                if (bg.getColorLeft() == null) {
                    bg.setBorderLeft(this.getColorRight(), this.getBorderStrokeRight());
                }
                bg.setBorderRight(null, null);
                bg.setColor(null);
            } else if (bounds.getY() == orgY2) {
                if (bg.getColorTop() == null) {
                    bg.setBorderTop(this.getColorBottom(), this.getBorderStrokeBottom());
                }
                bg.setBorderBottom(null, null);
                bg.setBorderLeft(null, null);
                bg.setBorderRight(null, null);
                bg.setColor(null);
            } else {
                if (bg.getTopBorderPos() != this.getTopBorderPos()) {
                    bg.setBorderTop(null, null);
                }
                if (bg.getLeftBorderPos() != this.getLeftBorderPos()) {
                    bg.setBorderLeft(null, null);
                }
                bg.setBorderRight(null, null);
                bg.setBorderBottom(null, null);
            }
            return bg;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone caused an unexpected error.");
        }
    }

    public void setBorderBottom(Color color, Stroke stroke) {
        if (stroke == null) {
            this.colorBottom = null;
            this.borderStrokeBottom = null;
        } else {
            this.colorBottom = color;
            this.borderStrokeBottom = stroke;
        }
    }

    public void setBorderLeft(Color color, Stroke stroke) {
        if (stroke == null) {
            this.colorLeft = null;
            this.borderStrokeLeft = null;
        } else {
            this.colorLeft = color;
            this.borderStrokeLeft = stroke;
        }
    }

    public void setBorderRight(Color color, Stroke stroke) {
        if (stroke == null) {
            this.colorRight = null;
            this.borderStrokeRight = null;
        } else {
            this.colorRight = color;
            this.borderStrokeRight = stroke;
        }
    }

    public void setBorderTop(Color color, Stroke stroke) {
        if (stroke == null) {
            this.colorTop = null;
            this.borderStrokeTop = null;
        } else {
            this.colorTop = color;
            this.borderStrokeTop = stroke;
        }
    }

    protected void setColor(Color color) {
        this.color = color;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("TableCellBackground={bounds=");
        b.append(this.getBounds());
        b.append(", color=");
        b.append(this.color);
        b.append(", colorTop=");
        b.append(this.colorTop);
        b.append(", widthTop=");
        b.append(this.borderStrokeTop);
        b.append(", colorLeft=");
        b.append(this.colorLeft);
        b.append(", widthLeft=");
        b.append(this.borderStrokeLeft);
        b.append(", colorBottom=");
        b.append(this.colorBottom);
        b.append(", widthBottom=");
        b.append(this.borderStrokeBottom);
        b.append(", colorRight=");
        b.append(this.colorRight);
        b.append(", widthRight=");
        b.append(this.borderStrokeRight);
        b.append("}");
        return b.toString();
    }
}

