/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.plaintext;

import java.util.HashMap;
import org.jfree.report.modules.output.pageable.plaintext.FontMapper;
import org.jfree.report.style.FontDefinition;

public class DefaultFontMapper
implements FontMapper {
    private HashMap fontMapping = new HashMap();
    private byte defaultFont = 0;

    public void addFontMapping(String fontName, byte printerCode) {
        if (fontName == null) {
            throw new NullPointerException();
        }
        this.fontMapping.put(fontName, new Byte(printerCode));
    }

    public byte getDefaultFont() {
        return this.defaultFont;
    }

    public byte getPrinterFont(FontDefinition fontDefinition) {
        Byte b = (Byte)this.fontMapping.get(fontDefinition.getFontName());
        if (b != null) {
            return b;
        }
        return this.handleDefault(fontDefinition);
    }

    protected byte handleDefault(FontDefinition fd) {
        if (fd.isCourier()) {
            return 2;
        }
        if (fd.isSerif()) {
            return 0;
        }
        if (fd.isSansSerif()) {
            return 5;
        }
        return this.defaultFont;
    }

    public void removeFontMapping(String fontName) {
        this.fontMapping.remove(fontName);
    }

    public void setDefaultFont(byte defaultFont) {
        this.defaultFont = defaultFont;
    }
}

