/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.base.operations;

import org.jfree.report.Element;
import org.jfree.report.ElementAlignment;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentCreationException;
import org.jfree.report.content.EmptyContent;
import org.jfree.report.content.MultipartContent;
import org.jfree.report.layout.LayoutSupport;
import org.jfree.report.modules.output.meta.MetaBandProducer;
import org.jfree.report.modules.output.pageable.base.operations.AlignmentTools;
import org.jfree.report.modules.output.pageable.base.operations.HorizontalBoundsAlignment;
import org.jfree.report.modules.output.pageable.base.operations.VerticalBoundsAlignment;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.ElementLayoutInformation;
import org.jfree.report.util.geom.StrictBounds;

public class AligningMetaBandProducer
extends MetaBandProducer {
    public AligningMetaBandProducer(LayoutSupport support) {
        super(support);
    }

    protected Content alignContent(Content content, StrictBounds bounds, ElementAlignment hAlign, ElementAlignment vAlign) {
        VerticalBoundsAlignment vba = AlignmentTools.getVerticalLayout(vAlign, bounds);
        StrictBounds minimumContentSize = content.getMinimumContentSize();
        if (minimumContentSize == null) {
            return EmptyContent.getDefaultEmptyContent();
        }
        StrictBounds cb = vba.align((StrictBounds)minimumContentSize.clone());
        long verticalShift = cb.getY() - minimumContentSize.getY();
        content.translate(0L, verticalShift);
        return this.alignHorizontalContent(content, bounds, hAlign);
    }

    protected Content alignHorizontalContent(Content content, StrictBounds bounds, ElementAlignment hAlign) {
        HorizontalBoundsAlignment hba = AlignmentTools.getHorizontalLayout(hAlign, bounds);
        StrictBounds minimumContentSize = content.getMinimumContentSize();
        if (minimumContentSize == null) {
            return EmptyContent.getDefaultEmptyContent();
        }
        StrictBounds cb = hba.align((StrictBounds)minimumContentSize.clone());
        long horizontalShift = cb.getX() - minimumContentSize.getX();
        content.translate(horizontalShift, 0L);
        if (content instanceof MultipartContent) {
            MultipartContent mp = (MultipartContent)content;
            int size = mp.getContentPartCount();
            int i = 0;
            while (i < size) {
                this.alignHorizontalContent(mp.getContentPart(i), bounds, hAlign);
                ++i;
            }
        }
        return content;
    }

    protected Content createContent(Element e, ElementStyleSheet styleSheet) throws ContentCreationException {
        StrictBounds bounds = (StrictBounds)styleSheet.getStyleProperty(ElementStyleSheet.BOUNDS);
        ElementAlignment hAlign = (ElementAlignment)styleSheet.getStyleProperty(ElementStyleSheet.ALIGNMENT);
        ElementAlignment vAlign = (ElementAlignment)styleSheet.getStyleProperty(ElementStyleSheet.VALIGNMENT);
        LayoutSupport support = this.getLayoutSupport();
        ElementLayoutInformation eli = new ElementLayoutInformation(bounds);
        Content content = support.getContentFactory().createContentForElement(e, eli, support);
        return this.alignContent(content, bounds, hAlign, vAlign);
    }
}

