/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.base;

import java.util.ArrayList;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.pageable.base.PageProcess;
import org.jfree.report.states.ReportState;
import org.jfree.report.states.ReportStateProgress;
import org.jfree.report.util.WeakReferenceList;

public class ReportStateList {
    private static final int MASTERPOSITIONS_MAX = 10;
    private static final int MASTERPOSITIONS_MED = 4;
    private static final int PRIMARY_MAX = 20;
    private static final int MASTER4_MAX = 120;
    private ArrayList masterStates10;
    private ArrayList masterStates4;
    private ArrayList primaryStates;
    private int size;
    private PageProcess pageProcess;

    public ReportStateList(PageProcess proc) {
        if (proc == null) {
            throw new NullPointerException("ReportProcessor null");
        }
        this.pageProcess = proc;
        this.primaryStates = new ArrayList();
        this.masterStates4 = new ArrayList();
        this.masterStates10 = new ArrayList();
    }

    public void add(ReportState state) {
        class Org_jfree_report_modules_output_pageable_base_ReportStateList$1 {
            /* synthetic */ Org_jfree_report_modules_output_pageable_base_ReportStateList$1() {
            }
        }
        if (state == null) {
            throw new NullPointerException();
        }
        if (state.isFinish()) {
            throw new IllegalArgumentException();
        }
        if (this.size() < 20) {
            this.primaryStates.add(state);
            ++this.size;
        } else if (this.size() < 120) {
            int secPos = this.size() - 20;
            int masterPos = this.getMasterPos(secPos, 4);
            if (masterPos >= this.masterStates4.size()) {
                MasterList master = new MasterList(null, this, 4);
                this.masterStates4.add(master);
                master.add(state);
            } else {
                MasterList master = (MasterList)this.masterStates4.get(masterPos);
                master.add(state);
            }
            ++this.size;
        } else {
            int thirdPos = this.size() - 120;
            int masterPos = this.getMasterPos(thirdPos, 10);
            if (masterPos >= this.masterStates10.size()) {
                MasterList master = new MasterList(null, this, 10);
                this.masterStates10.add(master);
                master.add(state);
            } else {
                MasterList master = (MasterList)this.masterStates10.get(masterPos);
                master.add(state);
            }
            ++this.size;
        }
    }

    public void clear() {
        this.masterStates10.clear();
        this.masterStates4.clear();
        this.primaryStates.clear();
        this.size = 0;
    }

    public ReportState get(int index) {
        if (index >= this.size() || index < 0) {
            throw new IndexOutOfBoundsException("Index is invalid. Index was " + index + "; size was " + this.size());
        }
        if (index < 20) {
            return (ReportState)this.primaryStates.get(index);
        }
        if (index < 120) {
            MasterList master = (MasterList)this.masterStates4.get(this.getMasterPos(index -= 20, 4));
            return (ReportState)master.get(index);
        }
        MasterList master = (MasterList)this.masterStates10.get(this.getMasterPos(index -= 120, 10));
        return (ReportState)master.get(index);
    }

    private int getMasterPos(int pos, int maxListSize) {
        return pos / maxListSize;
    }

    protected PageProcess getPageProcess() {
        return this.pageProcess;
    }

    public int size() {
        return this.size;
    }

    private static final class MasterList
    extends WeakReferenceList {
        private final ReportStateList master;

        /* synthetic */ MasterList(1 $0, ReportStateList $1, int $2) {
            this($1, $2);
        }

        private MasterList(ReportStateList list, int maxChildCount) {
            super(maxChildCount);
            this.master = list;
        }

        protected ReportState processDummyPage(ReportState currPage, boolean failOnError) throws ReportProcessingException {
            PageProcess pageProcess = this.master.getPageProcess();
            ReportState state = pageProcess.processPage(currPage, failOnError);
            pageProcess.clear();
            return state;
        }

        protected Object restoreChild(int index) {
            ReportState master = (ReportState)this.getMaster();
            if (master == null) {
                return null;
            }
            int max = this.getChildPos(index);
            try {
                return this.restoreState(max, master);
            }
            catch (ReportProcessingException reportProcessingException) {
                return null;
            }
        }

        protected ReportState restoreState(int count, ReportState rootstate) throws ReportProcessingException {
            if (rootstate == null) {
                throw new NullPointerException("Master is null");
            }
            ReportState state = rootstate;
            ReportStateProgress progress = null;
            int i = 0;
            while (i <= count) {
                progress = state.createStateProgress(progress);
                state = this.processDummyPage(state, true);
                this.set(state, i + 1);
                if (state.isFinish()) {
                    return state;
                }
                if (!state.isProceeding(progress)) {
                    return null;
                }
                ++i;
            }
            return state;
        }
    }
}

