/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.referencedoc;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import org.jfree.report.modules.parser.ext.factory.stylekey.StyleKeyFactory;
import org.jfree.report.modules.parser.ext.factory.stylekey.StyleKeyFactoryCollector;
import org.jfree.report.style.StyleKey;

public class StyleKeyReferenceTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"stylekey-factory", "key-name", "key-class", "inherit", "transient"};
    private final ArrayList rows = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public StyleKeyReferenceTableModel(StyleKeyFactoryCollector cf) {
        this.addStyleKeyFactoryCollector(cf);
    }

    private void addStyleKeyFactory(StyleKeyFactory cf) {
        Iterator it = cf.getRegisteredKeys();
        ArrayList<String> factories = new ArrayList<String>();
        while (it.hasNext()) {
            String c = (String)it.next();
            factories.add(c);
        }
        Collections.sort(factories);
        it = ((AbstractList)factories).iterator();
        while (it.hasNext()) {
            String keyName = (String)it.next();
            StyleKey key = cf.getStyleKey(keyName);
            this.rows.add(new StylekeyDescriptionRow(cf, key));
        }
    }

    private void addStyleKeyFactoryCollector(StyleKeyFactoryCollector cf) {
        Iterator it = cf.getFactories();
        while (it.hasNext()) {
            StyleKeyFactory cfact = (StyleKeyFactory)it.next();
            if (cfact instanceof StyleKeyFactoryCollector) {
                this.addStyleKeyFactoryCollector((StyleKeyFactoryCollector)cfact);
                continue;
            }
            this.addStyleKeyFactory(cfact);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex < 3) {
            return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = StyleKeyReferenceTableModel.class$("java.lang.String"));
        }
        return class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = StyleKeyReferenceTableModel.class$("java.lang.Boolean"));
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        StylekeyDescriptionRow or = (StylekeyDescriptionRow)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return String.valueOf(or.getKeyFactory().getClass().getName());
            }
            case 1: {
                return String.valueOf(or.getKey().getName());
            }
            case 2: {
                return String.valueOf(or.getKey().getValueType().getName());
            }
            case 3: {
                return or.getKey().isInheritable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return or.getKey().isTransient() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    private static class StylekeyDescriptionRow {
        private final StyleKeyFactory keyFactory;
        private final StyleKey key;

        public StylekeyDescriptionRow(StyleKeyFactory keyFactory, StyleKey key) {
            this.keyFactory = keyFactory;
            this.key = key;
        }

        public StyleKey getKey() {
            return this.key;
        }

        public StyleKeyFactory getKeyFactory() {
            return this.keyFactory;
        }
    }
}

