/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.pdf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.report.JFreeReport;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.modules.gui.base.components.AbstractExportDialog;
import org.jfree.report.modules.gui.base.components.EncodingComboBoxModel;
import org.jfree.report.util.EncodingSupport;
import org.jfree.report.util.StringUtil;
import org.jfree.ui.FilesystemFilter;
import org.jfree.ui.action.ActionButton;
import org.jfree.util.Configuration;
import org.jfree.util.Log;

public class PDFSaveDialog
extends AbstractExportDialog {
    private static final int CBMODEL_NOPRINTING = 0;
    private static final int CBMODEL_DEGRADED = 1;
    private static final int CBMODEL_FULL = 2;
    private Action actionSecuritySelection;
    private Action actionSelectFile;
    private JTextField txFilename;
    private JTextField txAuthor;
    private JTextField txTitle;
    private JRadioButton rbSecurityNone;
    private JRadioButton rbSecurity40Bit;
    private JRadioButton rbSecurity128Bit;
    private JTextField txUserPassword;
    private JTextField txOwnerPassword;
    private JTextField txConfUserPassword;
    private JTextField txConfOwnerPassword;
    private JCheckBox cxAllowCopy;
    private JCheckBox cxAllowScreenReaders;
    private JComboBox cbAllowPrinting;
    private JCheckBox cxAllowAssembly;
    private JCheckBox cxAllowModifyContents;
    private JCheckBox cxAllowModifyAnnotations;
    private JCheckBox cxAllowFillIn;
    private DefaultComboBoxModel printingModel;
    private JComboBox cbEncoding;
    private EncodingComboBoxModel encodingModel;
    private JFileChooser fileChooser;

    public PDFSaveDialog() {
        this.initConstructor();
    }

    public PDFSaveDialog(Dialog owner) {
        super(owner);
        this.initConstructor();
    }

    public PDFSaveDialog(Frame owner) {
        super(owner);
        this.initConstructor();
    }

    public void clear() {
        this.txAuthor.setText(JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("user.name", ""));
        this.txConfOwnerPassword.setText("");
        this.txConfUserPassword.setText("");
        this.txFilename.setText("");
        this.txOwnerPassword.setText("");
        this.txTitle.setText("");
        this.txUserPassword.setText("");
        this.cxAllowAssembly.setSelected(false);
        this.cxAllowCopy.setSelected(false);
        this.cbAllowPrinting.setSelectedIndex(0);
        this.cxAllowFillIn.setSelected(false);
        this.cxAllowModifyAnnotations.setSelected(false);
        this.cxAllowModifyContents.setSelected(false);
        this.cxAllowScreenReaders.setSelected(false);
        this.rbSecurityNone.setSelected(true);
        this.getActionSecuritySelection().actionPerformed(null);
        this.cbEncoding.setSelectedIndex(this.encodingModel.indexOf(EncodingSupport.getPlatformDefaultEncoding()));
    }

    private JPanel createSecurityConfigPanel() {
        this.rbSecurityNone = new JRadioButton(this.getResources().getString("pdfsavedialog.securityNone"));
        this.rbSecurity40Bit = new JRadioButton(this.getResources().getString("pdfsavedialog.security40bit"));
        this.rbSecurity128Bit = new JRadioButton(this.getResources().getString("pdfsavedialog.security128bit"));
        this.rbSecurityNone.addActionListener(this.getActionSecuritySelection());
        this.rbSecurity40Bit.addActionListener(this.getActionSecuritySelection());
        this.rbSecurity128Bit.addActionListener(this.getActionSecuritySelection());
        this.rbSecurity128Bit.setSelected(true);
        JPanel pnlSecurityConfig = new JPanel();
        pnlSecurityConfig.setLayout(new GridLayout());
        pnlSecurityConfig.add(this.rbSecurityNone);
        pnlSecurityConfig.add(this.rbSecurity40Bit);
        pnlSecurityConfig.add(this.rbSecurity128Bit);
        ButtonGroup btGrpSecurity = new ButtonGroup();
        btGrpSecurity.add(this.rbSecurity128Bit);
        btGrpSecurity.add(this.rbSecurity40Bit);
        btGrpSecurity.add(this.rbSecurityNone);
        return pnlSecurityConfig;
    }

    private JPanel createSecurityPanel() {
        JPanel securityPanel = new JPanel();
        securityPanel.setLayout(new GridBagLayout());
        securityPanel.setBorder(BorderFactory.createTitledBorder(this.getResources().getString("pdfsavedialog.security")));
        this.createSecurityPanelComponents();
        JLabel lblUserPass = new JLabel(this.getResources().getString("pdfsavedialog.userpassword"));
        JLabel lblUserPassConfirm = new JLabel(this.getResources().getString("pdfsavedialog.userpasswordconfirm"));
        JLabel lblOwnerPass = new JLabel(this.getResources().getString("pdfsavedialog.ownerpassword"));
        JLabel lblOwnerPassConfirm = new JLabel(this.getResources().getString("pdfsavedialog.ownerpasswordconfirm"));
        JLabel lbAllowPrinting = new JLabel(this.getResources().getString("pdfsavedialog.allowPrinting"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)this.createSecurityConfigPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)lblUserPass, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.ipadx = 120;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)this.txUserPassword, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)lblOwnerPass, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.ipadx = 120;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)this.txOwnerPassword, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)lblUserPassConfirm, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.ipadx = 120;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)this.txConfUserPassword, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)lblOwnerPassConfirm, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.ipadx = 120;
        gbc.insets = new Insets(5, 5, 5, 5);
        securityPanel.add((Component)this.txConfOwnerPassword, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 3;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowCopy, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 4;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowScreenReaders, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 5;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowFillIn, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.gridy = 3;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowAssembly, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.gridy = 4;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowModifyContents, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        gbc.gridy = 5;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cxAllowModifyAnnotations, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.gridy = 6;
        gbc.anchor = 17;
        securityPanel.add((Component)lbAllowPrinting, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridwidth = 3;
        gbc.gridy = 6;
        gbc.anchor = 17;
        securityPanel.add((Component)this.cbAllowPrinting, gbc);
        return securityPanel;
    }

    private void createSecurityPanelComponents() {
        this.txUserPassword = new JPasswordField();
        this.txConfUserPassword = new JPasswordField();
        this.txOwnerPassword = new JPasswordField();
        this.txConfOwnerPassword = new JPasswordField();
        this.cxAllowCopy = new JCheckBox(this.getResources().getString("pdfsavedialog.allowCopy"));
        this.cbAllowPrinting = new JComboBox(this.getPrintingComboBoxModel());
        this.cxAllowScreenReaders = new JCheckBox(this.getResources().getString("pdfsavedialog.allowScreenreader"));
        this.cxAllowAssembly = new JCheckBox(this.getResources().getString("pdfsavedialog.allowAssembly"));
        this.cxAllowModifyContents = new JCheckBox(this.getResources().getString("pdfsavedialog.allowModifyContents"));
        this.cxAllowModifyAnnotations = new JCheckBox(this.getResources().getString("pdfsavedialog.allowModifyAnnotations"));
        this.cxAllowFillIn = new JCheckBox(this.getResources().getString("pdfsavedialog.allowFillIn"));
    }

    private Action getActionSecuritySelection() {
        if (this.actionSecuritySelection == null) {
            this.actionSecuritySelection = new ActionSecuritySelection();
        }
        return this.actionSecuritySelection;
    }

    private Action getActionSelectFile() {
        return this.actionSelectFile;
    }

    public String getAuthor() {
        return this.txAuthor.getText();
    }

    protected String getConfigurationSuffix() {
        return "_pdfexport";
    }

    public Properties getDialogContents() {
        Properties p = new Properties();
        p.setProperty("author", this.getAuthor());
        p.setProperty("filename", this.getFilename());
        p.setProperty("encoding", this.getEncoding());
        p.setProperty("title", this.getPDFTitle());
        p.setProperty("encryption", this.getEncryptionValue());
        p.setProperty("allow-assembly", String.valueOf(this.isAllowAssembly()));
        p.setProperty("allow-copy", String.valueOf(this.isAllowCopy()));
        p.setProperty("allow-degraded-printing", String.valueOf(this.isAllowDegradedPrinting()));
        p.setProperty("allow-fill-in", String.valueOf(this.isAllowFillIn()));
        p.setProperty("allow-modify-annotations", String.valueOf(this.isAllowModifyAnnotations()));
        p.setProperty("allow-modify-contents", String.valueOf(this.isAllowModifyContents()));
        p.setProperty("allow-printing", String.valueOf(this.isAllowPrinting()));
        p.setProperty("allow-screenreaders", String.valueOf(this.isAllowScreenreaders()));
        return p;
    }

    public String getEncoding() {
        if (this.cbEncoding.getSelectedIndex() == -1) {
            return EncodingSupport.getPlatformDefaultEncoding();
        }
        String encoding = this.encodingModel.getEncoding(this.cbEncoding.getSelectedIndex());
        if ("UTF-16".equals(encoding)) {
            return "Identity-H";
        }
        if ("UTF-8".equals(encoding)) {
            return "Identity-H";
        }
        return encoding;
    }

    public String getEncryptionValue() {
        if (this.rbSecurity40Bit.isSelected()) {
            return "40bit";
        }
        if (this.rbSecurity128Bit.isSelected()) {
            return "128bit";
        }
        return "none";
    }

    public String getFilename() {
        return this.txFilename.getText();
    }

    public String getOwnerPassword() {
        String txt = this.txOwnerPassword.getText();
        if (txt.equals("")) {
            return null;
        }
        return txt;
    }

    public String getPDFTitle() {
        return this.txTitle.getText();
    }

    private DefaultComboBoxModel getPrintingComboBoxModel() {
        if (this.printingModel == null) {
            Object[] data = new Object[]{this.getResources().getString("pdfsavedialog.option.noprinting"), this.getResources().getString("pdfsavedialog.option.degradedprinting"), this.getResources().getString("pdfsavedialog.option.fullprinting")};
            this.printingModel = new DefaultComboBoxModel<Object>(data);
        }
        return this.printingModel;
    }

    protected String getResourceBaseName() {
        return "org.jfree.report.modules.gui.pdf.resources.pdf-export-resources";
    }

    public String getUserPassword() {
        String txt = this.txUserPassword.getText();
        if (txt.equals("")) {
            return null;
        }
        return txt;
    }

    private void initConstructor() {
        this.setCancelAction(new ActionCancel(this.getResources()));
        this.setConfirmAction(new ActionConfirm(this.getResources()));
        this.actionSelectFile = new ActionSelectFile(this.getResources());
        this.setTitle(this.getResources().getString("pdfsavedialog.dialogtitle"));
        this.initialize();
        this.clear();
    }

    public void initFromConfiguration(Configuration config) {
        this.setAllowAssembly(this.parseBoolean("AllowAssembly", config, this.isAllowAssembly()));
        this.setAllowCopy(this.parseBoolean("AllowCopy", config, this.isAllowCopy()));
        this.setAllowFillIn(this.parseBoolean("AllowFillIn", config, this.isAllowFillIn()));
        this.setAllowModifyAnnotations(this.parseBoolean("AllowModifyAnnotations", config, this.isAllowModifyAnnotations()));
        this.setAllowModifyContents(this.parseBoolean("AllowModifyContents", config, this.isAllowModifyContents()));
        this.setAllowScreenreaders(this.parseBoolean("AllowScreenReaders", config, this.isAllowScreenreaders()));
        boolean printing = this.parseBoolean("AllowPrinting", config, this.isAllowPrinting());
        boolean degraded = this.parseBoolean("AllowDegradedPrinting", config, this.isAllowDegradedPrinting());
        this.setPrintLevel(printing, degraded);
        this.setEncryptionValue(config.getConfigProperty("org.jfree.report.modules.output.pageable.pdf.Encryption", this.getEncryptionValue()));
        this.setAuthor(config.getConfigProperty("org.jfree.report.modules.output.pageable.pdf.Author", this.getAuthor()));
        this.setUserPassword(config.getConfigProperty("org.jfree.report.modules.output.pageable.pdf.UserPassword", this.getUserPassword()));
        this.setOwnerPassword(config.getConfigProperty("org.jfree.report.modules.output.pageable.pdf.OwnerPassword", this.getOwnerPassword()));
        this.encodingModel.ensureEncodingAvailable(config.getConfigProperty("org.jfree.report.modules.output.pageable.pdf.Encoding", EncodingSupport.getPlatformDefaultEncoding()));
        this.setEncoding(config.getConfigProperty("org.jfree.report.modules.output.pageable.pdf.Encoding", this.getEncoding()));
        this.setPDFTitle(config.getConfigProperty("org.jfree.report.modules.output.pageable.pdf.Title", this.getPDFTitle()));
    }

    private void initialize() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JLabel lblFileName = new JLabel(this.getResources().getString("pdfsavedialog.filename"));
        JLabel lblAuthor = new JLabel(this.getResources().getString("pdfsavedialog.author"));
        JLabel lblTitel = new JLabel(this.getResources().getString("pdfsavedialog.title"));
        JLabel lblEncoding = new JLabel(this.getResources().getString("pdfsavedialog.encoding"));
        ActionButton btnSelect = new ActionButton(this.getActionSelectFile());
        this.txAuthor = new JTextField();
        this.txFilename = new JTextField();
        this.txTitle = new JTextField();
        this.encodingModel = EncodingComboBoxModel.createDefaultModel();
        this.encodingModel.addEncodingUnchecked("Identity-H", "PDF-Unicode encoding");
        this.encodingModel.addEncodingUnchecked("Identity-V", "PDF-Unicode encoding");
        this.encodingModel.sort();
        this.cbEncoding = new JComboBox(this.encodingModel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)lblFileName, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblTitel, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblAuthor, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.ipadx = 120;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)this.txFilename, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.ipadx = 120;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.txTitle, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.ipadx = 120;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.txAuthor, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        contentPane.add((Component)btnSelect, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.ipadx = 120;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.cbEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.gridy = 4;
        gbc.insets = new Insets(15, 0, 0, 0);
        gbc.anchor = 11;
        contentPane.add((Component)this.createSecurityPanel(), gbc);
        ActionButton btnCancel = new ActionButton(this.getCancelAction());
        ActionButton btnConfirm = new ActionButton(this.getConfirmAction());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 5, 5));
        buttonPanel.add((Component)btnConfirm);
        buttonPanel.add((Component)btnCancel);
        btnConfirm.setDefaultCapable(true);
        this.getRootPane().setDefaultButton((JButton)btnConfirm);
        buttonPanel.registerKeyboardAction(this.getConfirmAction(), KeyStroke.getKeyStroke(10, 0), 1);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.gridy = 6;
        gbc.insets = new Insets(10, 0, 0, 0);
        contentPane.add((Component)buttonPanel, gbc);
        JPanel contentWithStatus = new JPanel();
        contentWithStatus.setLayout(new BorderLayout());
        contentWithStatus.add((Component)contentPane, "Center");
        contentWithStatus.add((Component)this.getStatusBar(), "South");
        this.setContentPane(contentWithStatus);
        this.getFormValidator().registerTextField(this.txFilename);
        this.getFormValidator().registerTextField(this.txConfOwnerPassword);
        this.getFormValidator().registerTextField(this.txConfUserPassword);
        this.getFormValidator().registerTextField(this.txUserPassword);
        this.getFormValidator().registerTextField(this.txOwnerPassword);
    }

    public boolean isAllowAssembly() {
        return this.cxAllowAssembly.isSelected();
    }

    public boolean isAllowCopy() {
        return this.cxAllowCopy.isSelected();
    }

    public boolean isAllowDegradedPrinting() {
        return this.cbAllowPrinting.getSelectedIndex() == 1;
    }

    public boolean isAllowFillIn() {
        return this.cxAllowFillIn.isSelected();
    }

    public boolean isAllowModifyAnnotations() {
        return this.cxAllowModifyAnnotations.isSelected();
    }

    public boolean isAllowModifyContents() {
        return this.cxAllowModifyContents.isSelected();
    }

    public boolean isAllowPrinting() {
        return this.cbAllowPrinting.getSelectedIndex() == 2;
    }

    public boolean isAllowScreenreaders() {
        return this.cxAllowScreenReaders.isSelected();
    }

    public static void main(String[] args) {
        PDFSaveDialog dialog = new PDFSaveDialog();
        dialog.setModal(true);
        dialog.pack();
        dialog.performQueryForExport(new JFreeReport());
        System.exit(0);
    }

    private boolean parseBoolean(String key, Configuration config, boolean orgVal) {
        String val = config.getConfigProperty("org.jfree.report.modules.output.pageable.pdf." + key, String.valueOf(orgVal));
        return val.equalsIgnoreCase("true");
    }

    protected boolean performConfirm() {
        String filename = this.getFilename();
        File f = new File(filename);
        if (f.exists()) {
            String key1 = "pdfsavedialog.targetOverwriteConfirmation";
            String key2 = "pdfsavedialog.targetOverwriteTitle";
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResources().getString("pdfsavedialog.targetOverwriteConfirmation"), this.getFilename()), this.getResources().getString("pdfsavedialog.targetOverwriteTitle"), 0, 3) == 1) {
                return false;
            }
        }
        return !this.getEncryptionValue().equals("128bit") && !this.getEncryptionValue().equals("40bit") || this.txOwnerPassword.getText().trim().length() != 0 || JOptionPane.showConfirmDialog(this, this.getResources().getString("pdfsavedialog.ownerpasswordEmpty"), this.getResources().getString("pdfsavedialog.warningTitle"), 0, 2) != 1;
    }

    protected void performSelectFile() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            FilesystemFilter filter = new FilesystemFilter(".pdf", "PDF Documents");
            this.fileChooser.addChoosableFileFilter((FileFilter)filter);
            this.fileChooser.setMultiSelectionEnabled(false);
        }
        File file = new File(this.getFilename());
        this.fileChooser.setCurrentDirectory(file);
        this.fileChooser.setSelectedFile(file);
        int option = this.fileChooser.showSaveDialog(this);
        if (option == 0) {
            File selFile = this.fileChooser.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!selFileName.toUpperCase().endsWith(".PDF")) {
                selFileName = String.valueOf(selFileName) + ".pdf";
            }
            this.setFilename(selFileName);
        }
    }

    public boolean performValidate() {
        this.getStatusBar().clear();
        String filename = this.getFilename();
        if (filename.trim().length() == 0) {
            this.getStatusBar().setStatus(3, this.getResources().getString("pdfsavedialog.targetIsEmpty"));
            return false;
        }
        File f = new File(filename);
        if (f.exists()) {
            if (!f.isFile()) {
                this.getStatusBar().setStatus(3, this.getResources().getString("pdfsavedialog.targetIsNoFile"));
                return false;
            }
            if (!f.canWrite()) {
                this.getStatusBar().setStatus(3, this.getResources().getString("pdfsavedialog.targetIsNotWritable"));
                return false;
            }
            String message = MessageFormat.format(this.getResources().getString("pdfsavedialog.targetOverwriteWarning"), filename);
            this.getStatusBar().setStatus(2, message);
        }
        if (this.getEncryptionValue().equals("128bit") || this.getEncryptionValue().equals("40bit")) {
            if (!this.txUserPassword.getText().equals(this.txConfUserPassword.getText())) {
                this.getStatusBar().setStatus(3, this.getResources().getString("pdfsavedialog.userpasswordNoMatch"));
                return false;
            }
            if (!this.txOwnerPassword.getText().equals(this.txConfOwnerPassword.getText())) {
                this.getStatusBar().setStatus(3, this.getResources().getString("pdfsavedialog.ownerpasswordNoMatch"));
                return false;
            }
        }
        return true;
    }

    public void setAllowAssembly(boolean allowAssembly) {
        this.cxAllowAssembly.setSelected(allowAssembly);
    }

    public void setAllowCopy(boolean allowCopy) {
        this.cxAllowCopy.setSelected(allowCopy);
    }

    public void setAllowFillIn(boolean allowFillIn) {
        this.cxAllowFillIn.setSelected(allowFillIn);
    }

    public void setAllowModifyAnnotations(boolean allowModifyAnnotations) {
        this.cxAllowModifyAnnotations.setSelected(allowModifyAnnotations);
    }

    public void setAllowModifyContents(boolean allowModifyContents) {
        this.cxAllowModifyContents.setSelected(allowModifyContents);
    }

    public void setAllowScreenreaders(boolean allowScreenreaders) {
        this.cxAllowScreenReaders.setSelected(allowScreenreaders);
    }

    public void setAuthor(String author) {
        this.txAuthor.setText(author);
    }

    public void setDialogContents(Properties p) {
        this.setAuthor(p.getProperty("author", this.getAuthor()));
        this.setEncoding(p.getProperty("encoding", this.getEncoding()));
        this.setFilename(p.getProperty("filename", this.getFilename()));
        this.setPDFTitle(p.getProperty("title", this.getPDFTitle()));
        this.setEncryptionValue(p.getProperty("encryption", this.getEncryptionValue()));
        this.setAllowAssembly(StringUtil.parseBoolean(p.getProperty("allow-assembly"), this.isAllowAssembly()));
        this.setAllowCopy(StringUtil.parseBoolean(p.getProperty("allow-copy"), this.isAllowCopy()));
        this.setAllowFillIn(StringUtil.parseBoolean(p.getProperty("allow-fill-in"), this.isAllowFillIn()));
        this.setAllowModifyAnnotations(StringUtil.parseBoolean(p.getProperty("allow-modify-annotations"), this.isAllowModifyAnnotations()));
        this.setAllowModifyContents(StringUtil.parseBoolean(p.getProperty("allow-modify-contents"), this.isAllowModifyContents()));
        this.setPrintLevel(StringUtil.parseBoolean(p.getProperty("allow-printing"), this.isAllowPrinting()), StringUtil.parseBoolean(p.getProperty("allow-degraded-printing"), this.isAllowDegradedPrinting()));
        this.setAllowScreenreaders(StringUtil.parseBoolean(p.getProperty("allow-screenreaders"), this.isAllowScreenreaders()));
    }

    public void setEncoding(String encoding) {
        this.cbEncoding.setSelectedIndex(this.encodingModel.indexOf(encoding));
    }

    public void setEncryptionValue(String b) {
        if (b != null) {
            if (b.equals("128bit")) {
                this.rbSecurity128Bit.setSelected(true);
                this.updateSecurityPanelEnabled();
                return;
            }
            if (b.equals("40bit")) {
                this.rbSecurity40Bit.setSelected(true);
                this.updateSecurityPanelEnabled();
                return;
            }
            if (!b.equals("none")) {
                Log.warn((Object)("Invalid encryption value entered. " + b));
            }
        }
        this.rbSecurityNone.setSelected(true);
        this.updateSecurityPanelEnabled();
    }

    public void setFilename(String filename) {
        this.txFilename.setText(filename);
    }

    public void setOwnerPassword(String ownerPassword) {
        this.txOwnerPassword.setText(ownerPassword);
        this.txConfOwnerPassword.setText(ownerPassword);
    }

    public void setPDFTitle(String title) {
        this.txTitle.setText(title);
    }

    public void setPrintLevel(boolean allowPrinting, boolean degraded) {
        if (allowPrinting) {
            this.cbAllowPrinting.setSelectedIndex(2);
        } else if (degraded) {
            this.cbAllowPrinting.setSelectedIndex(1);
        } else {
            this.cbAllowPrinting.setSelectedIndex(0);
        }
    }

    public void setUserPassword(String userPassword) {
        this.txUserPassword.setText(userPassword);
        this.txConfUserPassword.setText(userPassword);
    }

    public void storeToConfiguration(ModifiableConfiguration config) {
        config.setConfigProperty("org.jfree.report.modules.output.pageable.pdf.Author", this.getAuthor());
        config.setConfigProperty("org.jfree.report.modules.output.pageable.pdf.Title", this.getPDFTitle());
        config.setConfigProperty("org.jfree.report.modules.output.pageable.pdf.Encryption", this.getEncryptionValue());
        config.setConfigProperty("org.jfree.report.modules.output.pageable.pdf.OwnerPassword", this.getOwnerPassword());
        config.setConfigProperty("org.jfree.report.modules.output.pageable.pdf.UserPassword", this.getUserPassword());
        config.setConfigProperty("org.jfree.report.modules.output.pageable.pdf.AllowAssembly", String.valueOf(this.isAllowAssembly()));
        config.setConfigProperty("org.jfree.report.modules.output.pageable.pdf.AllowCopy", String.valueOf(this.isAllowCopy()));
        config.setConfigProperty("org.jfree.report.modules.output.pageable.pdf.AllowDegradedPrinting", String.valueOf(this.isAllowDegradedPrinting()));
        config.setConfigProperty("org.jfree.report.modules.output.pageable.pdf.AllowFillIn", String.valueOf(this.isAllowFillIn()));
        config.setConfigProperty("org.jfree.report.modules.output.pageable.pdf.AllowModifyAnnotations", String.valueOf(this.isAllowModifyAnnotations()));
        config.setConfigProperty("org.jfree.report.modules.output.pageable.pdf.AllowModifyContents", String.valueOf(this.isAllowModifyContents()));
        config.setConfigProperty("org.jfree.report.modules.output.pageable.pdf.AllowPrinting", String.valueOf(this.isAllowPrinting()));
        config.setConfigProperty("org.jfree.report.modules.output.pageable.pdf.AllowScreenReaders", String.valueOf(this.isAllowScreenreaders()));
        config.setConfigProperty("org.jfree.report.modules.output.pageable.pdf.Encoding", this.getEncoding());
    }

    protected void updateSecurityPanelEnabled() {
        boolean b = !this.rbSecurityNone.isSelected();
        this.txUserPassword.setEnabled(b);
        this.txOwnerPassword.setEnabled(b);
        this.txConfOwnerPassword.setEnabled(b);
        this.txConfUserPassword.setEnabled(b);
        this.cxAllowAssembly.setEnabled(b);
        this.cxAllowCopy.setEnabled(b);
        this.cbAllowPrinting.setEnabled(b);
        this.cxAllowFillIn.setEnabled(b);
        this.cxAllowModifyAnnotations.setEnabled(b);
        this.cxAllowModifyContents.setEnabled(b);
        this.cxAllowScreenReaders.setEnabled(b);
    }

    private class ActionSecuritySelection
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            PDFSaveDialog.this.updateSecurityPanelEnabled();
        }
    }

    private class ActionConfirm
    extends AbstractExportDialog.AbstractConfirmAction {
        public ActionConfirm(ResourceBundle resources) {
            this.putValue("Name", resources.getString("pdfsavedialog.confirm"));
        }
    }

    private class ActionCancel
    extends AbstractExportDialog.AbstractCancelAction {
        public ActionCancel(ResourceBundle resources) {
            this.putValue("Name", resources.getString("pdfsavedialog.cancel"));
        }
    }

    private class ActionSelectFile
    extends AbstractAction {
        public ActionSelectFile(ResourceBundle resources) {
            this.putValue("Name", resources.getString("pdfsavedialog.selectFile"));
        }

        public void actionPerformed(ActionEvent e) {
            PDFSaveDialog.this.performSelectFile();
        }
    }
}

