/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.converter.parser;

import java.util.Stack;
import org.jfree.report.modules.gui.converter.parser.ConverterAttributes;
import org.jfree.report.modules.gui.converter.parser.TranslationTable;
import org.jfree.report.modules.gui.converter.parser.TranslationTableFactory;
import org.jfree.xml.FrontendDefaultHandler;
import org.jfree.xml.Parser;
import org.jfree.xml.util.ObjectFactory;
import org.jfree.xml.util.SimpleObjectFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ConverterParser
extends Parser {
    private final FrontendDefaultHandler base;
    private final Stack currentContext;
    private SimpleObjectFactory objectFactory = new SimpleObjectFactory();

    public ConverterParser(FrontendDefaultHandler base) {
        this.base = base;
        this.currentContext = new Stack();
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        this.base.characters(chars, start, length);
    }

    public void endDocument() throws SAXException {
        this.base.endDocument();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentContext.pop();
        this.base.endElement(uri, localName, qName);
    }

    public void error(SAXParseException exception) throws SAXException {
        this.base.error(exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.base.fatalError(exception);
    }

    public String getConfigProperty(String key) {
        return this.base.getConfigProperty(key);
    }

    public String getConfigProperty(String key, String defaultValue) {
        return this.base.getConfigProperty(key, defaultValue);
    }

    public ObjectFactory getFactoryLoader() {
        return this.objectFactory;
    }

    public Parser getInstance() {
        return new ConverterParser(this.base);
    }

    public Locator getLocator() {
        return this.base.getLocator();
    }

    public Object getResult() {
        return null;
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        this.base.notationDecl(name, publicId, systemId);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            return this.base.resolveEntity(publicId, systemId);
        }
        catch (Exception oe) {
            throw new SAXException(oe);
        }
    }

    public void setConfigProperty(String key, String value) {
        this.base.setConfigProperty(key, value);
    }

    public void setDocumentLocator(Locator locator) {
        this.base.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.base.startDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Object o;
        TranslationTableFactory.ContextRule rule = null;
        if (!this.currentContext.isEmpty() && (o = this.currentContext.peek()) instanceof TranslationTableFactory.ContextRule) {
            rule = (TranslationTableFactory.ContextRule)o;
        }
        if ((rule = TranslationTableFactory.getInstance().buildContext(rule, qName)) == null) {
            this.currentContext.push(qName);
            this.base.startElement(uri, localName, qName, attributes);
        } else {
            this.currentContext.push(rule);
            TranslationTable table = TranslationTableFactory.getInstance().getTranslationTable(rule);
            this.base.startElement(uri, localName, qName, new ConverterAttributes(attributes, table));
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        this.base.unparsedEntityDecl(name, publicId, systemId, notationName);
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.base.warning(exception);
    }
}

