/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function.strings;

import org.jfree.report.function.AbstractExpression;

public class SubStringExpression
extends AbstractExpression {
    private String field;
    private String ellipsis;
    private int start;
    private int length;

    private String appendEllipsis(String value) {
        if (this.ellipsis == null) {
            return value;
        }
        if (value == null) {
            return this.ellipsis;
        }
        return String.valueOf(value) + this.ellipsis;
    }

    public String getEllipsis() {
        return this.ellipsis;
    }

    public String getField() {
        return this.field;
    }

    public int getLength() {
        return this.length;
    }

    public int getStart() {
        return this.start;
    }

    public Object getValue() {
        Object raw = this.getDataRow().get(this.getField());
        if (raw == null) {
            return null;
        }
        String text = String.valueOf(raw);
        if (this.start >= text.length()) {
            return this.appendEllipsis(null);
        }
        if (this.start + this.length >= text.length()) {
            return text;
        }
        return this.appendEllipsis(text.substring(this.start, this.start + this.length));
    }

    public void setEllipsis(String ellipsis) {
        this.ellipsis = ellipsis;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setLength(int length) {
        if (length < 0) {
            throw new IndexOutOfBoundsException("String length cannot be negative.");
        }
        this.length = length;
    }

    public void setStart(int start) {
        if (this.length < 0) {
            throw new IndexOutOfBoundsException("String start position cannot be negative.");
        }
        this.start = start;
    }
}

