/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.Serializable;
import java.math.BigDecimal;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.Expression;
import org.jfree.report.function.FunctionUtilities;
import org.jfree.util.Log;

public class ItemSumFunction
extends AbstractFunction
implements Serializable {
    protected static final BigDecimal ZERO = new BigDecimal(0.0);
    private transient BigDecimal sum = ZERO;
    private String group;
    private String field;

    public ItemSumFunction() {
    }

    public ItemSumFunction(String name) {
        this();
        this.setName(name);
    }

    public String getField() {
        return this.field;
    }

    public String getGroup() {
        return this.group;
    }

    public Expression getInstance() {
        ItemSumFunction function = (ItemSumFunction)super.getInstance();
        function.sum = ZERO;
        return function;
    }

    protected BigDecimal getSum() {
        return this.sum;
    }

    public Object getValue() {
        return this.sum;
    }

    public void groupStarted(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            this.sum = ZERO;
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        Object fieldValue = this.getDataRow().get(this.getField());
        if (fieldValue == null) {
            return;
        }
        if (!(fieldValue instanceof Number)) {
            Log.error((Object)"ItemSumFunction.advanceItems(): problem adding number.");
            return;
        }
        Number n = (Number)fieldValue;
        this.sum = this.sum.add(new BigDecimal(n.doubleValue()));
    }

    public void reportInitialized(ReportEvent event) {
        this.sum = ZERO;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setGroup(String name) {
        this.group = name;
    }

    protected void setSum(BigDecimal sum) {
        if (sum == null) {
            throw new NullPointerException("Sum must not be null");
        }
        this.sum = sum;
    }
}

