/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.Serializable;
import org.jfree.report.DataRow;
import org.jfree.report.ResourceBundleFactory;
import org.jfree.report.function.Expression;
import org.jfree.report.function.ExpressionRuntime;
import org.jfree.util.Configuration;

public abstract class AbstractExpression
implements Expression,
Serializable {
    private String name = super.toString();
    private int dependency;
    private transient ExpressionRuntime runtime;
    private boolean active;

    protected AbstractExpression() {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public DataRow getDataRow() {
        if (this.runtime == null) {
            return null;
        }
        return this.runtime.getDataRow();
    }

    public int getDependencyLevel() {
        return this.dependency;
    }

    public Expression getInstance() {
        try {
            return (Expression)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public Configuration getReportConfiguration() {
        if (this.runtime == null) {
            return null;
        }
        return this.runtime.getConfiguration();
    }

    public ResourceBundleFactory getResourceBundleFactory() {
        if (this.runtime == null) {
            return null;
        }
        return this.runtime.getResourceBundleFactory();
    }

    protected ExpressionRuntime getRuntime() {
        return this.runtime;
    }

    public abstract Object getValue();

    public final boolean isActive() {
        return this.active;
    }

    public final void setActive(boolean active) {
        this.active = active;
    }

    public void setDependencyLevel(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("AbstractExpression.setDependencyLevel(...) : negative dependency not allowed for user-defined expressions.");
        }
        this.dependency = level;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("AbstractExpression.setName(...) : name is null.");
        }
        this.name = name;
    }

    public void setRuntime(ExpressionRuntime runtime) {
        this.runtime = runtime;
    }
}

