/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.text.DateFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.jfree.report.ReportDefinition;
import org.jfree.report.filter.DateFormatFilter;
import org.jfree.report.filter.ReportConnectable;

public class SimpleDateFormatFilter
extends DateFormatFilter
implements ReportConnectable {
    private ReportDefinition reportDefinition;
    private Locale lastLocale;
    private boolean keepState;

    public SimpleDateFormatFilter() {
        this.setFormatter(new SimpleDateFormat());
    }

    public String getFormatString() {
        return this.getSimpleDateFormat().toPattern();
    }

    public String getLocalizedFormatString() {
        return this.getSimpleDateFormat().toLocalizedPattern();
    }

    public SimpleDateFormat getSimpleDateFormat() {
        return (SimpleDateFormat)this.getFormatter();
    }

    public Object getValue() {
        Locale locale;
        if (!this.keepState && this.reportDefinition != null && (locale = this.reportDefinition.getResourceBundleFactory().getLocale()) != this.lastLocale) {
            this.lastLocale = locale;
            this.getSimpleDateFormat().setDateFormatSymbols(new DateFormatSymbols(locale));
        }
        return super.getValue();
    }

    public boolean isKeepState() {
        return this.keepState;
    }

    public void registerReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != null) {
            throw new IllegalStateException("Already connected.");
        }
        if (reportDefinition == null) {
            throw new NullPointerException("The given report definition is null");
        }
        this.reportDefinition = reportDefinition;
    }

    public void setFormatString(String format) {
        if (format == null) {
            throw new NullPointerException();
        }
        this.getSimpleDateFormat().applyPattern(format);
    }

    public void setFormatter(Format format) {
        SimpleDateFormat sdfmt = (SimpleDateFormat)format;
        super.setFormatter(sdfmt);
    }

    public void setKeepState(boolean keepState) {
        this.keepState = keepState;
    }

    public void setLocalizedFormatString(String format) {
        this.getSimpleDateFormat().applyLocalizedPattern(format);
    }

    public void setSimpleDateFormat(SimpleDateFormat format) {
        super.setFormatter(format);
    }

    public void unregisterReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != reportDefinition) {
            throw new IllegalStateException("This report definition is not registered.");
        }
        this.reportDefinition = null;
    }
}

