/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jfree.report.ReportDefinition;
import org.jfree.report.ResourceBundleFactory;
import org.jfree.report.filter.DataSource;
import org.jfree.report.filter.MessageFormatSupport;
import org.jfree.report.filter.ReportConnectable;
import org.jfree.util.ObjectUtilities;

public class ResourceMessageFormatFilter
implements ReportConnectable,
Serializable,
DataSource {
    private transient ReportDefinition reportDefinition;
    private transient String formatString;
    private transient Locale locale;
    private String formatKey;
    private String resourceIdentifier;
    private MessageFormatSupport messageFormatSupport = new MessageFormatSupport();

    public Object clone() throws CloneNotSupportedException {
        ResourceMessageFormatFilter mf = (ResourceMessageFormatFilter)super.clone();
        mf.reportDefinition = null;
        mf.messageFormatSupport = (MessageFormatSupport)this.messageFormatSupport.clone();
        return mf;
    }

    public String getFormatKey() {
        return this.formatKey;
    }

    public String getNullString() {
        return this.messageFormatSupport.getNullString();
    }

    public String getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public Object getValue() {
        Locale newLocale;
        if (this.reportDefinition == null) {
            return null;
        }
        String resourceId = this.resourceIdentifier != null ? this.resourceIdentifier : this.reportDefinition.getReportConfiguration().getConfigProperty("org.jfree.report.ResourceBundle");
        if (resourceId == null) {
            return null;
        }
        ResourceBundleFactory resourceBundleFactory = this.reportDefinition.getResourceBundleFactory();
        ResourceBundle bundle = resourceBundleFactory.getResourceBundle(resourceId);
        String newFormatString = bundle.getString(this.formatKey);
        if (!ObjectUtilities.equal((Object)newFormatString, (Object)this.formatString)) {
            this.messageFormatSupport.setFormatString(newFormatString);
            this.formatString = newFormatString;
        }
        if (!ObjectUtilities.equal((Object)(newLocale = resourceBundleFactory.getLocale()), (Object)this.locale)) {
            this.messageFormatSupport.setLocale(resourceBundleFactory.getLocale());
            this.locale = newLocale;
        }
        return this.messageFormatSupport.performFormat(this.reportDefinition.getDataRow());
    }

    public void registerReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != null) {
            throw new IllegalStateException("Already connected.");
        }
        if (reportDefinition == null) {
            throw new NullPointerException("The given report definition is null");
        }
        this.reportDefinition = reportDefinition;
    }

    public void setFormatKey(String format) {
        this.formatKey = format;
    }

    public void setNullString(String nullString) {
        this.messageFormatSupport.setNullString(nullString);
    }

    public void setResourceIdentifier(String resourceIdentifier) {
        this.resourceIdentifier = resourceIdentifier;
    }

    public void unregisterReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != reportDefinition) {
            throw new IllegalStateException("This report definition is not registered.");
        }
        this.reportDefinition = null;
    }
}

