/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.jfree.report.DataRow;
import org.jfree.report.util.CSVTokenizer;
import org.jfree.report.util.PropertyLookupParser;

public class MessageFormatSupport
implements Serializable,
Cloneable {
    private String[] fields;
    private MessageFormat format;
    private String formatString;
    private String compiledFormat;
    private String nullString;

    public Object clone() throws CloneNotSupportedException {
        MessageFormatSupport support = (MessageFormatSupport)super.clone();
        if (this.format != null) {
            support.format = (MessageFormat)this.format.clone();
        }
        return support;
    }

    public String getCompiledFormat() {
        return this.compiledFormat;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public Locale getLocale() {
        return this.format.getLocale();
    }

    public String getNullString() {
        return this.nullString;
    }

    public String performFormat(DataRow dataRow) {
        if (this.fields == null || this.format == null) {
            return null;
        }
        boolean fastProcessingPossible = this.nullString == null;
        Format[] formats = this.format.getFormats();
        boolean fastProcessing = true;
        Object[] parameters = new Object[this.fields.length];
        boolean[] replaced = new boolean[this.fields.length];
        int i = 0;
        while (i < parameters.length) {
            Object value = dataRow.get(this.fields[i]);
            Format currentFormat = formats[i];
            if (value == null) {
                parameters[i] = this.nullString;
                replaced[i] = currentFormat != null;
                fastProcessing = fastProcessing && fastProcessingPossible && !replaced[i];
            } else if (currentFormat instanceof DateFormat) {
                if (value instanceof Date) {
                    parameters[i] = value;
                    replaced[i] = false;
                } else {
                    parameters[i] = this.nullString;
                    replaced[i] = true;
                    fastProcessing = fastProcessing && fastProcessingPossible && !replaced[i];
                }
            } else if (currentFormat instanceof NumberFormat) {
                if (value instanceof Number) {
                    parameters[i] = value;
                    replaced[i] = false;
                } else {
                    parameters[i] = this.nullString;
                    replaced[i] = true;
                    fastProcessing = fastProcessing && fastProcessingPossible && !replaced[i];
                }
            } else {
                parameters[i] = value;
                replaced[i] = false;
            }
            ++i;
        }
        if (fastProcessing) {
            return this.format.format(parameters);
        }
        MessageFormat effectiveFormat = (MessageFormat)this.format.clone();
        int i2 = 0;
        while (i2 < replaced.length) {
            boolean b = replaced[i2];
            if (b) {
                effectiveFormat.setFormat(i2, null);
            }
            ++i2;
        }
        return effectiveFormat.format(parameters);
    }

    public void setFormatString(String formatString) {
        MessageCompiler compiler = new MessageCompiler();
        if (formatString == null) {
            throw new NullPointerException("Format must not be null");
        }
        this.compiledFormat = compiler.translateAndLookup(formatString);
        this.fields = compiler.getFields();
        this.format = new MessageFormat(this.compiledFormat);
        this.formatString = formatString;
    }

    public void setLocale(Locale locale) {
        this.format.setLocale(locale);
        this.format.applyPattern(this.compiledFormat);
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    protected static class MessageCompiler
    extends PropertyLookupParser {
        private ArrayList fields = new ArrayList();
        private ArrayList completeFormatString = new ArrayList();

        public MessageCompiler() {
            this.setMarkerChar('$');
            this.setOpeningBraceChar('(');
            this.setClosingBraceChar(')');
        }

        public String[] getFields() {
            return this.fields.toArray(new String[this.fields.size()]);
        }

        protected String lookupVariable(String name) {
            CSVTokenizer tokenizer = new CSVTokenizer(name, ",", "\"");
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            String varName = tokenizer.nextToken();
            StringBuffer b = new StringBuffer();
            b.append("{");
            b.append(String.valueOf(this.fields.size()));
            while (tokenizer.hasMoreTokens()) {
                b.append(",");
                b.append(tokenizer.nextToken());
            }
            b.append("}");
            String formatString = b.toString();
            this.completeFormatString.add(formatString);
            this.fields.add(varName);
            return formatString;
        }
    }
}

