/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.io.Serializable;
import java.util.Locale;
import org.jfree.report.ReportDefinition;
import org.jfree.report.ResourceBundleFactory;
import org.jfree.report.filter.DataSource;
import org.jfree.report.filter.MessageFormatSupport;
import org.jfree.report.filter.ReportConnectable;
import org.jfree.util.ObjectUtilities;

public class MessageFormatFilter
implements ReportConnectable,
Serializable,
DataSource {
    private transient ReportDefinition reportDefinition;
    private MessageFormatSupport messageFormatSupport = new MessageFormatSupport();
    private transient Locale locale;

    public Object clone() throws CloneNotSupportedException {
        MessageFormatFilter mf = (MessageFormatFilter)super.clone();
        mf.reportDefinition = null;
        mf.messageFormatSupport = (MessageFormatSupport)this.messageFormatSupport.clone();
        return mf;
    }

    public String getFormatString() {
        return this.messageFormatSupport.getFormatString();
    }

    public String getNullString() {
        return this.messageFormatSupport.getNullString();
    }

    public Object getValue() {
        if (this.reportDefinition == null) {
            return null;
        }
        ResourceBundleFactory resourceBundleFactory = this.reportDefinition.getResourceBundleFactory();
        Locale newLocale = resourceBundleFactory.getLocale();
        if (!ObjectUtilities.equal((Object)newLocale, (Object)this.locale)) {
            this.messageFormatSupport.setLocale(resourceBundleFactory.getLocale());
            this.locale = newLocale;
        }
        return this.messageFormatSupport.performFormat(this.reportDefinition.getDataRow());
    }

    public void registerReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != null) {
            throw new IllegalStateException("Already connected.");
        }
        if (reportDefinition == null) {
            throw new NullPointerException("The given report definition is null");
        }
        this.reportDefinition = reportDefinition;
    }

    public void setFormatString(String format) {
        this.messageFormatSupport.setFormatString(format);
    }

    public void setNullString(String nullString) {
        this.messageFormatSupport.setNullString(nullString);
    }

    public void unregisterReportDefinition(ReportDefinition reportDefinition) {
        if (this.reportDefinition != reportDefinition) {
            throw new IllegalStateException("This report definition is not registered.");
        }
        this.reportDefinition = null;
    }
}

