/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.elementfactory;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import org.jfree.report.Element;
import org.jfree.report.layout.StaticLayoutManager;
import org.jfree.report.style.ElementStyleSheet;

public abstract class ElementFactory {
    private String name;
    private Dimension2D minimumSize;
    private Dimension2D maximumSize;
    private Dimension2D preferredSize;
    private Point2D absolutePosition;
    private Boolean dynamicHeight;
    private Boolean layoutCachable;
    private Boolean visible;
    private String hRefTarget;
    private String hRefWindow;

    protected void applyElementName(Element e) {
        if (this.getName() != null) {
            e.setName(this.getName());
        }
    }

    protected void applyStyle(ElementStyleSheet style) {
        style.setStyleProperty(StaticLayoutManager.ABSOLUTE_POS, this.getAbsolutePosition());
        style.setStyleProperty(ElementStyleSheet.DYNAMIC_HEIGHT, this.getDynamicHeight());
        style.setStyleProperty(ElementStyleSheet.MAXIMUMSIZE, this.getMaximumSize());
        style.setStyleProperty(ElementStyleSheet.MINIMUMSIZE, this.getMinimumSize());
        style.setStyleProperty(ElementStyleSheet.PREFERREDSIZE, this.getPreferredSize());
        style.setStyleProperty(ElementStyleSheet.ELEMENT_LAYOUT_CACHEABLE, this.getLayoutCachable());
        style.setStyleProperty(ElementStyleSheet.VISIBLE, this.getVisible());
        style.setStyleProperty(ElementStyleSheet.HREF_TARGET, this.getHRefTarget());
        style.setStyleProperty(ElementStyleSheet.HREF_WINDOW, this.getHRefWindow());
    }

    public abstract Element createElement();

    public Point2D getAbsolutePosition() {
        return this.absolutePosition;
    }

    public Boolean getDynamicHeight() {
        return this.dynamicHeight;
    }

    public String getHRefTarget() {
        return this.hRefTarget;
    }

    public String getHRefWindow() {
        return this.hRefWindow;
    }

    public Boolean getLayoutCachable() {
        return this.layoutCachable;
    }

    public Dimension2D getMaximumSize() {
        return this.maximumSize;
    }

    public Dimension2D getMinimumSize() {
        return this.minimumSize;
    }

    public String getName() {
        return this.name;
    }

    public Dimension2D getPreferredSize() {
        return this.preferredSize;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setAbsolutePosition(Point2D absolutePosition) {
        this.absolutePosition = absolutePosition;
    }

    public void setDynamicHeight(Boolean dynamicHeight) {
        this.dynamicHeight = dynamicHeight;
    }

    public void setHRefTarget(String hRefTarget) {
        this.hRefTarget = hRefTarget;
    }

    public void setHRefWindow(String hRefWindow) {
        this.hRefWindow = hRefWindow;
    }

    public void setLayoutCachable(Boolean layoutCachable) {
        this.layoutCachable = layoutCachable;
    }

    public void setMaximumSize(Dimension2D maximumSize) {
        this.maximumSize = maximumSize;
    }

    public void setMinimumSize(Dimension2D minimumSize) {
        this.minimumSize = minimumSize;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPreferredSize(Dimension2D preferredSize) {
        this.preferredSize = preferredSize;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }
}

