/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.content;

import org.jfree.report.content.Content;
import org.jfree.report.content.ContentType;
import org.jfree.report.content.EmptyContent;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.ui.Drawable;

public class DrawableContent
implements Content {
    private Drawable drawable;
    private final StrictBounds bounds;
    private final StrictBounds imageArea;

    public DrawableContent(Drawable ref, StrictBounds bounds) {
        this(ref, bounds, new StrictBounds(0L, 0L, bounds.getWidth(), bounds.getHeight()));
    }

    protected DrawableContent(Drawable ref, StrictBounds bounds, StrictBounds imageArea) {
        if (ref == null) {
            throw new NullPointerException("ImageContainer must not be null for ImageContent.");
        }
        if (bounds == null) {
            throw new NullPointerException("Bounds must not be null");
        }
        if (imageArea == null) {
            throw new NullPointerException("ImageArea must not be null.");
        }
        this.drawable = ref;
        this.bounds = bounds;
        this.imageArea = imageArea;
    }

    public StrictBounds getBounds() {
        return (StrictBounds)this.bounds.clone();
    }

    public Drawable getContent() {
        return this.drawable;
    }

    public Content getContentForBounds(StrictBounds bounds) {
        if (!StrictBounds.intersects(bounds, this.bounds)) {
            return EmptyContent.getDefaultEmptyContent();
        }
        StrictBounds myBounds = bounds.createIntersection(this.bounds);
        StrictBounds imageArea = new StrictBounds(this.mapHorizontalPointToImage(myBounds.getX() - this.bounds.getX()), this.mapVerticalPointToImage(myBounds.getY() - this.bounds.getY()), this.mapHorizontalPointToImage(myBounds.getWidth()), this.mapVerticalPointToImage(myBounds.getHeight()));
        return new DrawableContent(this.drawable, myBounds, imageArea);
    }

    public ContentType getContentType() {
        return ContentType.DRAWABLE;
    }

    public StrictBounds getImageArea() {
        return (StrictBounds)this.imageArea.clone();
    }

    public StrictBounds getMinimumContentSize() {
        return this.getBounds();
    }

    private long mapHorizontalPointToImage(long px) {
        return px * this.imageArea.getWidth() / this.bounds.getWidth();
    }

    private long mapVerticalPointToImage(long px) {
        return px * this.imageArea.getHeight() / this.bounds.getHeight();
    }

    public void translate(long x, long y) {
        this.bounds.setRect(this.bounds.getX() + x, this.bounds.getY() + y, this.bounds.getWidth(), this.bounds.getHeight());
        this.imageArea.setRect(this.imageArea.getX() + x, this.imageArea.getY() + y, this.imageArea.getWidth(), this.imageArea.getHeight());
    }
}

