/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jfree.report.Group;
import org.jfree.report.ReportDefinition;
import org.jfree.report.util.ReadOnlyIterator;

public class GroupList
implements Cloneable,
Serializable {
    private transient Group[] cache;
    private ArrayList backend = new ArrayList();
    private ReportDefinition reportDefinition;
    public static final String DEFAULT_GROUP_NAME = "default";

    public GroupList() {
        this.createDefaultGroup();
    }

    protected GroupList(GroupList list) {
        this.backend.addAll(list.backend);
    }

    public void add(Group o) {
        if (o == null) {
            throw new NullPointerException("Try to add null");
        }
        this.cache = null;
        int idxOf = this.backend.indexOf(o);
        if (idxOf != -1) {
            Group g = (Group)this.backend.remove(idxOf);
            g.setReportDefinition(null);
        }
        int i = 0;
        while (i < this.backend.size()) {
            Group compareGroup = (Group)this.backend.get(i);
            if (compareGroup.compareTo(o) > 0) {
                this.backend.add(i, o);
                o.setReportDefinition(this.reportDefinition);
                return;
            }
            ++i;
        }
        this.backend.add(o);
        o.setReportDefinition(this.reportDefinition);
    }

    public void addAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add((Group)it.next());
        }
    }

    public void clear() {
        this.backend.clear();
        this.createDefaultGroup();
        this.cache = null;
    }

    public Object clone() throws CloneNotSupportedException {
        GroupList l = (GroupList)super.clone();
        Group[] groups = this.getGroupCache();
        l.backend = new ArrayList();
        l.reportDefinition = null;
        l.cache = new Group[groups.length];
        int i = 0;
        while (i < groups.length) {
            Group group = (Group)groups[i].clone();
            group.setReportDefinition(null);
            l.backend.add(group);
            l.cache[i] = group;
            ++i;
        }
        return l;
    }

    private void createDefaultGroup() {
        Group defaultGroup = new Group();
        defaultGroup.setName(DEFAULT_GROUP_NAME);
        this.add(defaultGroup);
    }

    public Group get(int i) {
        if (this.cache == null) {
            this.cache = this.backend.toArray(new Group[this.backend.size()]);
        }
        return this.cache[i];
    }

    public Group getGroupByName(String name) {
        Group[] cache = this.getGroupCache();
        int i = 0;
        while (i < cache.length) {
            if (cache[i].getName().equals(name)) {
                return cache[i];
            }
            ++i;
        }
        return null;
    }

    protected Group[] getGroupCache() {
        if (this.cache == null) {
            this.cache = this.backend.toArray(new Group[this.backend.size()]);
        }
        return this.cache;
    }

    public ReportDefinition getReportDefinition() {
        return this.reportDefinition;
    }

    public Iterator iterator() {
        return new ReadOnlyIterator(((AbstractList)this.backend).iterator());
    }

    public boolean remove(Group o) {
        if (o == null) {
            throw new NullPointerException();
        }
        this.cache = null;
        int idxOf = this.backend.indexOf(o);
        if (idxOf == -1) {
            return false;
        }
        Group g = (Group)this.backend.remove(idxOf);
        g.setReportDefinition(null);
        if (this.backend.size() == 0) {
            this.createDefaultGroup();
        }
        return true;
    }

    public void setReportDefinition(ReportDefinition reportDefinition) {
        this.reportDefinition = reportDefinition;
        int i = 0;
        while (i < this.backend.size()) {
            Group group = (Group)this.backend.get(i);
            group.setReportDefinition(reportDefinition);
            ++i;
        }
    }

    public int size() {
        return this.backend.size();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("GroupList={backend='");
        b.append(this.backend);
        b.append("'} ");
        return b.toString();
    }
}

