/*
 * Decompiled with CFR 0.152.
 */
package jplot3dp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import jhplot.FPR;
import jplot3dp.HelpDialog;
import jplot3dp.ModelView;
import jplot3dp.OptionsDialog;
import jplot3dp.Utils;

public class MainComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    public ModelView modelView;
    private HelpDialog helpDialog;
    private Frame parentFrame;
    private OptionsDialog optionsDialog;
    private int saveSignature = 0x55560000;
    private String lastFileName = null;
    private String lastDirectory = null;
    private JButton btnNew;
    private JButton btnLoad;
    private JButton btnSave;
    private JButton btnSaveAs;
    private JButton btnExportPng;
    private JButton btnEdit;
    private JToggleButton btnSolid;
    private JToggleButton btnAxes;

    public void handleCommand(String s) {
        if (s.equals("FileNew")) {
            if (!this.isDirty("Do you want to save before creating a new file?")) {
                this.newFile();
            }
        } else if (s.equals("FileOpen")) {
            this.loadFromFile();
        } else if (s.equals("FileSave")) {
            this.saveToFile(false);
        } else if (s.equals("FileSaveAs")) {
            this.saveToFile(true);
        } else if (s.equals("ExportPNG")) {
            this.exportPNG();
        } else if (s.equals("TogCulling")) {
            this.modelView.backCulling = 1 - this.modelView.backCulling;
            this.btnSolid.setSelected(this.modelView.backCulling != 0);
            this.modelView.repaint();
        } else if (s.equals("TogAxes")) {
            this.modelView.bShowAxes = !this.modelView.bShowAxes;
            this.btnAxes.setSelected(this.modelView.bShowAxes);
            this.modelView.repaint();
        } else if (s.equals("EditScene")) {
            this.optionsDialog.setVisible(true);
        } else if (s.equals("HelpReadme")) {
            this.helpDialog.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "Invalid command passed to handler: " + s, "Error", 0);
        }
    }

    public boolean isDirty(String s) {
        if (Utils.applet != null || !this.optionsDialog.isDirty()) {
            return false;
        }
        int i = JOptionPane.showConfirmDialog(this, s, "File Modified", 1, 2);
        switch (i) {
            case 0: {
                if (!this.saveToFile(false)) break;
                return false;
            }
            case 1: {
                return false;
            }
        }
        return true;
    }

    public void setFunction(FPR func) {
        if (func.getDivU() == 0 || func.getDivV() == 0) {
            func.setDivisions(21, 21);
        }
        if (this.optionsDialog != null) {
            this.optionsDialog.addFunction(func);
            this.optionsDialog.reLoadAll();
            this.optionsDialog.setDirty(false);
        }
        this.modelView.bShowAxes = true;
        this.btnAxes.setSelected(this.modelView.bShowAxes);
        this.modelView.backCulling = 1;
        this.btnSolid.setSelected(this.modelView.backCulling != 0);
        this.modelView.repaint();
    }

    public ModelView getModel() {
        return this.modelView;
    }

    public void setBackgroundFrame(Color c) {
        this.modelView.setBackgroundFrame(c);
        this.modelView.repaint();
    }

    public void setFog(boolean fogEnabled) {
        this.modelView.setFog(fogEnabled);
        this.modelView.repaint();
    }

    public void setAxes(boolean bShowAxes) {
        this.modelView.bShowAxes = bShowAxes;
        this.btnAxes.setSelected(this.modelView.bShowAxes);
    }

    public void setFill(boolean bfill) {
        this.modelView.backCulling = 0;
        if (bfill) {
            this.modelView.backCulling = 1;
        }
        this.btnSolid.setSelected(this.modelView.backCulling != 0);
    }

    public double getFov() {
        return this.optionsDialog.getFov();
    }

    public void setFillColor(Color c) {
        this.optionsDialog.setFillColor(c);
    }

    public void setLineColor(Color c) {
        this.optionsDialog.setLineColor(c);
    }

    public void setFov(double d) {
        this.optionsDialog.setFov(d);
    }

    private void newFile() {
        this.modelView.reInitializeVars();
        ModelView.ModelFunction modelfunction = this.modelView.functions.addFunction();
        modelfunction.expression = "x=0; y=0; z=0;";
        modelfunction.gridDivsU = 21;
        modelfunction.gridDivsV = 21;
        modelfunction.surfaceColor = Color.WHITE;
        modelfunction.parseFunction();
        if (this.optionsDialog != null) {
            this.optionsDialog.reLoadAll();
            this.optionsDialog.setDirty(false);
        }
        this.modelView.bShowAxes = false;
        this.btnAxes.setSelected(this.modelView.bShowAxes);
        this.modelView.backCulling = 1;
        this.btnSolid.setSelected(this.modelView.backCulling != 0);
        this.setLastFileName(null);
    }

    private void setLastFileName(String s) {
        this.lastFileName = s;
        if (this.parentFrame != null) {
            if (s == null) {
                this.parentFrame.setTitle("HPlot3DP");
            } else {
                this.parentFrame.setTitle("HPlot3DP - " + s.substring(s.lastIndexOf(File.separatorChar) + 1));
            }
        }
    }

    private String getFileName(boolean flag, String s) {
        JFileChooser jfilechooser = new JFileChooser();
        jfilechooser.setCurrentDirectory(new File(this.lastDirectory != null ? this.lastDirectory : System.getProperty("user.dir")));
        int i = flag ? jfilechooser.showSaveDialog(this) : jfilechooser.showOpenDialog(this);
        if (i == 0) {
            String s1;
            this.lastDirectory = s1 = jfilechooser.getSelectedFile().getPath();
            this.lastDirectory = this.lastDirectory.substring(0, this.lastDirectory.lastIndexOf(File.separatorChar));
            if (flag && s1.indexOf(46) == -1) {
                s1 = s1 + s;
            }
            if (flag && new File(s1).exists() && JOptionPane.showConfirmDialog(this, "File " + s1 + " already exists. Overwrite?", "Warning", 0, 2) == 1) {
                return null;
            }
            return s1;
        }
        return null;
    }

    public void loadFromFile() {
        this.loadFromFile(this.getFileName(false, null));
    }

    public void loadFromFile(String s) {
        if (s == null) {
            return;
        }
        try {
            DataInputStream datainputstream = new DataInputStream(new FileInputStream(s));
            int i = datainputstream.readInt() - this.saveSignature;
            if (i != 1) {
                JOptionPane.showMessageDialog(this, "File " + s + " doesn't conform save format.", "Error", 2);
                return;
            }
            this.modelView.readFromStream(datainputstream);
            this.btnSolid.setSelected(this.modelView.backCulling != 0);
            this.btnAxes.setSelected(this.modelView.bShowAxes);
            this.optionsDialog.reLoadAll();
            this.optionsDialog.setDirty(false);
            this.modelView.repaint();
            this.setLastFileName(s);
        }
        catch (IOException ioexception) {
            JOptionPane.showMessageDialog(this, "Error while loading from file " + s, "Error", 0);
        }
    }

    public boolean saveToFile(boolean bool) {
        boolean bool_4_;
        String string = bool || this.lastFileName == null ? this.getFileName(true, ".uvm") : this.lastFileName;
        if (string == null) {
            return false;
        }
        try {
            DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(string));
            dataoutputstream.writeInt(this.saveSignature + 1);
            this.modelView.writeToStream(dataoutputstream);
            this.setLastFileName(string);
            this.optionsDialog.setDirty(false);
            bool_4_ = true;
        }
        catch (IOException ioexception) {
            JOptionPane.showMessageDialog(this, "Could not save to file " + string, "Warning", 2);
            return false;
        }
        return bool_4_;
    }

    private void exportPNG() {
        String s = this.getFileName(true, ".png");
        if (s == null) {
            return;
        }
        try {
            this.modelView.saveImage(s);
        }
        catch (IOException ioexception) {
            JOptionPane.showMessageDialog(this, "Could not export to file " + s, "Warning", 2);
        }
    }

    public void update() {
        this.modelView.repaint();
    }

    public MainComponent(Frame frame) {
        this.parentFrame = frame;
        this.modelView = new ModelView();
        if (Utils.applet == null) {
            this.helpDialog = new HelpDialog("3D Graph Explorer Readme", "readme/readme.html");
        }
        ActionListener actionlistener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                MainComponent.this.handleCommand(((AbstractButton)actionevent.getSource()).getActionCommand());
            }
        };
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        JToolBar jtoolbar = new JToolBar();
        this.btnNew = new JButton(Utils.loadIcon("filenew.gif"));
        jtoolbar.add(this.btnNew);
        Utils.makeHot(this.btnNew);
        this.btnNew.setToolTipText("New File");
        this.btnNew.setActionCommand("load");
        this.btnNew.setActionCommand("FileNew");
        this.btnNew.addActionListener(actionlistener);
        if (Utils.applet == null) {
            this.btnLoad = new JButton(Utils.loadIcon("fileopen.gif"));
            jtoolbar.add(this.btnLoad);
            Utils.makeHot(this.btnLoad);
            this.btnLoad.setToolTipText("Open File");
            this.btnLoad.setActionCommand("FileOpen");
            this.btnLoad.addActionListener(actionlistener);
            this.btnSave = new JButton(Utils.loadIcon("filesave.gif"));
            jtoolbar.add(this.btnSave);
            Utils.makeHot(this.btnSave);
            this.btnSave.setToolTipText("Save File");
            this.btnSave.setActionCommand("FileSave");
            this.btnSave.addActionListener(actionlistener);
            this.btnSaveAs = new JButton(Utils.loadIcon("filesaveas.gif"));
            jtoolbar.add(this.btnSaveAs);
            Utils.makeHot(this.btnSaveAs);
            this.btnSaveAs.setToolTipText("Save File As...");
            this.btnSaveAs.setActionCommand("FileSaveAs");
            this.btnSaveAs.addActionListener(actionlistener);
            this.btnExportPng = new JButton(Utils.loadIcon("fileexportpng.gif"));
            jtoolbar.add(this.btnExportPng);
            Utils.makeHot(this.btnExportPng);
            this.btnExportPng.setToolTipText("Export Picture");
            this.btnExportPng.setActionCommand("ExportPNG");
            this.btnExportPng.addActionListener(actionlistener);
        }
        jtoolbar.addSeparator();
        this.btnSolid = new JToggleButton(Utils.loadIcon("hollow.gif"));
        jtoolbar.add(this.btnSolid);
        Utils.makeHot(this.btnSolid);
        this.btnSolid.setToolTipText("Toggle Wireframe/Solid");
        this.btnSolid.setSelectedIcon(Utils.loadIcon("solid.gif"));
        this.btnSolid.setActionCommand("TogCulling");
        this.btnSolid.addActionListener(actionlistener);
        this.btnAxes = new JToggleButton(Utils.loadIcon("axes.gif"));
        jtoolbar.add(this.btnAxes);
        Utils.makeHot(this.btnAxes);
        this.btnAxes.setToolTipText("Toggle Axes");
        this.btnAxes.setActionCommand("TogAxes");
        this.btnAxes.addActionListener(actionlistener);
        jtoolbar.addSeparator();
        this.btnEdit = new JButton(Utils.loadIcon("edit.gif"));
        jtoolbar.add(this.btnEdit);
        Utils.makeHot(this.btnEdit);
        this.btnEdit.setToolTipText("Edit Scene");
        this.btnEdit.setActionCommand("EditScene");
        this.btnEdit.addActionListener(actionlistener);
        this.newFile();
        Border border = null;
        border = Utils.applet == null ? BorderFactory.createBevelBorder(1) : BorderFactory.createLineBorder(Color.BLACK);
        this.modelView.setBorder(BorderFactory.createEmptyBorder());
        this.optionsDialog = new OptionsDialog(this.parentFrame, this.modelView);
        this.modelView.item1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainComponent.this.handleCommand("EditScene");
            }
        });
        this.modelView.item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainComponent.this.handleCommand("TogAxes");
            }
        });
        this.modelView.item3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainComponent.this.handleCommand("TogCulling");
            }
        });
        this.modelView.item4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainComponent.this.modelView.repaint();
            }
        });
        this.modelView.item5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainComponent.this.saveToFile(true);
            }
        });
        this.modelView.item6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainComponent.this.loadFromFile();
            }
        });
        this.modelView.item7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainComponent.this.helpDialog.setVisible(true);
            }
        });
        this.add((Component)this.modelView, "Center");
    }
}

