/*
 * Decompiled with CFR 0.152.
 */
package jplot.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import jplot.DataArray;
import jplot.DataFile;
import jplot.GraphSettings;
import jplot.JPlot;
import jplot.LinePars;
import jplot.LineStyleButton;
import jplot.SimpleEditor;
import jplot.SmallButton;

public class PanelPlot
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Object[][] itemDataMatrix;
    private JTable itemTable;
    private TableModel itemDataModel;
    private JScrollPane items;
    private Object[][] selectedDataMatrix;
    private JTable selectedTable;
    private TableModel selectedDataModel;
    private boolean selectedInFocus;
    private JScrollPane selected;
    private Object[][] selectedXDataMatrix;
    private JTable selectedXTable;
    private TableModel selectedXDataModel;
    private boolean selectedXInFocus;
    private File file;
    private DataFile dataFile;
    private GraphSettings gs;
    private JPlot jplot;
    private SimpleEditor dataViewer;
    private JPopupMenu selectedXPopup;
    private JPopupMenu selectedYPopup;
    private JPopupMenu itemsPopup;
    private final String lf = System.getProperty("line.separator");

    public PanelPlot(JPlot jp, DataFile df, GraphSettings gs) {
        this.dataFile = df;
        this.jplot = jp;
        this.gs = gs;
        this.file = this.dataFile.getFile();
        this.setLayout(new BorderLayout());
        EmptyBorder eb = new EmptyBorder(4, 4, 4, 4);
        BevelBorder bb = new BevelBorder(1);
        this.setBorder(new CompoundBorder(eb, bb));
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new EtchedBorder());
        JLabel fn = new JLabel(this.dataFile.getAbbreviatedFilename());
        fn.setForeground(new Color(0, 0, 100));
        p.add((Component)fn, "West");
        JPanel buttons = new JPanel();
        AbstractAction action = new AbstractAction("Reload", this.jplot.getImageIcon("Refresh16.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelPlot.this.reload();
            }
        };
        SmallButton sb = new SmallButton(action, "Reload this dataset from file");
        buttons.add(sb);
        action = new AbstractAction("Edit datafile", this.jplot.getImageIcon("Open16.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelPlot.this.viewData();
            }
        };
        sb = new SmallButton(action, "View or edit the current dataset");
        buttons.add(sb);
        p.add((Component)buttons, "East");
        this.add((Component)p, "North");
        this.selectedXInFocus = false;
        this.selectedInFocus = false;
        JPanel main = new JPanel(new GridLayout(1, 2));
        main.add(this.getItemPanel());
        main.add(this.getSelectedPanel());
        this.defaultSelection();
        this.add((Component)main, "Center");
    }

    private JPanel getItemPanel() {
        JButton b;
        final String[] names = new String[]{"item"};
        this.itemDataMatrix = new Object[0][1];
        this.itemDataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return names.length;
            }

            @Override
            public int getRowCount() {
                return PanelPlot.this.itemDataMatrix.length;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return PanelPlot.this.itemDataMatrix[row][col];
            }

            @Override
            public String getColumnName(int column) {
                return names[column];
            }
        };
        this.itemsPopup = new JPopupMenu();
        JMenuItem mi = this.itemsPopup.add(new JMenuItem("Set as X"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = PanelPlot.this.itemTable.getSelectedRow();
                if (index > -1 && index < PanelPlot.this.itemTable.getRowCount()) {
                    if (PanelPlot.this.selectedXDataMatrix.length == 0) {
                        PanelPlot.access$202(PanelPlot.this, new Object[1][1]);
                    }
                    ((PanelPlot)PanelPlot.this).selectedXDataMatrix[0][0] = PanelPlot.this.dataFile.getItem(index);
                    PanelPlot.this.dataFile.setXColumn(index);
                    PanelPlot.this.selectedXTable.revalidate();
                    PanelPlot.this.selectedXTable.repaint();
                }
            }
        });
        mi = this.itemsPopup.add(new JMenuItem("Set as Y"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] index = PanelPlot.this.itemTable.getSelectedRows();
                for (int j = 0; j < index.length; ++j) {
                    if (index[j] < 0) continue;
                    PanelPlot.this.addSelectedItem(index[j]);
                }
                PanelPlot.this.selectedTable.revalidate();
            }
        });
        this.itemTable = new JTable(this.itemDataModel);
        this.itemTable.setColumnSelectionAllowed(false);
        this.itemTable.setSelectionBackground(new Color(248, 248, 215));
        this.itemTable.setSelectionForeground(Color.black);
        this.itemTable.getColumn("item").setPreferredWidth(30);
        this.itemTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() || e.getModifiers() == 4) {
                    PanelPlot.this.itemsPopup.show(PanelPlot.this.itemTable, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = PanelPlot.this.itemTable.getSelectedRow();
                    PanelPlot.this.addSelectedItem(index);
                    PanelPlot.this.selectedTable.revalidate();
                }
            }
        });
        this.items = new JScrollPane(this.itemTable);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new TitledBorder(new EtchedBorder(), "Choices"));
        p.add((Component)this.items, "Center");
        JPanel q = new JPanel(new FlowLayout());
        if (this.gs.getGraphType() == 0) {
            b = new JButton("Set as X");
            b.setToolTipText("Set the current selected column as X-axis");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = PanelPlot.this.itemTable.getSelectedRow();
                    PanelPlot.this.addSelectedXItem(index);
                }
            });
            q.add(b);
            b = new JButton("Set as Y");
        } else {
            b = new JButton("Select");
        }
        b.setToolTipText("Set the current selected column as Y-axis");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] index = PanelPlot.this.itemTable.getSelectedRows();
                for (int j = 0; j < index.length; ++j) {
                    if (index[j] < 0) continue;
                    PanelPlot.this.addSelectedItem(index[j]);
                }
                PanelPlot.this.selectedTable.revalidate();
            }
        });
        q.add(b);
        p.add((Component)q, "South");
        return p;
    }

    private LinePars getDefaultLineStyle(int index) {
        LinePars lp = new LinePars(this.dataFile.getItem(index), this.gs.getColorIndex());
        if (this.gs.getGraphType() == 1) {
            lp.setDrawLine(false);
            lp.setSymbol(this.gs.getPointIndex());
        } else if (this.gs.getGraphType() == 2) {
            lp.setPenWidth(1.0f);
            lp.setColor(0);
        }
        return lp;
    }

    private void addSelectedXItem(int index) {
        if (this.selectedXDataMatrix.length == 0) {
            this.selectedXDataMatrix = new Object[1][1];
        }
        this.selectedXDataMatrix[0][0] = this.dataFile.getItem(index);
        this.dataFile.setXColumn(index);
        this.selectedXTable.revalidate();
        this.selectedXTable.repaint();
    }

    private void addSelectedItem(int index) {
        int len = this.selectedDataModel.getRowCount();
        Object[][] newMatrix = new Object[len + 1][2];
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < 2; ++j) {
                newMatrix[i][j] = this.selectedDataMatrix[i][j];
            }
        }
        newMatrix[len][0] = this.dataFile.getItem(index);
        LinePars lp = this.getDefaultLineStyle(index);
        newMatrix[len][1] = new LineStyleButton(lp);
        this.selectedDataMatrix = null;
        this.selectedDataMatrix = newMatrix;
        this.dataFile.addColumn(index, lp);
    }

    private void removeSelectedItem(int index) {
        int len = this.selectedDataModel.getRowCount();
        if (len >= 1) {
            Object[][] newMatrix = new Object[len - 1][2];
            int k = 0;
            for (int i = 0; i < len; ++i) {
                if (i == index) continue;
                newMatrix[k][0] = this.selectedDataMatrix[i][0];
                newMatrix[k][1] = this.selectedDataMatrix[i][1];
                ++k;
            }
            this.selectedDataMatrix = null;
            this.selectedDataMatrix = newMatrix;
        } else {
            this.selectedDataMatrix = new Object[0][2];
        }
        this.dataFile.removeColumn(index);
    }

    private JPanel getSelectedPanel() {
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(new TitledBorder(new EtchedBorder(), "Selection"));
        p.add((Component)this.getSelectedYPanel(), "Center");
        if (this.gs.getGraphType() == 0) {
            p.add((Component)this.getSelectedXPanel(), "North");
        }
        return p;
    }

    private JPanel getSelectedXPanel() {
        final String[] names = new String[]{"X-item"};
        this.selectedXDataMatrix = new Object[0][1];
        this.selectedXDataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return names.length;
            }

            @Override
            public int getRowCount() {
                return PanelPlot.this.selectedXDataMatrix.length;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return PanelPlot.this.selectedXDataMatrix[row][col];
            }

            @Override
            public String getColumnName(int column) {
                return names[column];
            }

            public Class getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                ((PanelPlot)PanelPlot.this).selectedXDataMatrix[row][column] = aValue;
            }
        };
        this.selectedXPopup = new JPopupMenu();
        JMenuItem mi = this.selectedXPopup.add(new JMenuItem("Options..."));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("TODO, X-column options must be added");
            }
        });
        mi = this.selectedXPopup.add(new JMenuItem("Remove"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelPlot.access$202(PanelPlot.this, new Object[0][0]);
                PanelPlot.this.dataFile.setXColumn(-1);
                PanelPlot.this.selectedXTable.revalidate();
                PanelPlot.this.selectedXInFocus = false;
            }
        });
        this.selectedXTable = new JTable(this.selectedXDataModel);
        this.selectedXTable.setSelectionBackground(new Color(248, 248, 215));
        this.selectedXTable.setSelectionForeground(Color.black);
        this.selectedXTable.setColumnSelectionAllowed(false);
        this.selectedXTable.setRowSelectionAllowed(false);
        this.selectedXTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() || e.getModifiers() == 4) {
                    PanelPlot.this.selectedXPopup.show(PanelPlot.this.selectedXTable, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                PanelPlot.this.selectedInFocus = false;
                PanelPlot.this.selectedXInFocus = true;
            }
        });
        Dimension d = new Dimension(220, this.selectedXTable.getRowHeight() + 1);
        this.selectedXTable.setPreferredScrollableViewportSize(d);
        JScrollPane selectedX = new JScrollPane(this.selectedXTable);
        JPanel p = new JPanel();
        p.add(selectedX);
        return p;
    }

    private void defaultSelection() {
        int k;
        this.gs.resetColorIndex();
        this.gs.resetPointIndex();
        int N = this.dataFile.getNumberOfItems();
        this.itemDataMatrix = new Object[N][1];
        for (int i = 0; i < N; ++i) {
            this.itemDataMatrix[i][0] = this.dataFile.getItem(i);
        }
        if (this.gs.getGraphType() == 0) {
            if (N > 0) {
                this.selectedXDataMatrix = new Object[1][1];
                this.selectedXDataMatrix[0][0] = this.dataFile.getItem(0);
                this.dataFile.setXColumn(0);
            } else {
                this.selectedXDataMatrix = new Object[0][1];
            }
            this.selectedXTable.revalidate();
        }
        int n = k = this.gs.getGraphType() != 0 ? 0 : 1;
        if (N > k) {
            this.selectedDataMatrix = new Object[N - k][2];
            for (int i = k; i < N; ++i) {
                this.selectedDataMatrix[i - k][0] = this.dataFile.getItem(i);
                LinePars lp = this.getDefaultLineStyle(i);
                this.selectedDataMatrix[i - k][1] = new LineStyleButton(lp);
                this.dataFile.addColumn(i, lp);
            }
        } else {
            this.selectedDataMatrix = new Object[0][2];
        }
        this.selectedTable.revalidate();
        this.itemTable.revalidate();
        this.repaint();
    }

    public void update() {
        int k;
        if (this.gs.getGraphType() == 0) {
            if (this.dataFile.getNumberOfItems() > 0) {
                this.selectedXDataMatrix = new Object[1][1];
                this.selectedXDataMatrix[0][0] = this.dataFile.getXColumn() < this.dataFile.getNumberOfItems() ? this.dataFile.getItem(this.dataFile.getXColumn()) : this.dataFile.getItem(0);
            } else {
                this.selectedXDataMatrix = new Object[0][1];
            }
            this.selectedXTable.revalidate();
        }
        if ((k = this.dataFile.getNumberOfColumns()) > 0) {
            int m;
            this.selectedDataMatrix = new Object[k][2];
            for (int i = 0; i < k && (m = this.dataFile.getYColumn(i)) < this.dataFile.getNumberOfItems(); ++i) {
                this.selectedDataMatrix[i][0] = this.dataFile.getItem(m);
                this.selectedDataMatrix[i][1] = new LineStyleButton(this.dataFile.getLinePars(i));
            }
        } else {
            this.selectedDataMatrix = new Object[0][2];
        }
        this.selectedTable.revalidate();
        this.repaint();
    }

    void popupStyleChooser(int row) {
        LineStyleButton ls = (LineStyleButton)this.selectedDataModel.getValueAt(row, 1);
        LinePars lp = this.jplot.styleChooser.show(350, 100, ls.getLinePars());
        if (lp != null) {
            DataFile a = this.getDataFile();
            this.jplot.replaceLinePars(a.getIndex(), lp);
            this.updateStyle(row, lp);
        }
    }

    public void updateStyle(int row, LinePars lp) {
        this.gs.setDataChanged(lp.dataChanged());
        this.dataFile.setLinePars(row, lp);
        LineStyleButton ls = (LineStyleButton)this.selectedDataModel.getValueAt(row, 1);
        ls.setLinePars(lp);
        this.selectedTable.repaint();
        if (this.jplot.plotFrame != null) {
            this.jplot.showGraph(true);
        }
    }

    private JPanel getSelectedYPanel() {
        this.selectedDataMatrix = new Object[0][2];
        this.selectedDataModel = new AbstractTableModel(){
            final String[] names = new String[]{"Y-items", "style"};

            @Override
            public int getColumnCount() {
                return this.names.length;
            }

            @Override
            public int getRowCount() {
                return PanelPlot.this.selectedDataMatrix.length;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return PanelPlot.this.selectedDataMatrix[row][col];
            }

            @Override
            public String getColumnName(int col) {
                return this.names[col];
            }

            public Class getColumnClass(int col) {
                return this.getValueAt(0, col).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col != 0;
            }

            @Override
            public void setValueAt(Object aValue, int row, int col) {
                ((PanelPlot)PanelPlot.this).selectedDataMatrix[row][col] = aValue;
                this.fireTableCellUpdated(row, col);
            }
        };
        this.selectedYPopup = new JPopupMenu();
        JMenuItem mi = this.selectedYPopup.add(new JMenuItem("Plot style..."));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = PanelPlot.this.selectedTable.getSelectedRow();
                if (row < 0 || row >= PanelPlot.this.selectedTable.getRowCount()) {
                    return;
                }
                PanelPlot.this.popupStyleChooser(row);
            }
        });
        mi = this.selectedYPopup.add(new JMenuItem("Remove"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PanelPlot.this.selectedInFocus) {
                    int[] index = PanelPlot.this.selectedTable.getSelectedRows();
                    for (int j = 0; j < index.length; ++j) {
                        PanelPlot.this.removeSelectedItem(index[0]);
                    }
                    PanelPlot.this.selectedTable.revalidate();
                    PanelPlot.this.selectedInFocus = false;
                }
            }
        });
        this.selectedTable = new JTable(this.selectedDataModel);
        this.selectedTable.setColumnSelectionAllowed(false);
        this.selectedTable.setSelectionBackground(new Color(248, 248, 215));
        this.selectedTable.setSelectionForeground(Color.black);
        this.selectedTable.setCellSelectionEnabled(true);
        this.selectedTable.getColumn("style").setPreferredWidth(this.selectedTable.getColumn("style").getPreferredWidth() / 3);
        this.selectedTable.getColumn("Y-items").setPreferredWidth(this.selectedTable.getColumn("Y-items").getPreferredWidth() * 2);
        this.selectedTable.setDefaultRenderer(LineStyleButton.class, new LineStyleButtonRenderer(new LinePars()));
        this.selectedTable.getColumn("style").setCellEditor(new ButtonEditor(new JCheckBox()));
        this.selectedTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() || e.getModifiers() == 4) {
                    PanelPlot.this.selectedYPopup.show(PanelPlot.this.selectedTable, e.getX(), e.getY());
                }
                PanelPlot.this.selectedInFocus = true;
                PanelPlot.this.selectedXInFocus = false;
            }
        });
        this.selectedTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (PanelPlot.this.selectedInFocus && e.getKeyCode() == 127) {
                    int[] index = PanelPlot.this.selectedTable.getSelectedRows();
                    for (int j = 0; j < index.length; ++j) {
                        PanelPlot.this.removeSelectedItem(index[0]);
                    }
                    PanelPlot.this.selectedTable.revalidate();
                    PanelPlot.this.selectedInFocus = false;
                }
            }
        });
        this.selected = new JScrollPane(this.selectedTable);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.selected, "Center");
        JPanel q = new JPanel(new FlowLayout());
        ImageIcon icon = this.jplot.getImageIcon("Remove16.gif");
        JButton b = new JButton("Remove", icon);
        b.setToolTipText("Remove the selected item(s)");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PanelPlot.this.selectedInFocus) {
                    int[] index = PanelPlot.this.selectedTable.getSelectedRows();
                    for (int j = 0; j < index.length; ++j) {
                        PanelPlot.this.removeSelectedItem(index[0]);
                    }
                    PanelPlot.this.selectedTable.revalidate();
                    PanelPlot.this.selectedInFocus = false;
                } else if (PanelPlot.this.selectedXInFocus) {
                    PanelPlot.access$202(PanelPlot.this, new Object[0][0]);
                    PanelPlot.this.dataFile.setXColumn(-1);
                    PanelPlot.this.selectedXTable.revalidate();
                    PanelPlot.this.selectedXInFocus = false;
                }
            }
        });
        q.add(b);
        icon = this.jplot.getImageIcon("New16.gif");
        b = new JButton("Clear", icon);
        b.setToolTipText("Clear the list with selected items");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelPlot.this.clearSelection();
            }
        });
        q.add(b);
        p.add((Component)q, "South");
        return p;
    }

    public void clearSelection() {
        int n = this.selectedDataModel.getRowCount();
        for (int j = 0; j < n; ++j) {
            this.removeSelectedItem(0);
        }
        this.selectedTable.revalidate();
        if (this.gs.getGraphType() == 0) {
            this.selectedXDataMatrix = new Object[0][0];
            this.dataFile.setXColumn(-1);
            this.selectedXTable.revalidate();
        }
        this.gs.resetColorIndex();
        this.gs.resetPointIndex();
    }

    public void reload() {
        if (!this.dataFile.loadColumnNames(this.gs.getLabels())) {
            this.defaultSelection();
        }
        this.jplot.updateGraphIfShowing();
    }

    public void viewData() {
        DataArray da = this.jplot.getDataArraySelected();
        if (this.dataViewer == null) {
            this.dataViewer = new SimpleEditor(this.jplot, da.getTitle(), true);
        }
        this.dataViewer.show(100, 20, da.toString());
    }

    public void setDataFileIndex(int index) {
        this.dataFile.setIndex(index);
    }

    public DataFile getDataFile() {
        return this.dataFile;
    }

    static /* synthetic */ Object[][] access$202(PanelPlot x0, Object[][] x1) {
        x0.selectedXDataMatrix = x1;
        return x1;
    }

    public class LineStyleButtonRenderer
    extends LineStyleButton
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public LineStyleButtonRenderer(LinePars lp) {
            super(lp);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setLinePars(((LineStyleButton)value).getLinePars());
            return this;
        }
    }

    public class ButtonEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;
        protected LineStyleButton b;
        private boolean isPushed;

        public ButtonEditor(JCheckBox checkBox) {
            super(checkBox);
            this.b = new LineStyleButton();
            this.b.setOpaque(true);
            this.b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.b.setLinePars(((LineStyleButton)value).getLinePars());
            this.isPushed = true;
            return this.b;
        }

        @Override
        public Object getCellEditorValue() {
            int row = -1;
            if (this.isPushed) {
                this.isPushed = false;
                row = PanelPlot.this.selectedTable.getSelectedRow();
                if (row >= 0 && row < PanelPlot.this.selectedTable.getRowCount()) {
                    PanelPlot.this.popupStyleChooser(row);
                    PanelPlot.this.selectedTable.repaint();
                    return PanelPlot.this.selectedDataModel.getValueAt(row, 1);
                }
            }
            return null;
        }

        @Override
        public boolean stopCellEditing() {
            this.isPushed = false;
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }
}

