/*
 * Decompiled with CFR 0.152.
 */
package jplot.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import jplot.GraphSettings;
import jplot.JPlot;
import jplot.panels.PanelFonts;
import jplot.panels.PanelGridUI;

public class PanelLegend
extends PanelGridUI {
    private static final long serialVersionUID = 1L;
    private final int X = 0;
    private final int Y = 1;
    private JDialog dialog = null;
    private PanelFonts fontPanel;
    private GraphSettings gs;
    private JRadioButton hide;
    private JCheckBox autoPos;
    private JCheckBox manuPos;
    private JTextField xPosField;
    private JTextField yPosField;
    private JTextField rotField;
    private JTextField sepField;
    private JPlot jplot;

    public PanelLegend(JPlot jp, GraphSettings gs) {
        this.gs = gs;
        this.jplot = jp;
        Dimension mediumField = new Dimension(120, 20);
        Dimension cbField = new Dimension(110, 20);
        Dimension shortField = new Dimension(80, 22);
        EmptyBorder border = new EmptyBorder(new Insets(0, 0, 0, 10));
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        PanelGridUI p = new PanelGridUI();
        p.setBorder(new EtchedBorder());
        JLabel label = new JLabel("Position:");
        label.setBorder(border);
        p.addComponent(label, 1, 1);
        ButtonGroup bg = new ButtonGroup();
        this.autoPos = new JCheckBox("automatic", true);
        this.autoPos.setPreferredSize(cbField);
        this.autoPos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelLegend.this.xPosField.setEnabled(false);
                PanelLegend.this.yPosField.setEnabled(false);
            }
        });
        bg.add(this.autoPos);
        p.addComponent(this.autoPos, 1, 2);
        this.manuPos = new JCheckBox("manual", false);
        this.manuPos.setPreferredSize(cbField);
        this.manuPos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelLegend.this.xPosField.setEnabled(true);
                PanelLegend.this.yPosField.setEnabled(true);
            }
        });
        bg.add(this.manuPos);
        p.addComponent(this.manuPos, 1, 3);
        JPanel posPanel = new JPanel(new BorderLayout());
        posPanel.add((Component)new JLabel("x: "), "West");
        this.xPosField = new JTextField();
        this.xPosField.setEnabled(true);
        posPanel.add((Component)this.xPosField, "Center");
        posPanel.setPreferredSize(shortField);
        p.addComponent(posPanel, 2, 2);
        posPanel = new JPanel(new BorderLayout());
        posPanel.add((Component)new JLabel("y: "), "West");
        this.yPosField = new JTextField();
        this.yPosField.setEnabled(true);
        posPanel.add((Component)this.yPosField, "Center");
        posPanel.setPreferredSize(shortField);
        p.addComponent(posPanel, 2, 3);
        this.hide = new JRadioButton("hide", false);
        this.hide.setPreferredSize(cbField);
        this.hide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        p.addComponent(this.hide, 3, 2);
        label = new JLabel("Spacing:");
        label.setBorder(border);
        p.addComponent(label, 4, 1);
        this.sepField = new JTextField();
        this.sepField.setPreferredSize(shortField);
        p.addComponent(this.sepField, 4, 2);
        this.addComponent(p, 1, 1);
        this.fontPanel = new PanelFonts(this.jplot, gs.getLegendFont());
        this.addFilledComponent(this.fontPanel, 2, 1, 3, 1, 3);
    }

    public void refresh() {
        this.hide.setSelected(!this.gs.drawLegend());
        this.fontPanel.refresh(this.gs.getLegendFont());
        this.xPosField.setText(Float.toString((float)this.gs.getLegendPosition(0)));
        this.yPosField.setText(Float.toString((float)this.gs.getLegendPosition(1)));
        this.sepField.setText(Float.toString((float)this.gs.getLegendSpacing()));
        this.autoPos.setSelected(!this.gs.useLegendPosition());
        this.manuPos.setSelected(this.gs.useLegendPosition());
    }

    public void setValues() {
        this.gs.setDrawLegend(!this.hide.isSelected());
        this.gs.setLegendFont(this.fontPanel.getSelectedFont());
        this.gs.setFontChanged(true);
        if (this.manuPos.isSelected()) {
            this.gs.setLegendPosition(Double.parseDouble(this.xPosField.getText()), Double.parseDouble(this.yPosField.getText()));
        }
        this.gs.setUseLegendPosition(!this.autoPos.isSelected());
        this.gs.setLegendSpacing(Float.parseFloat(this.sepField.getText()));
    }

    public void show(Frame parent, int x, int y) {
        if (this.dialog == null) {
            this.dialog = new JDialog(parent, "Legend options", false);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PanelLegend.this.dialog.dispose();
                }
            });
            JPanel p = new JPanel(new FlowLayout());
            p.setBorder(BorderFactory.createEtchedBorder());
            JButton b = new JButton("Apply");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelLegend.this.setValues();
                    PanelLegend.this.gs.setDataChanged(true);
                    PanelLegend.this.jplot.updateGraphIfShowing();
                    PanelLegend.this.dialog.dispose();
                }
            });
            p.add(b);
            b = new JButton("Dismiss");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelLegend.this.dialog.dispose();
                }
            });
            p.add(b);
            this.dialog.getContentPane().add((Component)this, "Center");
            this.dialog.getContentPane().add((Component)p, "South");
            this.dialog.pack();
            this.dialog.setLocation(x, y);
        }
        this.refresh();
        this.dialog.setVisible(true);
    }
}

