/*
 * Decompiled with CFR 0.152.
 */
package jplot.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jplot.GraphLabel;
import jplot.GraphSettings;
import jplot.JPlot;
import jplot.LabelProperties;
import jplot.panels.PanelFonts;
import jplot.panels.PanelGridUI;

public class PanelLabel
extends PanelGridUI {
    private static final long serialVersionUID = 1L;
    private int N;
    private JTextField[] textField;
    private GraphLabel[] gLabel;
    private Vector otherLabels = new Vector();
    private JList labelList;
    private JDialog dialog;
    private LabelProperties labelProperties;
    private int actualItemIndex;
    private int[] actualItemIndices;
    private JButton[] edit;
    private String[] toolTip;
    private JLabel[] label;
    private JButton olAdd;
    private JButton olEdit;
    private JButton olDelete;
    private JButton xTicFont;
    private JButton yTicFont;
    private JRadioButton xTicLabels;
    private JRadioButton yTicLabels;
    private PanelFonts ticFontPanel;
    private JPanel[] labelPanel;
    private JPanel oLabelPanel;
    private GraphSettings gs;
    private JRadioButton rb_reset;
    private final Dimension myDimension = new Dimension(100, 50);
    private final Insets insets = new Insets(0, 0, 0, 0);
    private JPlot jplot;

    public PanelLabel(JPlot jp, GraphSettings settings) {
        int k = 0;
        this.gs = settings;
        this.jplot = jp;
        this.dialog = null;
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.rb_reset = new JRadioButton("reset all label positions");
        EmptyBorder border = new EmptyBorder(new Insets(0, 0, 0, 10));
        ImageIcon editIcon = this.jplot.getImageIcon("Edit16.gif");
        this.N = this.gs.getGraphType() == 1 ? 6 : 3;
        this.textField = new JTextField[this.N];
        this.gLabel = new GraphLabel[this.N];
        this.edit = new JButton[this.N];
        this.toolTip = new String[this.N];
        this.label = new JLabel[this.N];
        this.labelPanel = new JPanel[this.N];
        if (this.gs.getGraphType() == 1) {
            this.gLabel[0] = new GraphLabel(3);
            this.toolTip[0] = new String("Left X-label");
            this.label[0] = new JLabel("X1-label:");
            this.gLabel[1] = new GraphLabel(4);
            this.toolTip[1] = new String("Right X-label");
            this.label[1] = new JLabel("X2-label:");
            this.gLabel[2] = new GraphLabel(5);
            this.toolTip[2] = new String("Lower left Y-label");
            this.label[2] = new JLabel("Y1-label:");
            this.gLabel[3] = new GraphLabel(6);
            this.toolTip[3] = new String("Lower right Y-label");
            this.label[3] = new JLabel("Y2-label:");
            this.gLabel[4] = new GraphLabel(7);
            this.toolTip[4] = new String("Upper left Y-label");
            this.label[4] = new JLabel("Y3-label:");
            this.gLabel[5] = new GraphLabel(8);
            this.toolTip[5] = new String("Upper right Y-label");
            this.label[5] = new JLabel("Y4-label:");
        } else {
            this.gLabel[0] = new GraphLabel(2);
            this.gLabel[0].setFont(new Font("Helvetica", 1, 12));
            this.toolTip[0] = new String("Edit the title properties");
            this.label[0] = new JLabel("Graph title");
            this.gLabel[1] = new GraphLabel(0);
            this.toolTip[1] = new String("Edit the X-label properties");
            this.label[1] = new JLabel("X-axis label");
            this.gLabel[2] = new GraphLabel(1);
            this.toolTip[2] = new String("Edit the Y-label properties");
            this.label[2] = new JLabel("Y-axis label");
            this.gLabel[2].setRotation(-1.5707963267948966);
        }
        this.labelProperties = new LabelProperties(this.jplot);
        int i = 0;
        while (i < this.N) {
            final int j = i;
            this.textField[i] = new JTextField();
            this.edit[i] = new JButton(editIcon);
            this.edit[i].setMargin(this.insets);
            this.edit[i].setToolTipText(this.toolTip[i]);
            this.edit[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelLabel.this.gLabel[j].setText(PanelLabel.this.textField[j].getText());
                    PanelLabel.this.labelProperties.refresh(PanelLabel.this.gLabel[j]);
                    if (PanelLabel.this.labelProperties.show(((PanelLabel)PanelLabel.this).jplot.frame, 100, 100)) {
                        ((PanelLabel)PanelLabel.this).gLabel[j] = PanelLabel.this.labelProperties.getGraphLabel();
                        PanelLabel.this.setValues();
                        PanelLabel.this.update();
                    }
                }
            });
            this.labelPanel[i] = new JPanel(new BorderLayout());
            this.labelPanel[i].add((Component)this.textField[i], "Center");
            this.labelPanel[i].add((Component)this.edit[i], "East");
            this.label[i].setBorder(border);
            this.addComponent(this.label[i], i, 1);
            this.addFilledComponent(this.labelPanel[i], i, 2, 3, 1, 2);
            ++i;
            ++k;
        }
        this.actualItemIndex = -1;
        this.otherLabels = new Vector();
        this.labelList = new JList(new DefaultListModel());
        this.labelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PanelLabel.this.actualItemIndex = PanelLabel.this.labelList.getSelectedIndex();
                PanelLabel.access$702(PanelLabel.this, PanelLabel.this.labelList.getSelectedIndices());
                if (e.getClickCount() == 2) {
                    PanelLabel.this.editOtherLabel();
                }
            }
        });
        JScrollPane sp_otherLabels = new JScrollPane(this.labelList);
        sp_otherLabels.setPreferredSize(this.myDimension);
        this.oLabelPanel = new JPanel(new BorderLayout());
        this.oLabelPanel.add((Component)sp_otherLabels, "Center");
        JPanel bPanel = new JPanel(new GridLayout(3, 1));
        this.olAdd = new JButton(this.jplot.getImageIcon("insert.png"));
        this.olAdd.setMargin(this.insets);
        this.olAdd.setToolTipText("Add a random label");
        this.olAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelLabel.this.labelProperties.refresh(new GraphLabel(10));
                if (PanelLabel.this.labelProperties.show(((PanelLabel)PanelLabel.this).jplot.frame, 100, 100)) {
                    PanelLabel.this.otherLabels.add(PanelLabel.this.labelProperties.getGraphLabel());
                    PanelLabel.this.setValues();
                    PanelLabel.this.update();
                }
            }
        });
        bPanel.add(this.olAdd);
        this.olEdit = new JButton(editIcon);
        this.olEdit.setMargin(this.insets);
        this.olEdit.setToolTipText("Edit the selected label properties");
        this.olEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelLabel.this.editOtherLabel();
            }
        });
        bPanel.add(this.olEdit);
        this.olDelete = new JButton(this.jplot.getImageIcon("Remove16.gif"));
        this.olDelete.setMargin(this.insets);
        this.olDelete.setToolTipText("Remove the selected label(s)");
        this.olDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PanelLabel.this.actualItemIndices != null) {
                    for (int i = PanelLabel.this.actualItemIndices.length - 1; i >= 0; --i) {
                        PanelLabel.this.otherLabels.removeElementAt(PanelLabel.this.actualItemIndices[i]);
                    }
                    PanelLabel.this.update();
                }
            }
        });
        bPanel.add(this.olDelete);
        this.oLabelPanel.add((Component)bPanel, "East");
        JLabel l = new JLabel("Random labels");
        l.setBorder(border);
        this.addComponent(l, k, 1);
        this.addFilledComponent(this.oLabelPanel, k, 2, 3, 3, 2);
        this.addComponent(this.rb_reset, k += 4, 2, 2, 1);
        l = new JLabel("X tic-labels");
        l.setBorder(border);
        this.addComponent(l, ++k, 1);
        this.xTicLabels = new JRadioButton("show");
        this.xTicLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphSettings graphSettings = PanelLabel.this.gs;
                PanelLabel.this.gs;
                graphSettings.setDrawTicLabels(0, PanelLabel.this.xTicLabels.isSelected());
            }
        });
        this.xTicLabels.setSelected(true);
        this.addComponent(this.xTicLabels, k, 2);
        this.xTicFont = new JButton("Change font...", editIcon);
        this.xTicFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PanelLabel.this.ticFontPanel == null) {
                    JPlot jPlot = PanelLabel.this.jplot;
                    GraphSettings graphSettings = PanelLabel.this.gs;
                    PanelLabel.this.gs;
                    Font font = graphSettings.getTicFont(0);
                    GraphSettings graphSettings2 = PanelLabel.this.gs;
                    PanelLabel.this.gs;
                    PanelLabel.this.ticFontPanel = new PanelFonts(jPlot, font, graphSettings2.getTicColor(0));
                } else {
                    PanelFonts panelFonts = PanelLabel.this.ticFontPanel;
                    GraphSettings graphSettings = PanelLabel.this.gs;
                    PanelLabel.this.gs;
                    Font font = graphSettings.getTicFont(0);
                    GraphSettings graphSettings3 = PanelLabel.this.gs;
                    PanelLabel.this.gs;
                    panelFonts.refresh(font, graphSettings3.getTicColor(0));
                }
                PanelLabel.this.ticFontPanel.show(((PanelLabel)PanelLabel.this).jplot.frame, 150, 150);
                GraphSettings graphSettings = PanelLabel.this.gs;
                PanelLabel.this.gs;
                graphSettings.setTicFont(0, PanelLabel.this.ticFontPanel.getSelectedFont());
                GraphSettings graphSettings4 = PanelLabel.this.gs;
                PanelLabel.this.gs;
                graphSettings4.setTicColor(0, PanelLabel.this.ticFontPanel.getSelectedColor());
            }
        });
        this.addComponent(this.xTicFont, k, 3);
        l = new JLabel("Y tic-labels");
        l.setBorder(border);
        this.addComponent(l, ++k, 1);
        this.yTicLabels = new JRadioButton("show");
        this.yTicLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphSettings graphSettings = PanelLabel.this.gs;
                PanelLabel.this.gs;
                graphSettings.setDrawTicLabels(1, PanelLabel.this.yTicLabels.isSelected());
            }
        });
        this.yTicLabels.setSelected(true);
        this.addComponent(this.yTicLabels, k, 2);
        this.yTicFont = new JButton("Change font...", editIcon);
        this.yTicFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PanelLabel.this.ticFontPanel == null) {
                    JPlot jPlot = PanelLabel.this.jplot;
                    GraphSettings graphSettings = PanelLabel.this.gs;
                    PanelLabel.this.gs;
                    Font font = graphSettings.getTicFont(1);
                    GraphSettings graphSettings2 = PanelLabel.this.gs;
                    PanelLabel.this.gs;
                    PanelLabel.this.ticFontPanel = new PanelFonts(jPlot, font, graphSettings2.getTicColor(1));
                } else {
                    PanelFonts panelFonts = PanelLabel.this.ticFontPanel;
                    GraphSettings graphSettings = PanelLabel.this.gs;
                    PanelLabel.this.gs;
                    Font font = graphSettings.getTicFont(1);
                    GraphSettings graphSettings3 = PanelLabel.this.gs;
                    PanelLabel.this.gs;
                    panelFonts.refresh(font, graphSettings3.getTicColor(1));
                }
                PanelLabel.this.ticFontPanel.show(((PanelLabel)PanelLabel.this).jplot.frame, 150, 150);
                GraphSettings graphSettings = PanelLabel.this.gs;
                PanelLabel.this.gs;
                graphSettings.setTicFont(1, PanelLabel.this.ticFontPanel.getSelectedFont());
                GraphSettings graphSettings4 = PanelLabel.this.gs;
                PanelLabel.this.gs;
                graphSettings4.setTicColor(1, PanelLabel.this.ticFontPanel.getSelectedColor());
            }
        });
        this.addComponent(this.yTicFont, k, 3);
    }

    private void editOtherLabel() {
        if (this.actualItemIndex > -1 && this.actualItemIndex < this.otherLabels.size()) {
            this.labelProperties.refresh((GraphLabel)this.otherLabels.get(this.actualItemIndex));
            if (this.labelProperties.show(this.jplot.frame, 100, 100)) {
                this.otherLabels.set(this.actualItemIndex, this.labelProperties.getGraphLabel());
            }
        }
    }

    private void update() {
        for (int i = 0; i < this.N; ++i) {
            this.textField[i].setText(this.gLabel[i].getText());
            this.textField[i].setFont(this.gLabel[i].getFont());
            this.textField[i].setForeground(this.gLabel[i].getColor());
            if (this.gLabel[i].getFont().getSize() <= 14) continue;
            this.textField[i].setFont(this.gLabel[i].getFont().deriveFont(14.0f));
        }
        this.labelList.setListData(this.otherLabels);
    }

    public void refresh() {
        this.otherLabels.clear();
        Enumeration<GraphLabel> el = this.gs.getLabels().elements();
        while (el.hasMoreElements()) {
            GraphLabel gl = el.nextElement();
            if (this.gs.getGraphType() == 1) {
                if (gl.getID() == 3) {
                    this.gLabel[0] = new GraphLabel(gl);
                    continue;
                }
                if (gl.getID() == 4) {
                    this.gLabel[1] = new GraphLabel(gl);
                    continue;
                }
                if (gl.getID() == 5) {
                    this.gLabel[2] = new GraphLabel(gl);
                    continue;
                }
                if (gl.getID() == 6) {
                    this.gLabel[3] = new GraphLabel(gl);
                    continue;
                }
                if (gl.getID() == 7) {
                    this.gLabel[4] = new GraphLabel(gl);
                    continue;
                }
                if (gl.getID() == 8) {
                    this.gLabel[5] = new GraphLabel(gl);
                    continue;
                }
                this.otherLabels.add(new GraphLabel(gl));
                continue;
            }
            if (gl.getID() == 2) {
                this.gLabel[0] = new GraphLabel(gl);
                continue;
            }
            if (gl.getID() == 0) {
                this.gLabel[1] = new GraphLabel(gl);
                continue;
            }
            if (gl.getID() == 1) {
                this.gLabel[2] = new GraphLabel(gl);
                continue;
            }
            this.otherLabels.add(new GraphLabel(gl));
        }
        this.update();
        this.rb_reset.setSelected(false);
    }

    public void setValues() {
        this.gs.getLabels().clear();
        for (int i = 0; i < this.N; ++i) {
            this.gLabel[i].setText(this.textField[i].getText());
            if (this.gLabel[i].getText().equals("")) continue;
            this.gs.addLabel(this.gLabel[i]);
        }
        Enumeration e = this.otherLabels.elements();
        while (e.hasMoreElements()) {
            GraphLabel gl = (GraphLabel)e.nextElement();
            this.gs.addLabel(gl);
        }
        if (this.rb_reset.isSelected()) {
            this.gs.resetLabels();
            this.rb_reset.setSelected(false);
        }
        this.gs.setDataChanged(true);
        this.jplot.updateGraphIfShowing();
    }

    public void show(Frame parent, int x, int y) {
        if (this.dialog == null) {
            this.dialog = new JDialog(parent, "Labels", false);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PanelLabel.this.dialog.dispose();
                }
            });
            JPanel p = new JPanel(new FlowLayout());
            p.setBorder(BorderFactory.createEtchedBorder());
            JButton b = new JButton("Apply");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelLabel.this.setValues();
                }
            });
            p.add(b);
            b = new JButton("Dismiss");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelLabel.this.dialog.dispose();
                }
            });
            p.add(b);
            this.dialog.getContentPane().add((Component)this, "Center");
            this.dialog.getContentPane().add((Component)p, "South");
            this.dialog.setLocation(x, y);
            this.dialog.pack();
        }
        this.refresh();
        this.dialog.setVisible(true);
    }

    static /* synthetic */ int[] access$702(PanelLabel x0, int[] x1) {
        x0.actualItemIndices = x1;
        return x1;
    }
}

