/*
 * Decompiled with CFR 0.152.
 */
package jplot.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import jplot.JPlot;
import jplot.SmallColorPreview;
import jplot.Utils;
import jplot.panels.PanelColor;
import jplot.panels.PanelGridUI;

public class PanelFonts
extends PanelGridUI {
    private static final long serialVersionUID = 1L;
    private String selectedFontname;
    private int selectedFontsize;
    private int selectedFontstyle;
    private Color selectedColor;
    private SmallColorPreview colorPreview;
    PanelColor colorPanel;
    private JComboBox fonts;
    private JComboBox sizes;
    private JPanel colors;
    private JCheckBox cb_bold;
    private JCheckBox cb_italic;
    private JCheckBox cb_underline;
    private JRadioButton rb_normal;
    private JRadioButton rb_superscript;
    private JRadioButton rb_subscript;
    private Font result;
    private JDialog dialog;
    private JPlot jplot;
    String[] fontSizes = new String[]{"6", "7", "8", "9", "10", "11", "12", "14", "16", "18", "20", "24", "28"};

    public PanelFonts(JPlot jp, Font actualFont, Color actualColor) {
        this.jplot = jp;
        this.colorPanel = null;
        this.selectedColor = actualColor;
        this.selectedFontname = actualFont.getName();
        this.selectedFontsize = actualFont.getSize();
        this.selectedFontstyle = actualFont.getStyle();
        this.fonts = new JComboBox<String>(JPlot.fontNames);
        this.fonts.setSelectedItem(this.selectedFontname);
        this.sizes = new JComboBox<String>(this.fontSizes);
        this.sizes.setSelectedItem(Integer.toString(this.selectedFontsize));
        if (this.selectedColor != null) {
            this.colors = new JPanel(new BorderLayout());
            this.colorPreview = new SmallColorPreview(this.selectedColor, 40, 22);
            this.colors.add((Component)this.colorPreview, "Center");
            JButton b = new JButton(this.jplot.getImageIcon("color.jpg"));
            b.setMargin(new Insets(0, 0, 0, 0));
            b.setToolTipText("Text color");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PanelFonts.this.colorPanel == null) {
                        PanelFonts.this.colorPanel = new PanelColor(((PanelFonts)PanelFonts.this).jplot.frame, PanelFonts.this.selectedColor);
                    } else {
                        PanelFonts.this.colorPanel.refresh(PanelFonts.this.selectedColor);
                    }
                    Color _color = PanelFonts.this.colorPanel.show(((PanelFonts)PanelFonts.this).jplot.frame, PanelFonts.this.selectedColor, 100, 100);
                    if (_color != null) {
                        PanelFonts.this.selectedColor = _color;
                        PanelFonts.this.colorPreview.setColor(PanelFonts.this.selectedColor);
                    }
                }
            });
            this.colors.add((Component)b, "East");
        }
        this.sizes.setEditable(true);
        this.cb_bold = new JCheckBox("Bold");
        this.cb_italic = new JCheckBox("Italic");
        this.cb_underline = new JCheckBox("Underline");
        this.cb_underline.setEnabled(false);
        ButtonGroup bg = new ButtonGroup();
        this.rb_normal = new JRadioButton("Normal");
        bg.add(this.rb_normal);
        this.rb_normal.setSelected(true);
        this.rb_superscript = new JRadioButton("Superscript");
        bg.add(this.rb_superscript);
        this.rb_superscript.setEnabled(false);
        this.rb_subscript = new JRadioButton("Subscript");
        bg.add(this.rb_subscript);
        this.rb_subscript.setEnabled(false);
        this.setBorder(new EtchedBorder());
        Dimension longField = new Dimension(200, 22);
        Dimension shortField = new Dimension(60, 22);
        Dimension mediumField = new Dimension(120, 22);
        EmptyBorder border1 = new EmptyBorder(new Insets(0, 0, 0, 10));
        JLabel lb1 = new JLabel("Font:");
        lb1.setBorder(border1);
        this.addComponent(lb1, 1, 1);
        this.fonts.setPreferredSize(longField);
        this.addFilledComponent(this.fonts, 1, 2, 3, 1, 2);
        JLabel lb2 = new JLabel("Size:");
        lb2.setBorder(border1);
        this.addComponent(lb2, 2, 1);
        this.sizes.setPreferredSize(shortField);
        this.addComponent(this.sizes, 2, 2);
        if (this.selectedColor != null) {
            JLabel lb3 = new JLabel("Color:");
            lb3.setBorder(border1);
            this.addComponent(lb3, 3, 1);
            this.colors.setPreferredSize(shortField);
            this.addComponent(this.colors, 3, 2);
        }
        JLabel lb4 = new JLabel("Style:");
        lb4.setBorder(border1);
        this.addComponent(lb4, 4, 1);
        this.cb_bold.setPreferredSize(mediumField);
        this.addComponent(this.cb_bold, 4, 2);
        this.rb_normal.setPreferredSize(mediumField);
        this.addComponent(this.rb_normal, 4, 3);
        this.cb_italic.setPreferredSize(mediumField);
        this.addComponent(this.cb_italic, 5, 2);
        this.rb_superscript.setPreferredSize(mediumField);
        this.addComponent(this.rb_superscript, 5, 3);
        this.cb_underline.setPreferredSize(mediumField);
        this.addComponent(this.cb_underline, 6, 2);
        this.rb_superscript.setPreferredSize(mediumField);
        this.addComponent(this.rb_subscript, 6, 3);
    }

    public PanelFonts(JPlot jp, Font actualFont) {
        this(jp, actualFont, null);
    }

    public PanelFonts(JPlot jp) {
        this(jp, Utils.getDefaultFont());
    }

    public Font getSelectedFont() {
        this.selectedFontstyle = this.cb_bold.isSelected() ? (this.cb_italic.isSelected() ? 3 : 1) : (this.cb_italic.isSelected() ? 2 : 0);
        this.selectedFontname = (String)this.fonts.getSelectedItem();
        this.selectedFontsize = Integer.parseInt((String)this.sizes.getSelectedItem());
        return new Font(this.selectedFontname, this.selectedFontstyle, this.selectedFontsize);
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedFontname(String f) {
        this.selectedFontname = f;
    }

    public void setSelectedFontsize(int s) {
        this.selectedFontsize = s;
    }

    public void refresh(Font f, Color c) {
        if (f != null) {
            this.selectedFontname = f.getName();
            this.fonts.setSelectedItem(this.selectedFontname);
            this.selectedFontsize = f.getSize();
            this.sizes.setSelectedItem(Integer.toString(this.selectedFontsize));
            this.selectedFontstyle = f.getStyle();
            if (this.selectedFontstyle == 1) {
                this.cb_bold.setSelected(true);
            } else {
                this.cb_bold.setSelected(false);
            }
            if (this.selectedFontstyle == 2) {
                this.cb_italic.setSelected(true);
            } else {
                this.cb_italic.setSelected(false);
            }
        }
        if (c != null) {
            this.selectedColor = c;
            this.colorPreview.setColor(this.selectedColor);
        }
    }

    void refresh(Font f) {
        this.refresh(f, null);
    }

    Font show(Frame parent, int x, int y) {
        if (this.dialog == null) {
            JPanel panel = new JPanel(new BorderLayout());
            this.dialog = new JDialog(parent, "Font chooser", true);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PanelFonts.this.dialog.dispose();
                }
            });
            JPanel p = new JPanel(new FlowLayout());
            p.setBorder(BorderFactory.createEtchedBorder());
            JButton b = new JButton("Apply");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelFonts.this.result = PanelFonts.this.getSelectedFont();
                    PanelFonts.this.dialog.dispose();
                }
            });
            p.add(b);
            b = new JButton("Cancel");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelFonts.this.result = null;
                    PanelFonts.this.dialog.dispose();
                }
            });
            p.add(b);
            panel.add((Component)this, "Center");
            panel.add((Component)p, "South");
            this.dialog.getContentPane().add(panel);
            this.dialog.setLocation(x, y);
            this.dialog.pack();
        }
        this.dialog.setVisible(true);
        return this.result;
    }
}

