/*
 * Decompiled with CFR 0.152.
 */
package jplot.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import jplot.GraphSettings;
import jplot.JPlot;
import jplot.LinePars;
import jplot.LineStyle;
import jplot.SmallColorPreview;
import jplot.Utils;
import jplot.panels.PanelColor;
import jplot.panels.PanelGridUI;

public class PanelAxes
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTabbedPane tabbedPane;
    private JDialog dialog;
    private final String title = "Axes settings";
    private PanelColor colorPanel;
    private AxesOptions axesPanel;
    private GridOptions gridPanel;
    private BoxOptions boxPanel;
    private GraphSettings gs;
    private JPlot jplot;

    public PanelAxes(JPlot jp, GraphSettings _gs) {
        this.gs = _gs;
        this.jplot = jp;
        this.tabbedPane = new JTabbedPane();
        this.axesPanel = new AxesOptions();
        this.tabbedPane.add("Axes and tics", this.axesPanel);
        this.gridPanel = new GridOptions();
        this.tabbedPane.add("Grid options", this.gridPanel);
        this.boxPanel = new BoxOptions();
        this.tabbedPane.add("Boxes and fillcolors", this.boxPanel);
        this.add(this.tabbedPane);
        JPanel panel = new JPanel(new BorderLayout());
        this.dialog = new JDialog(this.jplot.frame, "Axes settings", false);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PanelAxes.this.dialog.dispose();
            }
        });
        JPanel p = new JPanel(new FlowLayout());
        p.setBorder(BorderFactory.createEtchedBorder());
        JButton b = new JButton("Apply");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelAxes.this.setValues();
            }
        });
        p.add(b);
        b = new JButton("Dismiss");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelAxes.this.dialog.dispose();
            }
        });
        p.add(b);
        panel.add((Component)this, "Center");
        panel.add((Component)p, "South");
        this.dialog.getContentPane().add(panel);
    }

    public void setValues() {
        this.axesPanel.setValues();
        this.gridPanel.setValues();
        this.boxPanel.setValues();
    }

    public void refresh() {
        this.axesPanel.refresh();
        this.gridPanel.refresh();
        this.boxPanel.refresh();
    }

    public void show(int x, int y) {
        this.refresh();
        this.dialog.setLocation(x, y);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    private Color getColor(Color color) {
        if (this.colorPanel == null) {
            this.colorPanel = new PanelColor(this.jplot.frame, color);
        } else {
            this.colorPanel.refresh(color);
        }
        return this.colorPanel.show(this.jplot.frame, color, 100, 100);
    }

    public class AxesOptions
    extends JPanel {
        private JCheckBox[] cb_showAxis;
        private JCheckBox[] cb_mirrorAxis;
        private JCheckBox[] cb_showTics;
        private JCheckBox[] cb_mirrorTics;
        private JCheckBox[] cb_rotateTics;
        private JCheckBox[] cb_numTics;
        private JTextField[] numTics;
        private JTextField[] tlField;
        private LineStyle lineStyle;
        private Color axesColor;
        private JPanel linePanel;
        private JCheckBox cb_autoRatio;
        private JCheckBox cb_manuRatio;
        private JTextField ratio;

        public AxesOptions() {
            JLabel label;
            PanelGridUI p;
            PanelAxes.this.gs;
            this.cb_showAxis = new JCheckBox[2];
            PanelAxes.this.gs;
            this.cb_mirrorAxis = new JCheckBox[2];
            PanelAxes.this.gs;
            this.cb_showTics = new JCheckBox[2];
            PanelAxes.this.gs;
            this.cb_mirrorTics = new JCheckBox[2];
            PanelAxes.this.gs;
            this.cb_rotateTics = new JCheckBox[2];
            PanelAxes.this.gs;
            this.cb_numTics = new JCheckBox[2];
            PanelAxes.this.gs;
            this.numTics = new JTextField[2];
            PanelAxes.this.gs;
            this.tlField = new JTextField[2];
            EmptyBorder border = new EmptyBorder(new Insets(0, 0, 0, 10));
            this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            Dimension mediumField = new Dimension(100, 20);
            this.setLayout(new BoxLayout(this, 1));
            this.makeRatio();
            int k = 0;
            while (true) {
                PanelAxes.this.gs;
                if (k >= 2) break;
                this.makeWidgets(k);
                p = new PanelGridUI();
                if (k == 0) {
                    p.setBorder(new TitledBorder(new EtchedBorder(), "X-Axis"));
                } else {
                    p.setBorder(new TitledBorder(new EtchedBorder(), "Y-Axis"));
                }
                label = new JLabel("Axis:");
                label.setBorder(border);
                p.addComponent(label, 1, 1);
                p.addComponent(this.cb_showAxis[k], 1, 2);
                p.addComponent(this.cb_mirrorAxis[k], 1, 3);
                label = new JLabel("Tics:");
                label.setBorder(border);
                p.addComponent(label, 2, 1);
                p.addComponent(this.cb_showTics[k], 2, 2);
                p.addComponent(this.cb_mirrorTics[k], 2, 3);
                p.addComponent(this.cb_rotateTics[k], 2, 4);
                p.addComponent(this.cb_numTics[k], 3, 2);
                p.addComponent(this.numTics[k], 3, 3);
                JPanel lPanel = new JPanel(new BorderLayout());
                lPanel.add((Component)Utils.makeLabel("length"), "West");
                lPanel.add((Component)this.tlField[k], "Center");
                p.addComponent(lPanel, 3, 4);
                this.add(p);
                ++k;
            }
            p = new PanelGridUI();
            p.setBorder(new EtchedBorder());
            label = new JLabel("X/Y ratio:");
            label.setBorder(border);
            p.addComponent(label, 1, 1);
            p.addComponent(this.cb_autoRatio, 1, 2);
            p.addComponent(this.cb_manuRatio, 1, 3);
            p.addFilledComponent(this.ratio, 1, 4);
            JButton b_color = new JButton(PanelAxes.this.jplot.getImageIcon("color.jpg"));
            b_color.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color color = PanelAxes.this.getColor(AxesOptions.this.axesColor);
                    if (color != null) {
                        AxesOptions.this.axesColor = color;
                        AxesOptions.this.lineStyle.setColor(AxesOptions.this.axesColor);
                        AxesOptions.this.linePanel.repaint();
                        AxesOptions.this.setValues();
                        PanelAxes.this.jplot.updateGraphIfShowing();
                        PanelAxes.this.gs.setDataChanged(true);
                    }
                }
            });
            b_color.setMargin(new Insets(0, 0, 0, 0));
            b_color.setToolTipText("Set the box drawing color");
            this.lineStyle = new LineStyle(new LinePars());
            this.lineStyle.setColor(this.axesColor);
            this.linePanel = new JPanel(new FlowLayout());
            this.linePanel.add(this.lineStyle);
            this.linePanel.add(b_color);
            label = new JLabel("Axes color:");
            label.setBorder(border);
            p.addComponent(label, 2, 1);
            p.addComponent(this.linePanel, 2, 2);
            this.add(p);
        }

        private void makeRatio() {
            ButtonGroup bg = new ButtonGroup();
            this.cb_autoRatio = new JCheckBox("automatic", !PanelAxes.this.gs.useAxesRatio());
            this.cb_autoRatio.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AxesOptions.this.ratio.setEnabled(false);
                }
            });
            this.cb_manuRatio = new JCheckBox("manual:", PanelAxes.this.gs.useAxesRatio());
            this.cb_manuRatio.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AxesOptions.this.ratio.setEnabled(true);
                }
            });
            bg.add(this.cb_autoRatio);
            bg.add(this.cb_manuRatio);
            this.ratio = new JTextField(Float.toString((float)PanelAxes.this.gs.getAxesRatio()));
            this.ratio.setColumns(7);
            this.ratio.setEnabled(false);
        }

        private void makeWidgets(final int axis) {
            this.cb_showTics[axis] = new JCheckBox("show", PanelAxes.this.gs.drawTics(axis));
            this.cb_showTics[axis].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean b = AxesOptions.this.cb_showTics[axis].isSelected();
                    AxesOptions.this.tlField[axis].setEnabled(b);
                    AxesOptions.this.cb_numTics[axis].setEnabled(b);
                    AxesOptions.this.numTics[axis].setEnabled(b);
                    AxesOptions.this.cb_mirrorTics[axis].setEnabled(b);
                    AxesOptions.this.cb_rotateTics[axis].setEnabled(b);
                }
            });
            this.cb_showAxis[axis] = new JCheckBox("show", PanelAxes.this.gs.drawAxis(axis));
            this.cb_showAxis[axis].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean b = AxesOptions.this.cb_showAxis[axis].isSelected();
                    AxesOptions.this.cb_mirrorAxis[axis].setEnabled(b);
                }
            });
            this.tlField[axis] = new JTextField();
            this.tlField[axis].setColumns(4);
            this.cb_mirrorAxis[axis] = new JCheckBox("mirror", PanelAxes.this.gs.drawMirrorAxis(axis));
            this.cb_mirrorTics[axis] = new JCheckBox("mirror", PanelAxes.this.gs.drawMirrorTics(axis));
            this.cb_rotateTics[axis] = new JCheckBox("rotate", PanelAxes.this.gs.rotateTics(axis));
            this.cb_numTics[axis] = new JCheckBox("set number:", PanelAxes.this.gs.useNumberOfTics(axis));
            this.cb_numTics[axis].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AxesOptions.this.numTics[axis].setEnabled(AxesOptions.this.cb_numTics[axis].isSelected());
                }
            });
            this.numTics[axis] = new JTextField(Integer.toString(PanelAxes.this.gs.getNumberOfTics(axis)));
            this.numTics[axis].setColumns(4);
            this.numTics[axis].setEnabled(this.cb_numTics[axis].isSelected());
        }

        public void refresh() {
            int k = 0;
            while (true) {
                PanelAxes.this.gs;
                if (k >= 2) break;
                this.cb_showAxis[k].setSelected(PanelAxes.this.gs.drawAxis(k));
                this.cb_mirrorAxis[k].setSelected(PanelAxes.this.gs.drawMirrorAxis(k));
                this.cb_showTics[k].setSelected(PanelAxes.this.gs.drawTics(k));
                this.cb_mirrorTics[k].setSelected(PanelAxes.this.gs.drawMirrorTics(k));
                this.tlField[k].setText(Float.toString((float)PanelAxes.this.gs.getTicLength(k)));
                this.cb_numTics[k].setSelected(PanelAxes.this.gs.useNumberOfTics(k));
                this.numTics[k].setText(Integer.toString(PanelAxes.this.gs.getNumberOfTics(k)));
                this.cb_rotateTics[k].setSelected(PanelAxes.this.gs.rotateTics(k));
                ++k;
            }
            this.cb_manuRatio.setSelected(PanelAxes.this.gs.useAxesRatio());
            this.cb_autoRatio.setSelected(!PanelAxes.this.gs.useAxesRatio());
            this.ratio.setText(Float.toString((float)PanelAxes.this.gs.getAxesRatio()));
            this.axesColor = PanelAxes.this.gs.getAxesColor();
            this.lineStyle.setColor(this.axesColor);
        }

        public void setValues() {
            int k = 0;
            while (true) {
                PanelAxes.this.gs;
                if (k >= 2) break;
                PanelAxes.this.gs.setDrawAxis(k, this.cb_showAxis[k].isSelected());
                PanelAxes.this.gs.setDrawMirrorAxis(k, this.cb_mirrorAxis[k].isSelected());
                PanelAxes.this.gs.setDrawTics(k, this.cb_showTics[k].isSelected());
                PanelAxes.this.gs.setDrawMirrorTics(k, this.cb_mirrorTics[k].isSelected());
                PanelAxes.this.gs.setTicLength(k, Float.parseFloat(this.tlField[k].getText()));
                PanelAxes.this.gs.setUseNumberOfTics(k, this.cb_numTics[k].isSelected());
                PanelAxes.this.gs.setRotateTics(k, this.cb_rotateTics[k].isSelected());
                if (this.cb_numTics[k].isSelected() && !this.numTics[k].getText().equals("")) {
                    PanelAxes.this.gs.setNumberOfTics(k, Integer.parseInt(this.numTics[k].getText()));
                }
                ++k;
            }
            PanelAxes.this.gs.setUseAxesRatio(this.cb_manuRatio.isSelected());
            if (!this.ratio.getText().equals("")) {
                PanelAxes.this.gs.setAxesRatio(Double.parseDouble(this.ratio.getText()));
            }
            PanelAxes.this.gs.setAxesColor(this.axesColor);
            PanelAxes.this.jplot.updateGraphIfShowing();
            PanelAxes.this.gs.setDataChanged(true);
        }
    }

    public class GridOptions
    extends PanelGridUI {
        private JCheckBox cb_hg;
        private JCheckBox cb_vg;
        private JCheckBox cb_front;
        private JCheckBox cb_back;
        private JPanel gridStylePanel;
        private JPanel boxFillPanel;
        private JPanel innerPanel;
        private LineStyle lineStyle;
        private Color actualColor;

        public GridOptions() {
            this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            EmptyBorder border = new EmptyBorder(new Insets(0, 0, 0, 10));
            GraphSettings graphSettings = PanelAxes.this.gs;
            PanelAxes.this.gs;
            this.cb_hg = new JCheckBox("y-axis", graphSettings.drawGrid(1));
            GraphSettings graphSettings2 = PanelAxes.this.gs;
            PanelAxes.this.gs;
            this.cb_vg = new JCheckBox("x-axis", graphSettings2.drawGrid(0));
            this.cb_back = new JCheckBox("back", !PanelAxes.this.gs.gridToFront());
            this.cb_front = new JCheckBox("front", PanelAxes.this.gs.gridToFront());
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.cb_back);
            bg.add(this.cb_front);
            this.lineStyle = new LineStyle(new LinePars());
            this.lineStyle.setColor(this.actualColor);
            JButton b_color = new JButton(PanelAxes.this.jplot.getImageIcon("color.jpg"));
            b_color.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color color = PanelAxes.this.getColor(GridOptions.this.actualColor);
                    if (color != null) {
                        GridOptions.this.actualColor = color;
                        GridOptions.this.lineStyle.setColor(GridOptions.this.actualColor);
                        GridOptions.this.lineStyle.repaint();
                        GridOptions.this.setValues();
                    }
                }
            });
            b_color.setMargin(new Insets(0, 0, 0, 0));
            b_color.setToolTipText("Gridline color");
            this.gridStylePanel = new JPanel(new FlowLayout());
            this.gridStylePanel.add(this.lineStyle);
            this.gridStylePanel.add(b_color);
            JLabel label = new JLabel("Grid lines:");
            label.setBorder(border);
            this.addComponent(label, 1, 1);
            this.addComponent(this.cb_hg, 1, 2);
            this.addComponent(this.cb_vg, 1, 3);
            label = new JLabel("Drawing:");
            label.setBorder(border);
            this.addComponent(label, 2, 1);
            this.addComponent(this.cb_front, 2, 2);
            this.addComponent(this.cb_back, 2, 3);
            label = new JLabel("Color:");
            label.setBorder(border);
            this.addComponent(label, 3, 1);
            this.addComponent(this.gridStylePanel, 3, 2);
        }

        public void refresh() {
            GraphSettings graphSettings = PanelAxes.this.gs;
            PanelAxes.this.gs;
            this.cb_hg.setSelected(graphSettings.drawGrid(1));
            GraphSettings graphSettings2 = PanelAxes.this.gs;
            PanelAxes.this.gs;
            this.cb_vg.setSelected(graphSettings2.drawGrid(0));
            this.cb_back.setSelected(!PanelAxes.this.gs.gridToFront());
            this.cb_front.setSelected(PanelAxes.this.gs.gridToFront());
            this.actualColor = PanelAxes.this.gs.getGridColor();
            this.lineStyle.setColor(this.actualColor);
        }

        public void setValues() {
            PanelAxes.this.gs.setGridToFront(this.cb_front.isSelected());
            PanelAxes.this.gs.setGridColor(this.actualColor);
            GraphSettings graphSettings = PanelAxes.this.gs;
            PanelAxes.this.gs;
            graphSettings.setDrawGrid(0, this.cb_vg.isSelected());
            GraphSettings graphSettings2 = PanelAxes.this.gs;
            PanelAxes.this.gs;
            graphSettings2.setDrawGrid(1, this.cb_hg.isSelected());
            PanelAxes.this.jplot.updateGraphIfShowing();
            PanelAxes.this.gs.setDataChanged(true);
        }
    }

    public class BoxOptions
    extends PanelGridUI {
        private SmallColorPreview graphFillColorPreview;
        private SmallColorPreview triangleFillColorPreview;
        private SmallColorPreview boxFillColorPreview;
        private SmallColorPreview panelFillColorPreview;
        private Color boxFillColor;
        private Color triangleFillColor;
        private Color graphFillColor;
        private Color panelFillColor;
        private Color boxLineColor;
        private JCheckBox cb_showBox;
        private JCheckBox cb_hideBox;
        private JCheckBox cb_showInner;
        private JCheckBox cb_hideInner;
        private JTextField offsetField;
        private JPanel graphFillPanel;
        private JPanel boxFillPanel;
        private JPanel panelFillPanel;
        private JPanel triangleFillPanel;
        private LineStyle lineStyle;

        public BoxOptions() {
            this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            EmptyBorder border = new EmptyBorder(new Insets(0, 0, 0, 10));
            JButton b_color = new JButton(PanelAxes.this.jplot.getImageIcon("color.jpg"));
            b_color.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color color = PanelAxes.this.getColor(BoxOptions.this.panelFillColor);
                    if (color != null) {
                        BoxOptions.this.panelFillColor = color;
                        BoxOptions.this.panelFillColorPreview.setColor(BoxOptions.this.panelFillColor);
                        BoxOptions.this.panelFillPanel.repaint();
                        BoxOptions.this.setValues();
                    }
                }
            });
            b_color.setMargin(new Insets(0, 0, 0, 0));
            b_color.setToolTipText("Set the overall background fill color");
            this.panelFillColorPreview = new SmallColorPreview(this.panelFillColor, 50, 18);
            this.panelFillPanel = new JPanel(new FlowLayout());
            this.panelFillPanel.add(this.panelFillColorPreview);
            this.panelFillPanel.add(b_color);
            JLabel label = new JLabel("Panel background:");
            label.setBorder(border);
            this.addComponent(label, 1, 1);
            this.addComponent(this.panelFillPanel, 1, 2);
            b_color = new JButton(PanelAxes.this.jplot.getImageIcon("color.jpg"));
            b_color.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color color = PanelAxes.this.getColor(BoxOptions.this.graphFillColor);
                    if (color != null) {
                        BoxOptions.this.graphFillColor = color;
                        BoxOptions.this.graphFillColorPreview.setColor(BoxOptions.this.graphFillColor);
                        BoxOptions.this.graphFillPanel.repaint();
                        BoxOptions.this.setValues();
                    }
                }
            });
            b_color.setMargin(new Insets(0, 0, 0, 0));
            b_color.setToolTipText("Set the graph background fill color");
            this.graphFillColorPreview = new SmallColorPreview(this.graphFillColor, 50, 18);
            this.graphFillPanel = new JPanel(new FlowLayout());
            this.graphFillPanel.add(this.graphFillColorPreview);
            this.graphFillPanel.add(b_color);
            label = new JLabel("Graph background:");
            label.setBorder(border);
            this.addComponent(label, 2, 1);
            this.addComponent(this.graphFillPanel, 2, 2);
            b_color = new JButton(PanelAxes.this.jplot.getImageIcon("color.jpg"));
            b_color.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color color = PanelAxes.this.getColor(BoxOptions.this.boxFillColor);
                    if (color != null) {
                        BoxOptions.this.boxFillColor = color;
                        BoxOptions.this.boxFillColorPreview.setColor(BoxOptions.this.boxFillColor);
                        BoxOptions.this.boxFillPanel.repaint();
                        BoxOptions.this.setValues();
                    }
                }
            });
            b_color.setMargin(new Insets(0, 0, 0, 0));
            b_color.setToolTipText("Set the box fill color");
            this.boxFillColorPreview = new SmallColorPreview(this.boxFillColor, 50, 18);
            this.boxFillPanel = new JPanel(new FlowLayout());
            this.boxFillPanel.add(this.boxFillColorPreview);
            this.boxFillPanel.add(b_color);
            b_color = new JButton(PanelAxes.this.jplot.getImageIcon("color.jpg"));
            b_color.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color color = PanelAxes.this.getColor(BoxOptions.this.boxLineColor);
                    if (color != null) {
                        BoxOptions.this.boxLineColor = color;
                        BoxOptions.this.lineStyle.setColor(BoxOptions.this.boxLineColor);
                        BoxOptions.this.lineStyle.repaint();
                        BoxOptions.this.setValues();
                    }
                }
            });
            b_color.setMargin(new Insets(0, 0, 0, 0));
            b_color.setToolTipText("Set the axes color");
            this.lineStyle = new LineStyle(new LinePars());
            this.lineStyle.setColor(this.boxLineColor);
            JPanel linePanel = new JPanel(new FlowLayout());
            linePanel.add(this.lineStyle);
            linePanel.add(b_color);
            this.offsetField = new JTextField();
            this.offsetField.setColumns(4);
            JPanel offsetPanel = new JPanel(new BorderLayout());
            offsetPanel.add((Component)Utils.makeLabel("offset"), "West");
            offsetPanel.add((Component)this.offsetField, "Center");
            ButtonGroup bg = new ButtonGroup();
            this.cb_showBox = new JCheckBox("Show");
            this.cb_hideBox = new JCheckBox("Hide");
            bg.add(this.cb_showBox);
            bg.add(this.cb_hideBox);
            label = new JLabel("Bounding box:");
            label.setBorder(border);
            this.addComponent(label, 3, 1);
            this.addComponent(this.cb_showBox, 3, 2);
            this.addComponent(this.cb_hideBox, 3, 3);
            this.addComponent(offsetPanel, 4, 2);
            this.addComponent(this.boxFillPanel, 5, 2);
            this.addComponent(linePanel, 5, 3);
            int n = PanelAxes.this.gs.getGraphType();
            PanelAxes.this.gs;
            if (n == 1) {
                b_color = new JButton(PanelAxes.this.jplot.getImageIcon("color.jpg"));
                b_color.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Color color = PanelAxes.this.getColor(BoxOptions.this.triangleFillColor);
                        if (color != null) {
                            BoxOptions.this.triangleFillColor = color;
                            BoxOptions.this.triangleFillColorPreview.setColor(BoxOptions.this.triangleFillColor);
                            BoxOptions.this.triangleFillPanel.repaint();
                            BoxOptions.this.setValues();
                        }
                    }
                });
                b_color.setMargin(new Insets(0, 0, 0, 0));
                b_color.setToolTipText("Set the box fill color");
                this.triangleFillColorPreview = new SmallColorPreview(this.triangleFillColor, 50, 18);
                this.triangleFillPanel = new JPanel(new FlowLayout());
                this.triangleFillPanel.add(this.triangleFillColorPreview);
                this.triangleFillPanel.add(b_color);
                bg = new ButtonGroup();
                this.cb_showInner = new JCheckBox("Show");
                this.cb_hideInner = new JCheckBox("Hide");
                bg.add(this.cb_showInner);
                bg.add(this.cb_hideInner);
                label = new JLabel("Inner triangles:");
                label.setBorder(border);
                this.addComponent(label, 5, 1);
                this.addComponent(this.cb_showInner, 5, 2);
                this.addComponent(this.cb_hideInner, 5, 3);
                this.addComponent(this.triangleFillPanel, 6, 2);
            }
        }

        public void refresh() {
            this.panelFillColor = PanelAxes.this.gs.getBackgroundColor();
            this.panelFillColorPreview.setColor(this.panelFillColor);
            this.graphFillColor = PanelAxes.this.gs.getGraphBackgroundColor();
            this.graphFillColorPreview.setColor(this.graphFillColor);
            this.boxFillColor = PanelAxes.this.gs.getBoxFillColor();
            this.boxFillColorPreview.setColor(this.boxFillColor);
            this.boxLineColor = PanelAxes.this.gs.getBoxColor();
            this.lineStyle.setColor(this.boxLineColor);
            this.cb_showBox.setSelected(PanelAxes.this.gs.drawBox());
            this.cb_hideBox.setSelected(!PanelAxes.this.gs.drawBox());
            this.offsetField.setText(Float.toString(PanelAxes.this.gs.getBoxOffset()));
            int n = PanelAxes.this.gs.getGraphType();
            PanelAxes.this.gs;
            if (n == 1) {
                this.triangleFillColor = PanelAxes.this.gs.getInnerColor();
                this.triangleFillColorPreview.setColor(this.triangleFillColor);
                this.cb_showInner.setSelected(PanelAxes.this.gs.drawInner());
                this.cb_hideInner.setSelected(!PanelAxes.this.gs.drawInner());
            }
        }

        public void setValues() {
            PanelAxes.this.gs.setBackgroundColor(this.panelFillColor);
            PanelAxes.this.gs.setGraphBackgroundColor(this.graphFillColor);
            PanelAxes.this.gs.setBoxFillColor(this.boxFillColor);
            PanelAxes.this.gs.setBoxColor(this.boxLineColor);
            PanelAxes.this.gs.setDrawBox(this.cb_showBox.isSelected());
            PanelAxes.this.gs.setBoxOffset(Float.parseFloat(this.offsetField.getText()));
            int n = PanelAxes.this.gs.getGraphType();
            PanelAxes.this.gs;
            if (n == 1) {
                PanelAxes.this.gs.setInnerColor(this.triangleFillColor);
                PanelAxes.this.gs.setDrawInner(this.cb_showInner.isSelected());
            }
            PanelAxes.this.jplot.updateGraphIfShowing();
            PanelAxes.this.gs.setDataChanged(true);
        }
    }
}

