/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Utils {
    static final String empty = "            ";
    private static JColorChooser colorChooser;
    public static final String lf;
    public static final String fs;
    public static NumberFormat numberFormat;

    public static JColorChooser getColorChooser() {
        if (colorChooser == null) {
            colorChooser = new JColorChooser();
        }
        return colorChooser;
    }

    public static boolean isUnix() {
        return fs.equals("/");
    }

    public static int getNumDigits(double num) {
        int numDigits;
        if (num == 0.0) {
            return 0;
        }
        for (numDigits = 0; numDigits <= 15 && Math.abs(Math.floor(num) / num - 1.0) > 1.0E-10; ++numDigits) {
            num *= 10.0;
        }
        return numDigits;
    }

    public static double roundUp(double val) {
        int exponent;
        if ((val *= Math.pow(10.0, -(exponent = (int)Math.floor(Math.log10(val))))) > 5.0) {
            val = 10.0;
        } else if (val > 2.0) {
            val = 5.0;
        } else if (val > 1.0) {
            val = 2.0;
        }
        return val *= Math.pow(10.0, exponent);
    }

    public static int numFracDigits(double num) {
        int numdigits;
        for (numdigits = 0; numdigits <= 15 && num != Math.floor(num); num *= 10.0, ++numdigits) {
        }
        return numdigits;
    }

    public static String formatNum(double num, int numfracdigits) {
        if (numberFormat == null) {
            numberFormat = NumberFormat.getInstance();
            numberFormat.setGroupingUsed(false);
        }
        numberFormat.setMinimumFractionDigits(numfracdigits);
        numberFormat.setMaximumFractionDigits(numfracdigits);
        return numberFormat.format(num);
    }

    public static String[] FormPow(String num, boolean isLog) {
        String stext = num;
        String[] out = new String[]{" ", " ", stext};
        double f = Double.parseDouble(num);
        if (isLog && stext.indexOf(".") > -1 && stext.endsWith("0")) {
            if ((stext = stext.substring(0, stext.length() - 1)).endsWith(".")) {
                stext = stext.substring(0, stext.length() - 1);
            }
            out[0] = "";
            out[1] = "";
            out[2] = stext;
        }
        if (Math.abs(f) < 1001.0 && Math.abs(f) > 9.0E-4) {
            return out;
        }
        DecimalFormat dfb = new DecimalFormat("#.##E00");
        String sub1 = stext = dfb.format((Object)f);
        String sub2 = stext;
        int ie = stext.indexOf("E");
        int iem = stext.indexOf("E-");
        if (ie > -1 && iem == -1) {
            sub1 = stext.substring(ie + 1, stext.length());
            sub2 = stext.substring(0, ie);
            if (sub1.startsWith("0")) {
                sub1 = stext.substring(ie + 2, stext.length());
            }
            stext = sub1.startsWith("0") ? sub2 : sub2 + "\u00b710^{" + sub1 + "}";
            out[0] = sub2;
            out[1] = sub1;
            out[2] = stext;
        }
        if (iem > -1) {
            sub1 = stext.substring(ie + 2, stext.length());
            sub2 = stext.substring(0, ie);
            if (sub1.startsWith("0")) {
                sub1 = stext.substring(ie + 3, stext.length());
            }
            if (sub1.startsWith("0")) {
                stext = sub2;
                out[0] = "";
                out[1] = "";
                out[2] = sub2;
            } else {
                stext = sub2 + "\u00b710^{-" + sub1 + "}";
                out[0] = sub2;
                out[1] = sub1;
                out[2] = stext;
            }
        }
        return out;
    }

    public static String[] skeepZero(String[] len) {
        String[] tmp = len;
        for (int i = 0; i < tmp.length; ++i) {
            if (len[i].indexOf("10^") > -1) {
                tmp[i] = len[i];
            } else {
                len[i] = len[i].replace(',', '.');
                double aDouble = Double.parseDouble(len[i]);
                tmp[i] = Double.toString(aDouble);
                if (tmp[i].endsWith(".0")) {
                    tmp[i] = tmp[i].substring(0, tmp[i].length() - 2);
                }
            }
            if (!tmp[i].equalsIgnoreCase("10^{1}")) continue;
            tmp[i] = "10";
        }
        return tmp;
    }

    public static String FormLin(double f) {
        String stext;
        if (Math.abs(f) < 1001.0 && Math.abs(f) >= 0.0) {
            DecimalFormat dfb = new DecimalFormat("#.#E00");
            String yy = dfb.format(f);
            float ss = (float)Double.valueOf(yy.trim()).doubleValue();
            yy = Float.toString(ss);
            yy = Utils.RemoveZero(yy);
            return yy;
        }
        DecimalFormat dfb = new DecimalFormat("#.#E00");
        String sub1 = stext = dfb.format((Object)f);
        String sub2 = stext;
        int ie = stext.indexOf("E");
        int iem = stext.indexOf("E-");
        if (ie > -1 && iem == -1) {
            sub1 = stext.substring(ie + 1, stext.length());
            sub2 = stext.substring(0, ie);
            if (sub1.startsWith("0")) {
                sub1 = stext.substring(ie + 2, stext.length());
            }
            stext = sub1.startsWith("0") ? sub2 : sub2 + "\u00b710^{" + sub1 + "}";
        }
        if (iem > -1) {
            sub1 = stext.substring(ie + 2, stext.length());
            sub2 = stext.substring(0, ie);
            if (sub1.startsWith("0")) {
                sub1 = stext.substring(ie + 3, stext.length());
            }
            stext = sub1.startsWith("0") ? sub2 : sub2 + "\u00b710^{-" + sub1 + "}";
        }
        return stext;
    }

    public static String RemoveZero(String s) {
        String aString = s;
        if (aString.indexOf(".") > -1 && aString.endsWith("0") && (aString = aString.substring(0, aString.length() - 1)).endsWith(".")) {
            aString = aString.substring(0, aString.length() - 1);
        }
        return aString;
    }

    public static String FormLin(float f) {
        return Utils.FormLin((double)f);
    }

    public static String FormNum(double x, double xmin, double xmax) {
        String tmp = "";
        DecimalFormat dfb = null;
        double xx = Math.abs(xmax - xmin);
        dfb = new DecimalFormat("0.0#");
        if (xx >= 0.1) {
            dfb = new DecimalFormat("0.0#");
        }
        if (xx < 0.1 && xx >= 0.01) {
            dfb = new DecimalFormat("0.00#");
        }
        if (xx < 0.01 && xx >= 0.001) {
            dfb = new DecimalFormat("0.000#");
        }
        if (xx < 0.001 && xx >= 1.0E-4) {
            dfb = new DecimalFormat("0.0000#");
        }
        if (xx < 1.0E-4 && xx >= 1.0E-5) {
            dfb = new DecimalFormat("0.00000#");
        }
        if (xx < 1.0E-5 && xx >= 1.0E-6) {
            dfb = new DecimalFormat("0.000000#");
        }
        if (xx < 1.0E-6 && xx >= 1.0E-7) {
            dfb = new DecimalFormat("0.0000000#");
        }
        if (xx < 1.0E-7) {
            dfb = new DecimalFormat("0.0000000000#");
        }
        tmp = dfb.format((Object)x);
        return tmp;
    }

    public static String FormLog(float f) {
        return Utils.FormLog((double)f);
    }

    public static String FormLog(double f) {
        String stext = "";
        DecimalFormat dfb = new DecimalFormat("#.#E00");
        String sub1 = stext = dfb.format((Object)f);
        String sub2 = stext;
        int ie = stext.indexOf("E");
        int iem = stext.indexOf("E-");
        if (ie > -1 && iem == -1) {
            sub1 = stext.substring(ie + 1, stext.length());
            sub2 = stext.substring(0, ie);
            if (sub1.startsWith("0")) {
                sub1 = stext.substring(ie + 2, stext.length());
            }
            stext = sub1.startsWith("0") ? "1" : "10^{" + sub1 + "}";
        }
        if (iem > -1) {
            sub1 = stext.substring(ie + 2, stext.length());
            sub2 = stext.substring(0, ie);
            if (sub1.startsWith("0")) {
                sub1 = stext.substring(ie + 3, stext.length());
            }
            stext = sub1.startsWith("0") ? sub2 : "10^{-" + sub1 + "}";
        }
        return stext;
    }

    public static void oops(Frame parent, String s) {
        JOptionPane.showMessageDialog(parent, s, "Oops", 1);
    }

    public static void bummer(Frame parent, String s) {
        JOptionPane.showMessageDialog(parent, s, "Bummer", 0);
    }

    public static Font getDefaultFont() {
        return new Font("Helvetica", 1, 12);
    }

    public static JLabel makeLabel(String txt) {
        JLabel label = new JLabel(txt + " ");
        label.setVerticalAlignment(3);
        label.setHorizontalAlignment(0);
        label.setFont(new Font("SansSerif", 1, 12));
        label.setForeground(Color.black);
        return label;
    }

    public static JCheckBox createCheckBox(String s, boolean b) {
        JCheckBox cb = new JCheckBox(" " + s + " ", b);
        cb.setFont(new Font("serif", 0, 11));
        cb.setHorizontalAlignment(2);
        return cb;
    }

    static String getSetting(StringBuffer sb, String indent, String key, Vector v, boolean close) {
        sb.setLength(0);
        sb.append(indent).append("<").append(key);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            sb.append(" ").append((String)e.nextElement()).append("=\"").append((String)e.nextElement()).append("\"");
        }
        if (close) {
            sb.append("/>");
        } else {
            sb.append(">");
        }
        v.setSize(0);
        return sb.toString();
    }

    static String getSetting(StringBuffer sb, String indent, String key, Vector v) {
        return Utils.getSetting(sb, indent, key, v, true);
    }

    static String getSetting(StringBuffer sb, String indent, String key, Color c) {
        sb.setLength(0);
        sb.append(indent).append("<").append(key);
        sb.append(" red=\"").append(c.getRed());
        sb.append("\" green=\"").append(c.getRed());
        sb.append("\" blue=\"").append(c.getRed()).append("\"/>");
        return sb.toString();
    }

    static String getSetting(StringBuffer sb, String indent, String key, Font f) {
        sb.setLength(0);
        sb.append(indent).append("<").append(key);
        sb.append(" name=\"").append(f.getName());
        sb.append("\" style=\"").append(f.getStyle());
        sb.append("\" size=\"").append(f.getSize()).append("\"/>");
        return sb.toString();
    }

    public static double RoundUp(double val) {
        int i;
        int exponent = (int)Math.floor(Math.log10(val));
        if (exponent < 0) {
            for (i = exponent; i < 0; ++i) {
                val *= 10.0;
            }
        } else {
            for (i = 0; i < exponent; ++i) {
                val /= 10.0;
            }
        }
        val = val > 5.0 ? 10.0 : (val > 2.0 ? 5.0 : (val > 1.0 ? 2.0 : 1.0));
        if (exponent < 0) {
            for (i = exponent; i < 0; ++i) {
                val /= 10.0;
            }
        } else {
            for (i = 0; i < exponent; ++i) {
                val *= 10.0;
            }
        }
        return val;
    }

    static {
        lf = System.getProperty("line.separator");
        fs = System.getProperty("file.separator");
        numberFormat = null;
    }

    public static class CheckBoxWithText
    extends JPanel {
        JCheckBox checkbox;
        JLabel text;

        CheckBoxWithText(String label, String s) {
            this.checkbox = new JCheckBox(label);
            this.text = new JLabel(s);
            this.add(this.checkbox);
            this.add(this.text);
        }

        CheckBoxWithText(String label) {
            this(label, "");
        }

        public void setSelected(boolean b) {
            this.checkbox.setSelected(b);
        }

        public void setText(String s) {
            this.text.setText(s);
        }

        public String getText() {
            return this.text.getText();
        }
    }

    public static class LabeledTextField
    extends JPanel {
        private static final long serialVersionUID = 1L;
        public JTextField textfield;
        public JCheckBox checkbox;
        public JComboBox units;
        private boolean action;
        private String label;
        private boolean CheckBoxSet;
        private boolean UnitsSet;

        LabeledTextField(String lb, String text, boolean withUnits, boolean withCheckBox) {
            this.label = lb;
            if (!withCheckBox) {
                this.setLayout(new BoxLayout(this, 0));
            } else {
                this.setLayout(new FlowLayout());
            }
            JLabel l = new JLabel(this.label);
            l.setHorizontalTextPosition(4);
            this.textfield = new JTextField(text);
            l.setLabelFor(this.textfield);
            this.CheckBoxSet = withCheckBox;
            this.UnitsSet = withUnits;
            if (withCheckBox) {
                this.checkbox = new JCheckBox();
                this.add(this.checkbox);
            }
            this.add(l);
            this.add(this.textfield);
            if (withUnits) {
                this.units = new JComboBox();
                this.add(this.units);
            }
            this.action = true;
        }

        LabeledTextField(String label, String text, boolean withUnits) {
            this(label, text, withUnits, false);
        }

        LabeledTextField(String label, String text) {
            this(label, text, false);
        }

        LabeledTextField(String label, String text, int cols) {
            this(label, text);
            this.textfield.setColumns(cols);
        }

        LabeledTextField(String label, String text, boolean withUnits, int cols) {
            this(label, text, withUnits);
            this.textfield.setColumns(cols);
        }

        public void setUnits(Vector v) {
            if (this.UnitsSet) {
                this.action = false;
                if (this.units.getItemCount() > 0) {
                    this.units.removeAllItems();
                }
                if (v.size() == 0) {
                    this.units.setEnabled(false);
                    this.units.addItem(Utils.empty);
                } else {
                    this.units.setEnabled(true);
                    Enumeration e = v.elements();
                    while (e.hasMoreElements()) {
                        this.units.addItem(e.nextElement());
                    }
                }
                this.action = true;
            }
        }

        public void setUnits(String[] s) {
            if (this.UnitsSet) {
                this.action = false;
                if (this.units.getItemCount() > 0) {
                    this.units.removeAllItems();
                }
                if (s.length == 0) {
                    this.units.setEnabled(false);
                    this.units.addItem(Utils.empty);
                } else {
                    this.units.setEnabled(true);
                    for (int i = 0; i < s.length; ++i) {
                        this.units.addItem(s[i]);
                    }
                }
                this.action = true;
            }
        }

        public void setColumns(int cols) {
            this.textfield.setColumns(cols);
        }

        public String getUnit() {
            if (this.UnitsSet) {
                return (String)this.units.getSelectedItem();
            }
            return "";
        }

        public void setUnit(String u) {
            if (this.UnitsSet) {
                this.units.setSelectedItem(u);
            }
        }

        public String getText() {
            return this.textfield.getText();
        }

        public String getLabel() {
            return this.label;
        }

        public void setText(String s) {
            this.textfield.setText(s);
        }

        public void setEditable(boolean b) {
            this.textfield.setEditable(b);
        }

        @Override
        public void setEnabled(boolean b) {
            this.checkbox.setEnabled(b);
        }

        public void setSelected(boolean b) {
            this.textfield.setEnabled(b);
            if (this.CheckBoxSet) {
                this.checkbox.setSelected(b);
            }
            if (this.UnitsSet) {
                this.units.setEnabled(b);
            }
        }

        public boolean isSelected() {
            return this.checkbox.isSelected();
        }

        public boolean actionPerformed() {
            return this.action;
        }
    }

    public static class LabeledComboBox
    extends JPanel {
        public JComboBox combobox = new JComboBox();
        private boolean action;

        LabeledComboBox(String label, boolean editable) {
            this.combobox.setEditable(editable);
            this.action = true;
            this.setLayout(new FlowLayout());
            JLabel l = new JLabel(label);
            l.setHorizontalTextPosition(4);
            l.setLabelFor(this.combobox);
            this.add(l);
            this.add(this.combobox);
        }

        LabeledComboBox(String label, boolean editable, Vector v) {
            this(label, editable);
            this.replaceContent(v);
        }

        LabeledComboBox(String label, boolean editable, String[] s) {
            this(label, editable);
            this.replaceContent(s);
        }

        public void replaceContent(Vector v) {
            this.action = false;
            if (this.combobox.getItemCount() > 0) {
                this.combobox.removeAllItems();
            }
            if (v.size() == 0) {
                this.combobox.setEnabled(false);
                this.combobox.addItem(Utils.empty);
            } else {
                this.combobox.setEnabled(true);
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    this.combobox.addItem(e.nextElement());
                }
            }
            this.action = true;
        }

        public void replaceContent(String[] s) {
            this.action = false;
            if (this.combobox.getItemCount() > 0) {
                this.combobox.removeAllItems();
            }
            if (s.length == 0) {
                this.combobox.setEnabled(false);
                this.combobox.addItem(Utils.empty);
            } else {
                this.combobox.setEnabled(true);
                for (int i = 0; i < s.length; ++i) {
                    this.combobox.addItem(s[i]);
                }
            }
            this.action = true;
        }

        public boolean actionPerformed() {
            return this.action;
        }

        public void setSelectedItem(Object o) {
            this.combobox.setSelectedItem(o);
        }

        public String getSelectedItem() {
            if (this.combobox.isEnabled()) {
                return (String)this.combobox.getSelectedItem();
            }
            return "";
        }
    }
}

