/*
 * Decompiled with CFR 0.152.
 */
package jplot;

import java.util.HashMap;
import java.util.Map;

public class Translate {
    protected static Map refChar = new HashMap(1000);
    protected static Map charRefTable;

    private Translate() {
    }

    public static char convertToChar(String string) {
        char ret = '\u0000';
        int length = string.length();
        if (0 < length) {
            if ('&' == string.charAt(0)) {
                string = string.substring(1);
                --length;
            }
            if (0 < length) {
                if (';' == string.charAt(length - 1)) {
                    string = string.substring(0, --length);
                }
                if (0 < length) {
                    if ('#' == string.charAt(0)) {
                        try {
                            ret = (char)Integer.parseInt(string.substring(1));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else {
                        Character item = (Character)refChar.get(string);
                        if (null != item) {
                            ret = item.charValue();
                        }
                    }
                }
            }
        }
        return ret;
    }

    public static String decode(String string) {
        int amp;
        StringBuffer ret = new StringBuffer(string.length());
        int index = 0;
        int length = string.length();
        while (index < length && -1 != (amp = string.indexOf(38, index))) {
            int character;
            ret.append(string.substring(index, amp));
            index = amp + 1;
            if (amp < length - 1) {
                int semi = string.indexOf(59, amp);
                String code = -1 != semi ? string.substring(amp, semi + 1) : string.substring(amp);
                character = Translate.convertToChar(code);
                if (0 != character) {
                    index += code.length() - 1;
                } else {
                    character = 38;
                }
            } else {
                character = 38;
            }
            ret.append((char)character);
        }
        if (index < length) {
            ret.append(string.substring(index));
        }
        return ret.toString();
    }

    public static String shrink(String string) {
        int amp;
        StringBuffer ret = new StringBuffer(string.length());
        int index = 0;
        int length = string.length();
        while (index < length && -1 != (amp = string.indexOf(38, index))) {
            int character;
            ret.append(string.substring(index, amp));
            index = amp + 1;
            if (amp < length - 1) {
                int semi = string.indexOf(59, amp);
                String code = -1 != semi ? string.substring(amp, semi + 1) : string.substring(amp);
                char c = Translate.convertToChar(code);
                character = c;
                if ('\u0000' != c) {
                    index += code.length() - 1;
                } else {
                    character = 38;
                }
            } else {
                character = 38;
            }
            ret.append("w");
        }
        if (index < length) {
            ret.append(string.substring(index));
        }
        String tmp = ret.toString();
        tmp = tmp.replace("_{", "");
        tmp = tmp.replace("^{", "");
        tmp = tmp.replace("#bar{", "");
        tmp = tmp.replace("}", "");
        return tmp;
    }

    public static String convertToString(Character character) {
        String ret = (String)charRefTable.get(character);
        if (null != ret) {
            StringBuffer buffer = new StringBuffer(ret.length() + 2);
            buffer.append('&');
            buffer.append(ret);
            buffer.append(';');
            ret = buffer.toString();
        }
        return ret;
    }

    public static String convertToString(int character) {
        StringBuffer ret = new StringBuffer(13);
        ret.append("&#");
        ret.append(character);
        ret.append(';');
        return ret.toString();
    }

    public static String encode(String string) {
        StringBuffer ret = new StringBuffer(string.length() * 6);
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            Character character = new Character(c);
            String value = Translate.convertToString(character);
            if (null != value) {
                ret.append(value);
                continue;
            }
            if (c <= '\u001f' || c >= '\u007f') {
                value = Translate.convertToString((int)c);
                ret.append(value);
                continue;
            }
            ret.append(character);
        }
        return ret.toString();
    }

    static {
        refChar.put("nbsp", new Character('\u00a0'));
        refChar.put("iexcl", new Character('\u00a1'));
        refChar.put("cent", new Character('\u00a2'));
        refChar.put("pound", new Character('\u00a3'));
        refChar.put("curren", new Character('\u00a4'));
        refChar.put("yen", new Character('\u00a5'));
        refChar.put("brvbar", new Character('\u00a6'));
        refChar.put("sect", new Character('\u00a7'));
        refChar.put("uml", new Character('\u00a8'));
        refChar.put("copy", new Character('\u00a9'));
        refChar.put("ordf", new Character('\u00aa'));
        refChar.put("laquo", new Character('\u00ab'));
        refChar.put("not", new Character('\u00ac'));
        refChar.put("shy", new Character('\u00ad'));
        refChar.put("reg", new Character('\u00ae'));
        refChar.put("macr", new Character('\u00af'));
        refChar.put("deg", new Character('\u00b0'));
        refChar.put("plusmn", new Character('\u00b1'));
        refChar.put("sup2", new Character('\u00b2'));
        refChar.put("sup3", new Character('\u00b3'));
        refChar.put("acute", new Character('\u00b4'));
        refChar.put("micro", new Character('\u00b5'));
        refChar.put("para", new Character('\u00b6'));
        refChar.put("middot", new Character('\u00b7'));
        refChar.put("cedil", new Character('\u00b8'));
        refChar.put("sup1", new Character('\u00b9'));
        refChar.put("ordm", new Character('\u00ba'));
        refChar.put("raquo", new Character('\u00bb'));
        refChar.put("frac14", new Character('\u00bc'));
        refChar.put("frac12", new Character('\u00bd'));
        refChar.put("frac34", new Character('\u00be'));
        refChar.put("iquest", new Character('\u00bf'));
        refChar.put("Agrave", new Character('\u00c0'));
        refChar.put("Aacute", new Character('\u00c1'));
        refChar.put("Acirc", new Character('\u00c2'));
        refChar.put("Atilde", new Character('\u00c3'));
        refChar.put("Auml", new Character('\u00c4'));
        refChar.put("Aring", new Character('\u00c5'));
        refChar.put("AElig", new Character('\u00c6'));
        refChar.put("Ccedil", new Character('\u00c7'));
        refChar.put("Egrave", new Character('\u00c8'));
        refChar.put("Eacute", new Character('\u00c9'));
        refChar.put("Ecirc", new Character('\u00ca'));
        refChar.put("Euml", new Character('\u00cb'));
        refChar.put("Igrave", new Character('\u00cc'));
        refChar.put("Iacute", new Character('\u00cd'));
        refChar.put("Icirc", new Character('\u00ce'));
        refChar.put("Iuml", new Character('\u00cf'));
        refChar.put("ETH", new Character('\u00d0'));
        refChar.put("Ntilde", new Character('\u00d1'));
        refChar.put("Ograve", new Character('\u00d2'));
        refChar.put("Oacute", new Character('\u00d3'));
        refChar.put("Ocirc", new Character('\u00d4'));
        refChar.put("Otilde", new Character('\u00d5'));
        refChar.put("Ouml", new Character('\u00d6'));
        refChar.put("times", new Character('\u00d7'));
        refChar.put("Oslash", new Character('\u00d8'));
        refChar.put("Ugrave", new Character('\u00d9'));
        refChar.put("Uacute", new Character('\u00da'));
        refChar.put("Ucirc", new Character('\u00db'));
        refChar.put("Uuml", new Character('\u00dc'));
        refChar.put("Yacute", new Character('\u00dd'));
        refChar.put("THORN", new Character('\u00de'));
        refChar.put("szlig", new Character('\u00df'));
        refChar.put("agrave", new Character('\u00e0'));
        refChar.put("aacute", new Character('\u00e1'));
        refChar.put("acirc", new Character('\u00e2'));
        refChar.put("atilde", new Character('\u00e3'));
        refChar.put("auml", new Character('\u00e4'));
        refChar.put("aring", new Character('\u00e5'));
        refChar.put("aelig", new Character('\u00e6'));
        refChar.put("ccedil", new Character('\u00e7'));
        refChar.put("egrave", new Character('\u00e8'));
        refChar.put("eacute", new Character('\u00e9'));
        refChar.put("ecirc", new Character('\u00ea'));
        refChar.put("euml", new Character('\u00eb'));
        refChar.put("igrave", new Character('\u00ec'));
        refChar.put("iacute", new Character('\u00ed'));
        refChar.put("icirc", new Character('\u00ee'));
        refChar.put("iuml", new Character('\u00ef'));
        refChar.put("eth", new Character('\u00f0'));
        refChar.put("ntilde", new Character('\u00f1'));
        refChar.put("ograve", new Character('\u00f2'));
        refChar.put("oacute", new Character('\u00f3'));
        refChar.put("ocirc", new Character('\u00f4'));
        refChar.put("otilde", new Character('\u00f5'));
        refChar.put("ouml", new Character('\u00f6'));
        refChar.put("divide", new Character('\u00f7'));
        refChar.put("oslash", new Character('\u00f8'));
        refChar.put("ugrave", new Character('\u00f9'));
        refChar.put("uacute", new Character('\u00fa'));
        refChar.put("ucirc", new Character('\u00fb'));
        refChar.put("uuml", new Character('\u00fc'));
        refChar.put("yacute", new Character('\u00fd'));
        refChar.put("thorn", new Character('\u00fe'));
        refChar.put("yuml", new Character('\u00ff'));
        refChar.put("fnof", new Character('\u0192'));
        refChar.put("Alpha", new Character('\u0391'));
        refChar.put("Beta", new Character('\u0392'));
        refChar.put("Gamma", new Character('\u0393'));
        refChar.put("Delta", new Character('\u0394'));
        refChar.put("Epsilon", new Character('\u0395'));
        refChar.put("Zeta", new Character('\u0396'));
        refChar.put("Eta", new Character('\u0397'));
        refChar.put("Theta", new Character('\u0398'));
        refChar.put("Iota", new Character('\u0399'));
        refChar.put("Kappa", new Character('\u039a'));
        refChar.put("Lambda", new Character('\u039b'));
        refChar.put("Mu", new Character('\u039c'));
        refChar.put("Nu", new Character('\u039d'));
        refChar.put("Xi", new Character('\u039e'));
        refChar.put("Omicron", new Character('\u039f'));
        refChar.put("Pi", new Character('\u03a0'));
        refChar.put("Rho", new Character('\u03a1'));
        refChar.put("Sigma", new Character('\u03a3'));
        refChar.put("Tau", new Character('\u03a4'));
        refChar.put("Upsilon", new Character('\u03a5'));
        refChar.put("Phi", new Character('\u03a6'));
        refChar.put("Chi", new Character('\u03a7'));
        refChar.put("Psi", new Character('\u03a8'));
        refChar.put("Omega", new Character('\u03a9'));
        refChar.put("alpha", new Character('\u03b1'));
        refChar.put("beta", new Character('\u03b2'));
        refChar.put("gamma", new Character('\u03b3'));
        refChar.put("delta", new Character('\u03b4'));
        refChar.put("epsilon", new Character('\u03b5'));
        refChar.put("zeta", new Character('\u03b6'));
        refChar.put("eta", new Character('\u03b7'));
        refChar.put("theta", new Character('\u03b8'));
        refChar.put("iota", new Character('\u03b9'));
        refChar.put("kappa", new Character('\u03ba'));
        refChar.put("lambda", new Character('\u03bb'));
        refChar.put("mu", new Character('\u03bc'));
        refChar.put("nu", new Character('\u03bd'));
        refChar.put("xi", new Character('\u03be'));
        refChar.put("omicron", new Character('\u03bf'));
        refChar.put("pi", new Character('\u03c0'));
        refChar.put("rho", new Character('\u03c1'));
        refChar.put("sigmaf", new Character('\u03c2'));
        refChar.put("sigma", new Character('\u03c3'));
        refChar.put("tau", new Character('\u03c4'));
        refChar.put("upsilon", new Character('\u03c5'));
        refChar.put("phi", new Character('\u03c6'));
        refChar.put("chi", new Character('\u03c7'));
        refChar.put("psi", new Character('\u03c8'));
        refChar.put("omega", new Character('\u03c9'));
        refChar.put("thetasym", new Character('\u03d1'));
        refChar.put("upsih", new Character('\u03d2'));
        refChar.put("piv", new Character('\u03d6'));
        refChar.put("bull", new Character('\u2022'));
        refChar.put("hellip", new Character('\u2026'));
        refChar.put("prime", new Character('\u2032'));
        refChar.put("Prime", new Character('\u2033'));
        refChar.put("oline", new Character('\u203e'));
        refChar.put("frasl", new Character('\u2044'));
        refChar.put("weierp", new Character('\u2118'));
        refChar.put("image", new Character('\u2111'));
        refChar.put("real", new Character('\u211c'));
        refChar.put("trade", new Character('\u2122'));
        refChar.put("alefsym", new Character('\u2135'));
        refChar.put("larr", new Character('\u2190'));
        refChar.put("uarr", new Character('\u2191'));
        refChar.put("rarr", new Character('\u2192'));
        refChar.put("darr", new Character('\u2193'));
        refChar.put("harr", new Character('\u2194'));
        refChar.put("crarr", new Character('\u21b5'));
        refChar.put("lArr", new Character('\u21d0'));
        refChar.put("uArr", new Character('\u21d1'));
        refChar.put("rArr", new Character('\u21d2'));
        refChar.put("dArr", new Character('\u21d3'));
        refChar.put("hArr", new Character('\u21d4'));
        refChar.put("forall", new Character('\u2200'));
        refChar.put("part", new Character('\u2202'));
        refChar.put("exist", new Character('\u2203'));
        refChar.put("empty", new Character('\u2205'));
        refChar.put("nabla", new Character('\u2207'));
        refChar.put("isin", new Character('\u2208'));
        refChar.put("notin", new Character('\u2209'));
        refChar.put("ni", new Character('\u220b'));
        refChar.put("prod", new Character('\u220f'));
        refChar.put("sum", new Character('\u2211'));
        refChar.put("minus", new Character('\u2212'));
        refChar.put("lowast", new Character('\u2217'));
        refChar.put("radic", new Character('\u221a'));
        refChar.put("prop", new Character('\u221d'));
        refChar.put("infin", new Character('\u221e'));
        refChar.put("ang", new Character('\u2220'));
        refChar.put("and", new Character('\u2227'));
        refChar.put("or", new Character('\u2228'));
        refChar.put("cap", new Character('\u2229'));
        refChar.put("cup", new Character('\u222a'));
        refChar.put("int", new Character('\u222b'));
        refChar.put("there4", new Character('\u2234'));
        refChar.put("sim", new Character('\u223c'));
        refChar.put("cong", new Character('\u2245'));
        refChar.put("asymp", new Character('\u2248'));
        refChar.put("ne", new Character('\u2260'));
        refChar.put("equiv", new Character('\u2261'));
        refChar.put("le", new Character('\u2264'));
        refChar.put("ge", new Character('\u2265'));
        refChar.put("sub", new Character('\u2282'));
        refChar.put("sup", new Character('\u2283'));
        refChar.put("nsub", new Character('\u2284'));
        refChar.put("sube", new Character('\u2286'));
        refChar.put("supe", new Character('\u2287'));
        refChar.put("oplus", new Character('\u2295'));
        refChar.put("otimes", new Character('\u2297'));
        refChar.put("perp", new Character('\u22a5'));
        refChar.put("sdot", new Character('\u22c5'));
        refChar.put("lceil", new Character('\u2308'));
        refChar.put("rceil", new Character('\u2309'));
        refChar.put("lfloor", new Character('\u230a'));
        refChar.put("rfloor", new Character('\u230b'));
        refChar.put("lang", new Character('\u2329'));
        refChar.put("rang", new Character('\u232a'));
        refChar.put("loz", new Character('\u25ca'));
        refChar.put("spades", new Character('\u2660'));
        refChar.put("clubs", new Character('\u2663'));
        refChar.put("hearts", new Character('\u2665'));
        refChar.put("diams", new Character('\u2666'));
        refChar.put("quot", new Character('\"'));
        refChar.put("amp", new Character('&'));
        refChar.put("lt", new Character('<'));
        refChar.put("gt", new Character('>'));
        refChar.put("OElig", new Character('\u0152'));
        refChar.put("oelig", new Character('\u0153'));
        refChar.put("Scaron", new Character('\u0160'));
        refChar.put("scaron", new Character('\u0161'));
        refChar.put("Yuml", new Character('\u0178'));
        refChar.put("circ", new Character('\u02c6'));
        refChar.put("tilde", new Character('\u02dc'));
        refChar.put("ensp", new Character('\u2002'));
        refChar.put("emsp", new Character('\u2003'));
        refChar.put("thinsp", new Character('\u2009'));
        refChar.put("zwnj", new Character('\u200c'));
        refChar.put("zwj", new Character('\u200d'));
        refChar.put("lrm", new Character('\u200e'));
        refChar.put("rlm", new Character('\u200f'));
        refChar.put("ndash", new Character('\u2013'));
        refChar.put("mdash", new Character('\u2014'));
        refChar.put("lsquo", new Character('\u2018'));
        refChar.put("rsquo", new Character('\u2019'));
        refChar.put("sbquo", new Character('\u201a'));
        refChar.put("ldquo", new Character('\u201c'));
        refChar.put("rdquo", new Character('\u201d'));
        refChar.put("bdquo", new Character('\u201e'));
        refChar.put("dagger", new Character('\u2020'));
        refChar.put("Dagger", new Character('\u2021'));
        refChar.put("permil", new Character('\u2030'));
        refChar.put("lsaquo", new Character('\u2039'));
        refChar.put("rsaquo", new Character('\u203a'));
        refChar.put("euro", new Character('\u20ac'));
        charRefTable = new HashMap(refChar.size());
        for (String key : refChar.keySet()) {
            Character character = (Character)refChar.get(key);
            charRefTable.put(character, key);
        }
    }
}

