/*
 * Decompiled with CFR 0.152.
 */
package jhplot.v3d;

import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import jhplot.v3d.Face3d;
import jhplot.v3d.Matrix3d;
import jhplot.v3d.Model3d;
import jhplot.v3d.Position;
import jhplot.v3d.Vector3d;

public class Object3d
extends Position
implements Serializable {
    private static final long serialVersionUID = 1L;
    String name = null;
    Model3d md;
    Vector3d[] vert;
    Vector3d[] overt;
    Vector3d[] norm;
    Vector3d[] onorm;
    Vector3d center;
    Vector3d ocenter;
    Face3d[] face;
    int nvert;
    int cvert;
    int nface;
    int cface;

    public Object3d(Model3d md, int nvert, int nface) {
        this.md = md;
        this.nvert = nvert;
        this.nface = nface;
        if (nvert <= 4 || nface <= 4) {
            return;
        }
        this.vert = new Vector3d[nvert];
        this.overt = new Vector3d[nvert];
        this.norm = new Vector3d[nface];
        this.onorm = new Vector3d[nface];
        this.center = new Vector3d();
        this.ocenter = new Vector3d();
        this.face = new Face3d[nface];
        this.cface = 0;
        this.cvert = 0;
    }

    public Object3d(String name, Model3d md, int nvert, int nface) {
        this(md, nvert, nface);
        this.name = name;
    }

    public int addVertex(Vector3d v) {
        return this.addVertex(v.x, v.y, v.z);
    }

    public int addVertex(float x, float y, float z) {
        if (this.cvert >= this.nvert) {
            return -1;
        }
        this.vert[this.cvert] = new Vector3d(x, y, z);
        this.overt[this.cvert] = new Vector3d(x, y, z);
        return this.cvert++;
    }

    public int addFace(int nvert, Color c) {
        return this.addFace(nvert, c.getRed(), c.getGreen(), c.getBlue());
    }

    public int addFace(int nvert, int red, int green, int blue) {
        if (this.cface >= this.nface) {
            return -1;
        }
        this.face[this.cface] = new Face3d(this, nvert, red, green, blue);
        return this.cface++;
    }

    public int addFace(int nvert) {
        int i = this.addFace(nvert, 0, 0, 0);
        this.face[i].dummy = true;
        return i;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setColor(Color c) {
        this.setColor(c.getRed(), c.getGreen(), c.getBlue());
    }

    public void setColor(int red, int green, int blue) {
        if (this.cvert != this.nvert || this.cface != this.nface) {
            return;
        }
        for (int i = 0; i < this.nface; ++i) {
            this.face[i].setColor(red, green, blue);
        }
    }

    void setDummy(boolean dummy) {
        for (int i = 0; i < this.nface; ++i) {
            this.face[i].setDummy(dummy);
        }
    }

    void transformToModelSpace() {
        if (this.cvert != this.nvert || this.cface != this.nface) {
            return;
        }
        Matrix3d m = new Matrix3d();
        m.mul(this.rot);
        m.mul(this.scale);
        m.mul(this.trans);
        m.transform(this.ocenter, this.center);
        m.transform(this.overt, this.vert, this.nvert);
        m.unit();
        m.mul(this.rot);
        m.transform(this.onorm, this.norm, this.nface);
    }

    void transformToCameraSpace() {
        if (this.cvert != this.nvert || this.cface != this.nface) {
            return;
        }
        Matrix3d m = new Matrix3d();
        m.mul(this.rot);
        m.mul(this.scale);
        m.mul(this.trans);
        m.mul(this.md.rot);
        m.mul(this.md.scale);
        m.mul(this.md.trans);
        m.transform(this.ocenter, this.center);
        m.transform(this.overt, this.vert, this.nvert);
        m.unit();
        m.mul(this.rot);
        m.mul(this.md.rot);
        m.transform(this.onorm, this.norm, this.nface);
    }

    void transformToScreenSpace() {
        if (this.cvert != this.nvert || this.cface != this.nface) {
            return;
        }
        Matrix3d m = new Matrix3d();
        m.mul(this.rot);
        m.mul(this.scale);
        m.mul(this.trans);
        m.mul(this.md.rot);
        m.mul(this.md.scale);
        m.mul(this.md.trans);
        m.transform(this.ocenter, this.center);
        m.mul(this.md.mat);
        m.transform(this.overt, this.vert, this.nvert);
        m.unit();
        m.mul(this.rot);
        m.mul(this.md.rot);
        m.transform(this.onorm, this.norm, this.nface);
        if (this.md.persp) {
            for (int i = 0; i < this.nface; ++i) {
                this.face[i].computeCenter();
            }
            float hw = this.md.width / 2;
            float hh = this.md.height / 2;
            float zt = this.md.zTarget;
            for (int i = 0; i < this.nvert; ++i) {
                Vector3d v = this.vert[i];
                if (v.z < 0.0f) {
                    float p = zt / v.z;
                    v.x = hw + v.x * p;
                    v.y = hh - v.y * p;
                    continue;
                }
                this.setDummy(true);
            }
        }
    }

    void paint(Graphics g) {
        if (this.cvert != this.nvert || this.cface != this.nface) {
            return;
        }
        for (int i = 0; i < this.nface; ++i) {
            Face3d f = this.face[i];
            if (!f.visible()) continue;
            f.paint(g);
        }
    }

    int inside(int x, int y) {
        if (this.cvert != this.nvert || this.cface != this.nface) {
            return -1;
        }
        for (int i = 0; i < this.nface; ++i) {
            Face3d f = this.face[i];
            if (!f.visible() || !f.inside(x, y)) continue;
            return i;
        }
        return -1;
    }

    void computeCenter() {
        Vector3d c = this.ocenter;
        c.set(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < this.nvert; ++i) {
            c.add(this.overt[i]);
        }
        c.div(this.nvert);
    }

    void colectNormals() {
        if (this.cvert != this.nvert || this.cface != this.nface) {
            return;
        }
        this.computeCenter();
        for (int i = 0; i < this.nface; ++i) {
            Face3d f = this.face[i];
            Vector3d v = new Vector3d(this.ocenter);
            v.sub(f.vert[0]);
            if (v.dot(f.normal) > 0.0f) {
                f.normal.mul(-1.0f);
            }
            this.onorm[i] = f.normal;
            f.normal = this.norm[i] = new Vector3d();
        }
    }
}

