/*
 * Decompiled with CFR 0.152.
 */
package jhplot.v3d;

import jhplot.v3d.Trig;
import jhplot.v3d.Vector3d;

class Matrix3d {
    float xx;
    float yx;
    float zx;
    float xy;
    float yy;
    float zy;
    float xz;
    float yz;
    float zz;
    float xo;
    float yo;
    float zo;

    Matrix3d() {
        this.unit();
    }

    Matrix3d(Matrix3d m) {
        this.copy(m);
    }

    void unit() {
        this.xx = 1.0f;
        this.xy = 0.0f;
        this.xz = 0.0f;
        this.xo = 0.0f;
        this.yx = 0.0f;
        this.yy = 1.0f;
        this.yz = 0.0f;
        this.yo = 0.0f;
        this.zx = 0.0f;
        this.zy = 0.0f;
        this.zz = 1.0f;
        this.zo = 0.0f;
    }

    void copy(Matrix3d m) {
        this.xx = m.xx;
        this.xy = m.xy;
        this.xz = m.xz;
        this.xo = m.xo;
        this.yx = m.yx;
        this.yy = m.yy;
        this.yz = m.yz;
        this.yo = m.yo;
        this.zx = m.zx;
        this.zy = m.zy;
        this.zz = m.zz;
        this.zo = m.zo;
    }

    void xrot(float theta) {
        float ct = Trig.cos(theta);
        float st = Trig.sin(theta);
        float tyx = this.yx * ct + this.zx * st;
        float tyy = this.yy * ct + this.zy * st;
        float tyz = this.yz * ct + this.zz * st;
        float tyo = this.yo * ct + this.zo * st;
        float tzx = this.zx * ct - this.yx * st;
        float tzy = this.zy * ct - this.yy * st;
        float tzz = this.zz * ct - this.yz * st;
        float tzo = this.zo * ct - this.yo * st;
        this.yx = tyx;
        this.yy = tyy;
        this.yz = tyz;
        this.yo = tyo;
        this.zx = tzx;
        this.zy = tzy;
        this.zz = tzz;
        this.zo = tzo;
    }

    void yrot(float theta) {
        float ct = Trig.cos(theta);
        float st = Trig.sin(theta);
        float txx = this.xx * ct + this.zx * st;
        float txy = this.xy * ct + this.zy * st;
        float txz = this.xz * ct + this.zz * st;
        float txo = this.xo * ct + this.zo * st;
        float tzx = this.zx * ct - this.xx * st;
        float tzy = this.zy * ct - this.xy * st;
        float tzz = this.zz * ct - this.xz * st;
        float tzo = this.zo * ct - this.xo * st;
        this.xx = txx;
        this.xy = txy;
        this.xz = txz;
        this.xo = txo;
        this.zx = tzx;
        this.zy = tzy;
        this.zz = tzz;
        this.zo = tzo;
    }

    void zrot(float theta) {
        float ct = Trig.cos(theta);
        float st = Trig.sin(theta);
        float tyx = this.yx * ct + this.xx * st;
        float tyy = this.yy * ct + this.xy * st;
        float tyz = this.yz * ct + this.xz * st;
        float tyo = this.yo * ct + this.xo * st;
        float txx = this.xx * ct - this.yx * st;
        float txy = this.xy * ct - this.yy * st;
        float txz = this.xz * ct - this.yz * st;
        float txo = this.xo * ct - this.yo * st;
        this.yx = tyx;
        this.yy = tyy;
        this.yz = tyz;
        this.yo = tyo;
        this.xx = txx;
        this.xy = txy;
        this.xz = txz;
        this.xo = txo;
    }

    void scale(float f) {
        this.xx *= f;
        this.xy *= f;
        this.xz *= f;
        this.xo *= f;
        this.yx *= f;
        this.yy *= f;
        this.yz *= f;
        this.yo *= f;
        this.zx *= f;
        this.zy *= f;
        this.zz *= f;
        this.zo *= f;
    }

    void scale(float xf, float yf, float zf) {
        this.xx *= xf;
        this.xy *= xf;
        this.xz *= xf;
        this.xo *= xf;
        this.yx *= yf;
        this.yy *= yf;
        this.yz *= yf;
        this.yo *= yf;
        this.zx *= zf;
        this.zy *= zf;
        this.zz *= zf;
        this.zo *= zf;
    }

    void trans(float x, float y, float z) {
        this.xo += x;
        this.yo += y;
        this.zo += z;
    }

    void mul(Matrix3d m) {
        float txx = this.xx * m.xx + this.yx * m.xy + this.zx * m.xz;
        float txy = this.xy * m.xx + this.yy * m.xy + this.zy * m.xz;
        float txz = this.xz * m.xx + this.yz * m.xy + this.zz * m.xz;
        float txo = this.xo * m.xx + this.yo * m.xy + this.zo * m.xz + m.xo;
        float tyx = this.xx * m.yx + this.yx * m.yy + this.zx * m.yz;
        float tyy = this.xy * m.yx + this.yy * m.yy + this.zy * m.yz;
        float tyz = this.xz * m.yx + this.yz * m.yy + this.zz * m.yz;
        float tyo = this.xo * m.yx + this.yo * m.yy + this.zo * m.yz + m.yo;
        float tzx = this.xx * m.zx + this.yx * m.zy + this.zx * m.zz;
        float tzy = this.xy * m.zx + this.yy * m.zy + this.zy * m.zz;
        float tzz = this.xz * m.zx + this.yz * m.zy + this.zz * m.zz;
        float tzo = this.xo * m.zx + this.yo * m.zy + this.zo * m.zz + m.zo;
        this.xx = txx;
        this.xy = txy;
        this.xz = txz;
        this.xo = txo;
        this.yx = tyx;
        this.yy = tyy;
        this.yz = tyz;
        this.yo = tyo;
        this.zx = tzx;
        this.zy = tzy;
        this.zz = tzz;
        this.zo = tzo;
    }

    void transform(Vector3d v, Vector3d tv) {
        float x = v.x;
        float y = v.y;
        float z = v.z;
        tv.x = x * this.xx + y * this.xy + z * this.xz + this.xo;
        tv.y = x * this.yx + y * this.yy + z * this.yz + this.yo;
        tv.z = x * this.zx + y * this.zy + z * this.zz + this.zo;
    }

    void transform(Vector3d[] v, Vector3d[] tv, int nvert) {
        for (int i = 0; i < nvert; ++i) {
            Vector3d w = v[i];
            float x = w.x;
            float y = w.y;
            float z = w.z;
            w = tv[i];
            w.x = x * this.xx + y * this.xy + z * this.xz + this.xo;
            w.y = x * this.yx + y * this.yy + z * this.yz + this.yo;
            w.z = x * this.zx + y * this.zy + z * this.zz + this.zo;
        }
    }

    public String toString() {
        return "[" + this.xx + ", " + this.yx + ", " + this.zx + "]\n[" + this.xy + ", " + this.yy + ", " + this.zy + "]\n[" + this.xz + ", " + this.yz + ", " + this.zz + "]\n[" + this.xo + ", " + this.yo + ", " + this.zo + "]\n";
    }
}

