/*
 * Decompiled with CFR 0.152.
 */
package jhplot.stat;

import java.awt.Color;
import jhplot.F1D;
import jhplot.gui.HelpBrowser;

public class LinRegWeighted {
    private double[] x;
    private double[] y;
    private double[] w;
    private int n;
    private double a;
    private double b;
    private double chisq;
    private double meanX;
    private double meanY;
    private double minX = Double.POSITIVE_INFINITY;
    private double maxX = Double.NEGATIVE_INFINITY;
    private double minY = Double.POSITIVE_INFINITY;
    private double maxY = Double.NEGATIVE_INFINITY;

    public LinRegWeighted(double[] X, double[] Y, double[] W) {
        this.x = X;
        this.y = Y;
        this.w = W;
        if (this.x.length != this.y.length || this.x.length != this.w.length) {
            System.out.println("x, y vectors must be of same length");
        } else {
            this.n = this.x.length;
        }
        this.doStatistics();
    }

    private void doStatistics() {
        int i;
        double W = 0.0;
        double wm_x = 0.0;
        double wm_y = 0.0;
        double wm_dx2 = 0.0;
        double wm_dxdy = 0.0;
        for (i = 0; i < this.n; ++i) {
            this.minX = Math.min(this.minX, this.x[i]);
        }
        this.maxX = Math.max(this.maxX, this.x[i]);
        this.minY = Math.min(this.minY, this.y[i]);
        this.maxY = Math.max(this.maxY, this.y[i]);
        double wi = this.w[i];
        if (wi > 0.0) {
            wm_x += (this.x[i] - wm_x) * (wi / (W += wi));
            wm_y += (this.y[i] - wm_y) * (wi / W);
        }
        W = 0.0;
        this.meanX = wm_x;
        this.meanY = wm_y;
        for (i = 0; i < this.n; ++i) {
            wi = this.w[i];
            if (!(wi > 0.0)) continue;
            double dx = this.x[i] - wm_x;
            double dy = this.y[i] - wm_y;
            wm_dx2 += (dx * dx - wm_dx2) * (wi / (W += wi));
            wm_dxdy += (dx * dy - wm_dxdy) * (wi / W);
        }
        double d2 = 0.0;
        this.b = wm_dxdy / wm_dx2;
        this.a = wm_y - wm_x * this.b;
        double cov_00 = 1.0 / W * (1.0 + wm_x * wm_x / wm_dx2);
        double cov_11 = 1.0 / (W * wm_dx2);
        double cov_01 = -wm_x / (W * wm_dx2);
        for (i = 0; i < this.n; ++i) {
            double wi2 = this.w[i];
            if (!(wi2 > 0.0)) continue;
            double dx = this.x[i] - wm_x;
            double dy = this.y[i] - wm_y;
            double d = dy - this.b * dx;
            d2 += wi2 * d * d;
        }
        this.chisq = d2;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getIntercept() {
        return this.a;
    }

    public double getInterceptError() {
        return 0.0;
    }

    public double getSlopeError() {
        return 0.0;
    }

    public double getSlope() {
        return this.b;
    }

    public double[] getDataX() {
        return this.x;
    }

    public double[] getDataY() {
        return this.y;
    }

    public double getXBar() {
        return this.meanX;
    }

    public double getYBar() {
        return this.meanY;
    }

    public int getDataLength() {
        return this.n;
    }

    public double getChi2() {
        return this.chisq;
    }

    public F1D getResult() {
        F1D tmp = new F1D("P0+P1*x", "P0+P1*x", this.minX, this.maxX, false);
        tmp.setColor(Color.blue);
        tmp.setTitle("P0+P1*x");
        tmp.setPar("P0", this.getIntercept());
        tmp.setPar("P1", this.getSlope());
        tmp.parse();
        return tmp;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

