/*
 * Decompiled with CFR 0.152.
 */
package jhplot.shapes;

import java.awt.Color;
import java.awt.Stroke;
import jhplot.gui.HelpBrowser;
import jhplot.shapes.HShape;

public class Ellipse
extends HShape {
    private static final long serialVersionUID = 1L;

    public Ellipse(double X1, double Y1, double r1, double r2, Stroke strock, Color color) {
        super(X1, Y1, r1, r2, strock, color);
        this.whoAm = 6;
        if (r1 < 0.0) {
            System.err.println("ellipse semimajor axis must be nonnegative");
        }
        if (r2 < 0.0) {
            System.err.println("ellipse semiminor axis must be nonnegative");
        }
    }

    public Ellipse(double X1, double Y1, double r1, double r2) {
        super(X1, Y1, r1, r2, HShape.DFS, Color.black);
        this.whoAm = 6;
        if (r1 < 0.0) {
            System.err.println("ellipse semimajor axis must be nonnegative");
        }
        if (r2 < 0.0) {
            System.err.println("ellipse semiminor axis must be nonnegative");
        }
    }

    public double getRadiusX() {
        return this.X2;
    }

    public double getRadiusY() {
        return this.Y2;
    }

    public String toString() {
        String s1 = Double.toString(this.X1);
        String s2 = Double.toString(this.Y1);
        String s3 = Double.toString(this.X2);
        String s4 = Double.toString(this.Y2);
        String pos = " X1=" + s1 + "  Y1=" + s2 + "  SimiMajor=" + s3 + " SemiMinor=" + s4;
        return "Ellipse: " + pos;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

