/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.pca.covmatrixevd;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import jhplot.math.pca.covmatrixevd.CovarianceMatrixEVDCalculator;
import jhplot.math.pca.covmatrixevd.EVDResult;

public class SVDBased
implements CovarianceMatrixEVDCalculator {
    @Override
    public EVDResult run(Matrix centeredData) {
        int m = centeredData.getRowDimension();
        int n = centeredData.getColumnDimension();
        SingularValueDecomposition svd = centeredData.svd();
        double[] singularValues = svd.getSingularValues();
        Matrix d = Matrix.identity((int)n, (int)n);
        for (int i = 0; i < n; ++i) {
            double val = i < m ? singularValues[i] : 0.0;
            d.set(i, i, 1.0 / (double)(m - 1) * Math.pow(val, 2.0));
        }
        Matrix v = svd.getV();
        return new EVDResult(d, v);
    }
}

