/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.random;

import jhplot.math.num.random.AbstractDiscreteRandomVariable;
import jhplot.math.num.random.GammaRandomVariable;
import jhplot.math.num.random.PoissonRandomVariable;
import jhplot.math.num.random.RNG;
import jhplot.math.num.random.RandomRNG;

public class NegativeBinomialRandomVariable
extends AbstractDiscreteRandomVariable {
    private int numberOfSuccesses;
    private double probabilityOfSuccess;

    public NegativeBinomialRandomVariable() {
        this(1, 0.5);
    }

    public NegativeBinomialRandomVariable(int r, double p) {
        this(r, p, new RandomRNG());
    }

    public NegativeBinomialRandomVariable(int r, double p, RNG source) {
        super(source);
        this.setNumberOfSuccesses(r);
        this.setProbabilityOfSuccess(p);
    }

    public static int nextRandomVariable(int r, double p, RNG source) {
        double y = GammaRandomVariable.nextRandomVariable(r, (1.0 - p) / p, source);
        return PoissonRandomVariable.nextRandomVariable(y, source);
    }

    private int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    private double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public int nextRandomVariable() {
        return NegativeBinomialRandomVariable.nextRandomVariable(this.getNumberOfSuccesses(), this.getProbabilityOfSuccess(), this.getSource());
    }

    private void setNumberOfSuccesses(int r) {
        if (r <= 0) {
            throw new IllegalArgumentException("number of successes must be positive.");
        }
        this.numberOfSuccesses = r;
    }

    private void setProbabilityOfSuccess(double p) {
        if (Double.isNaN(p) || p <= 0.0 || p >= 1.0) {
            throw new IllegalArgumentException("probability of success mustbe between 0.0 and 1.0, exclusive.");
        }
        this.probabilityOfSuccess = p;
    }
}

