/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.random;

import jhplot.math.num.random.AbstractContinuousRandomVariable;
import jhplot.math.num.random.RNG;
import jhplot.math.num.random.RandomRNG;

public class LogisticRandomVariable
extends AbstractContinuousRandomVariable {
    private double mean;
    private double scale;

    public LogisticRandomVariable() {
        this(0.0, 1.0);
    }

    public LogisticRandomVariable(double m, double s) {
        this(m, s, new RandomRNG());
    }

    public LogisticRandomVariable(double m, double s, RNG source) {
        super(source);
        this.setMean(m);
        this.setScale(s);
    }

    public static double nextRandomVariable(double m, double s, RNG source) {
        double u;
        while ((u = source.nextRandomNumber()) >= 1.0) {
        }
        return m - s * Math.log(1.0 / u - 1.0);
    }

    private double getMean() {
        return this.mean;
    }

    private double getScale() {
        return this.scale;
    }

    @Override
    public double nextRandomVariable() {
        return LogisticRandomVariable.nextRandomVariable(this.getMean(), this.getScale(), this.getSource());
    }

    private void setMean(double m) {
        if (Double.isNaN(m)) {
            throw new IllegalArgumentException("mean must be a valid number.");
        }
        this.mean = m;
    }

    private void setScale(double s) {
        if (s <= 0.0 || Double.isNaN(s)) {
            throw new IllegalArgumentException("scale parameter must be positive.");
        }
        this.scale = s;
    }
}

