/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.pdf;

import jhplot.math.num.NumericException;
import jhplot.math.num.pdf.DiscreteDistribution;
import jhplot.math.num.pdf.SaddlePoint;

public class Binomial
extends DiscreteDistribution {
    private int numberOfTrials;
    private double probabilityOfSuccess;

    public Binomial() {
        this(1, 0.5);
    }

    public Binomial(int n, double p) {
        this.setNumberOfTrials(n);
        this.setProbabilityOfSuccess(p);
    }

    @Override
    public double cumulativeProbability(int x) throws NumericException {
        double ret = x < 0 ? 0.0 : (x >= this.numberOfTrials ? 1.0 : this.simpleCumulativeProbability(0, x));
        return ret;
    }

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public int inverseCumulativeProbability(double p) throws NumericException {
        int ret = p < 0.0 || p > 1.0 || Double.isNaN(p) ? Integer.MIN_VALUE : (p == 0.0 ? -1 : (p == 1.0 ? this.numberOfTrials : this.findInverseCumulativeProbability(p, 0, (int)((double)this.numberOfTrials * this.probabilityOfSuccess + 0.5), this.numberOfTrials)));
        return ret;
    }

    @Override
    public double probability(int x) {
        double ret = x < 0 || x > this.numberOfTrials ? 0.0 : Math.exp(SaddlePoint.logBinomialProbability(x, this.numberOfTrials, this.probabilityOfSuccess, 1.0 - this.probabilityOfSuccess));
        return ret;
    }

    public void setNumberOfTrials(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("number of trials must be positive.");
        }
        this.numberOfTrials = n;
    }

    public void setProbabilityOfSuccess(double p) {
        if (Double.isNaN(p) || p <= 0.0 || p >= 1.0) {
            throw new IllegalArgumentException("probability of success mustbe between 0.0 and 1.0, exclusive.");
        }
        this.probabilityOfSuccess = p;
    }
}

