/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.integration;

import jhplot.math.num.ConvergenceException;
import jhplot.math.num.Function;
import jhplot.math.num.IterativeMethod;
import jhplot.math.num.NumericException;

public class TrapezoidalIntegrator
extends IterativeMethod {
    private Function function;

    public TrapezoidalIntegrator(Function f) {
        this(f, 100, 1.0E-10);
    }

    public TrapezoidalIntegrator(Function f, int iterations, double error) {
        super(iterations, error);
        this.setFunction(f);
    }

    public Function getFunction() {
        return this.function;
    }

    public double integrate(double a, double b) throws NumericException {
        double s;
        IterativeState state = new IterativeState(this.function, a, b);
        double sn = s = state.getResult();
        double error = Double.MAX_VALUE;
        do {
            state.iterate();
            sn = state.getResult();
            error = Math.abs(sn / s - 1.0);
            s = sn;
        } while (state.getIterations() < this.getMaximumIterations() && error > this.getMaximumRelativeError());
        if (state.getIterations() >= this.getMaximumIterations()) {
            throw new ConvergenceException("Trapezoidal integration failed to converge.");
        }
        return s;
    }

    public void setFunction(Function f) {
        if (f == null) {
            throw new IllegalArgumentException("Function can not be null.");
        }
        this.function = f;
    }

    static class IterativeState {
        private Function function;
        private double a;
        private double b;
        private int n;
        private double s;
        private int k;

        IterativeState(Function f, double low, double up) throws NumericException {
            this.a = low;
            this.b = up;
            this.function = f;
            double fa = f.evaluate(low);
            double fb = f.evaluate(up);
            this.s = (up - low) * (fa / 2.0 + fb / 2.0);
            this.n = 0;
            this.k = 2;
        }

        public int getIterations() {
            return this.n;
        }

        public void iterate() throws NumericException {
            ++this.n;
            double sn = 0.0;
            double h = (this.b - this.a) / (double)this.k;
            for (int i = this.k - 1; i >= 1; i -= 2) {
                double x = this.a + (double)i * h;
                sn += this.function.evaluate(x);
            }
            sn = 0.5 * this.s + h * sn;
            this.k *= 2;
            this.s = sn;
        }

        public double getResult() {
            return this.s;
        }
    }
}

