/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num;

import jhplot.math.num.ConvergenceException;
import jhplot.math.num.NumericException;

public abstract class IterativeMethod {
    private int maximumIterations;
    private double maximumRelativeError;

    protected IterativeMethod() {
        this(100, 1.0E-10);
    }

    protected IterativeMethod(int iterations, double error) {
        this.setMaximumIterations(iterations);
        this.setMaximumRelativeError(error);
    }

    public int getMaximumIterations() {
        return this.maximumIterations;
    }

    public double getMaximumRelativeError() {
        return this.maximumRelativeError;
    }

    public void iterate(IterativeState state) throws NumericException {
        state.initialize();
        do {
            state.iterate();
        } while (state.getIterations() < this.getMaximumIterations() && Math.abs(state.getRelativeError()) > this.getMaximumRelativeError());
        if (state.getIterations() >= this.getMaximumIterations()) {
            throw new ConvergenceException("Iterative method failed to converge.");
        }
    }

    public void setMaximumIterations(int iterations) {
        if (iterations <= 0) {
            throw new IllegalArgumentException("Maximum iterations must be positive.");
        }
        this.maximumIterations = iterations;
    }

    public void setMaximumRelativeError(double error) {
        if (error <= 0.0 || Double.isNaN(error)) {
            throw new IllegalArgumentException("Maximum relative error must be positive.");
        }
        this.maximumRelativeError = error;
    }

    public static interface IterativeState {
        public int getIterations();

        public double getRelativeError();

        public void initialize();

        public void iterate() throws NumericException;
    }
}

