/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math;

import jhplot.F1D;
import jhplot.F2D;
import jhplot.math.ArrayMath;
import jhplot.math.Complex;

public final class Numeric {
    public static double[] solveLinear(double a, double b) {
        double[] roots = new double[]{-b / a};
        return roots;
    }

    public static double[] solveQuadratic(double a, double b, double c) {
        double[] roots = new double[2];
        double q = Math.sqrt(b * b - 4.0 * a * c);
        roots[0] = (-b - q) / (2.0 * a);
        roots[1] = (-b + q) / (2.0 * a);
        return roots;
    }

    public static double[] solveCubic(double a, double b, double c, double d) {
        double[] roots = new double[3];
        double twoonethird = Math.pow(2.0, 0.0);
        double delta = Math.pow(-2.0 * b * b * b + 9.0 * a * b * c - 27.0 * a * a * d + Math.sqrt(4.0 * Math.pow(-b * b + 3.0 * a * c, 3.0) + Math.pow(-2.0 * b * b * b + 9.0 * a * b * c - 27.0 * a * a * d, 2.0)), 0.0);
        roots[0] = -b / (3.0 * a) - twoonethird * (-b * b + 3.0 * a * c) / (3.0 * a * delta) + delta / (3.0 * twoonethird * a);
        roots[1] = new Complex(1.0, Math.sqrt(3.0)).times(-b * b + 3.0 * a * c).divide(3.0 * Math.pow(2.0, 0.0) * a * delta).minus(new Complex(1.0, -Math.sqrt(3.0)).times(delta / (6.0 * twoonethird * a))).minusReal(b / (3.0 * a)).mod();
        roots[2] = new Complex(1.0, -Math.sqrt(3.0)).times(-b * b + 3.0 * a * c).divide(3.0 * Math.pow(2.0, 0.0) * a * delta).minus(new Complex(1.0, Math.sqrt(3.0)).times(delta / (6.0 * twoonethird * a))).minusReal(b / (3.0 * a)).mod();
        return roots;
    }

    public static double[] solveQuartic(double a, double b, double c, double d, double e) {
        double[] roots = new double[4];
        double twoonethird = Math.pow(2.0, 0.0);
        double delta0 = c * c - 3.0 * b * d + 12.0 * a * e;
        double delta1 = Math.pow(2.0 * c * c * c - 9.0 * b * c * d + 27.0 * a * d * d + 27.0 * b * b * e - 72.0 * a * c * e + Math.sqrt(-4.0 * Math.pow(delta0, 3.0) + Math.pow(2.0 * c * c * c - 9.0 * b * c * d + 27.0 * a * d * d + 27.0 * b * b * e - 72.0 * a * c * e, 2.0)), 0.0);
        double delta2 = twoonethird * delta0 / (3.0 * a * delta1);
        double delta3 = delta1 / (3.0 * a * twoonethird);
        double delta4 = 0.5 * Math.sqrt(b * b / (4.0 * a * a) - 2.0 * c / (3.0 * a) + delta2 + delta3);
        double delta5 = 0.5 * Math.sqrt(b * b / (2.0 * a * a) - 4.0 * c / (3.0 * a) - delta2 - delta3);
        double delta6 = (-b * b * b / (a * a * a) + 4.0 * b * c / (a * a) - 8.0 * d / a) / (4.0 * Math.sqrt(b * b / (4.0 * a * a) - 2.0 * c / (3.0 * a) + delta2 + delta3));
        roots[0] = -b / (4.0 * a) - delta4 - delta5 - delta6;
        roots[0] = -b / (4.0 * a) - delta4 + delta5 - delta6;
        roots[0] = -b / (4.0 * a) + delta4 - delta5 + delta6;
        roots[0] = -b / (4.0 * a) + delta4 + delta5 + delta6;
        return roots;
    }

    public static double[] euler(double[] y, F1D func, double dt) {
        for (int i = 0; i < y.length - 1; ++i) {
            y[i + 1] = y[i] + dt * func.eval(y[i]);
        }
        return y;
    }

    public static double[] leapFrog(double[] y, F1D func, double dt) {
        double two_dt = 2.0 * dt;
        for (int i = 1; i < y.length - 1; ++i) {
            y[i + 1] = y[i - 1] + two_dt * func.eval(y[i]);
        }
        return y;
    }

    public static double[] rungeKutta2(double[] y, F1D func, double dt) {
        double dt2 = dt / 2.0;
        for (int i = 0; i < y.length - 1; ++i) {
            y[i + 1] = y[i] + dt * func.eval(y[i] + dt2 * func.eval(y[i]));
        }
        return y;
    }

    public static double[] rungeKutta4(double[] y, F1D func, double dt) {
        for (int i = 0; i < y.length - 1; ++i) {
            double k1 = dt * func.eval(y[i]);
            double k2 = dt * func.eval(y[i] + k1 / 2.0);
            double k3 = dt * func.eval(y[i] + k2 / 2.0);
            double k4 = dt * func.eval(y[i] + k3);
            y[i + 1] = y[i] + (k1 + k4) / 6.0 + (k2 + k3) / 3.0;
        }
        return y;
    }

    public static double trapezium(int N, F1D func, double a, double b) {
        double A = 0.0;
        double x = a;
        double h = (b - a) / (double)N;
        for (int i = 0; i < N; ++i) {
            A += func.eval(x) + func.eval(x + h);
            x += h;
        }
        return A * h / 2.0;
    }

    public static double trapezium2D(int N, F2D func, double a1, double b1, double a2, double b2) {
        double A = 0.0;
        double x1 = a1;
        double h1 = (b1 - a1) / (double)N;
        double x2 = a2;
        double h2 = (b2 - a2) / (double)N;
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                A += func.eval(x1, x2) + func.eval(x1 + h1, x2 + h2);
                x2 += h2;
            }
            x1 += h1;
        }
        return A * (h1 / 2.0) * (h2 / 2.0);
    }

    public static double simpson(int N, F1D func, double a, double b) {
        double Ao = 0.0;
        double Ae = 0.0;
        double x = a;
        double h = (b - a) / (double)(2 * N);
        for (int i = 0; i < N - 1; ++i) {
            Ao += func.eval(x + h);
            Ae += func.eval(x + 2.0 * h);
            x += 2.0 * h;
        }
        return h / 3.0 * (func.eval(a) + 4.0 * (Ao += func.eval(x + h)) + 2.0 * Ae + func.eval(b));
    }

    public static double richardson(int N, F1D func, double a, double b) {
        double Aao = 0.0;
        double Aae = 0.0;
        double Abo = 0.0;
        double Abe = 0.0;
        double x = a;
        double ha = (b - a) / (double)(2 * N);
        double hb = ha / 2.0;
        for (int i = 0; i < N - 1; ++i) {
            Aao += func.eval(x + ha);
            Aae += func.eval(x + 2.0 * ha);
            Abo += func.eval(x + hb);
            Abe += func.eval(x + 2.0 * hb);
            Abo += func.eval(x + 3.0 * hb);
            Abe += func.eval(x + 4.0 * hb);
            x += 2.0 * ha;
        }
        Abo += func.eval(x + hb);
        double Aa = ha / 3.0 * (func.eval(a) + 4.0 * (Aao += func.eval(x + ha)) + 2.0 * Aae + func.eval(b));
        double Ab = hb / 3.0 * (func.eval(a) + 4.0 * (Abo += func.eval(x + 3.0 * hb)) + 2.0 * (Abe += func.eval(x + 2.0 * hb)) + func.eval(b));
        return (16.0 * Ab - Aa) / 15.0;
    }

    public static double adaptive(F1D func, double a, double b) {
        double EPSILON = 1.0E-6;
        double h = b - a;
        double c = (a + b) / 2.0;
        double d = (a + c) / 2.0;
        double e = (b + c) / 2.0;
        double Q1 = h / 6.0 * (func.eval(a) + 4.0 * func.eval(c) + func.eval(b));
        double Q2 = h / 12.0 * (func.eval(a) + 4.0 * func.eval(d) + 2.0 * func.eval(c) + 4.0 * func.eval(e) + func.eval(b));
        if (Math.abs(Q2 - Q1) <= 1.0E-6) {
            return Q2 + (Q2 - Q1) / 15.0;
        }
        return Numeric.adaptive(func, a, c) + Numeric.adaptive(func, c, b);
    }

    public static double gaussian4(int N, F1D func, double a, double b) {
        double A = 0.0;
        double h = (b - a) / (double)N;
        double h2 = h / 2.0;
        double[] zeros = new double[4];
        double[] coeffs = new double[4];
        zeros[2] = 0.33998104358485626;
        zeros[3] = 0.8611363115940526;
        zeros[0] = -zeros[3];
        zeros[1] = -zeros[2];
        coeffs[3] = 0.34785484513745385;
        coeffs[0] = 0.34785484513745385;
        coeffs[2] = 0.6521451548625461;
        coeffs[1] = 0.6521451548625461;
        for (int n = 0; n < N; ++n) {
            for (int i = 0; i < zeros.length; ++i) {
                A += coeffs[i] * func.eval(a + (zeros[i] + 1.0) * h2);
            }
            a += h;
        }
        return A * h2;
    }

    public static double gaussian8(int N, F1D func, double a, double b) {
        double A = 0.0;
        double h = (b - a) / (double)N;
        double h2 = h / 2.0;
        double[] zeros = new double[8];
        double[] coeffs = new double[8];
        zeros[4] = 0.1834346424956498;
        zeros[5] = 0.525532409916329;
        zeros[6] = 0.7966664774136267;
        zeros[7] = 0.9602898564975363;
        zeros[0] = -zeros[7];
        zeros[1] = -zeros[6];
        zeros[2] = -zeros[5];
        zeros[3] = -zeros[4];
        coeffs[7] = 0.10122853629037626;
        coeffs[0] = 0.10122853629037626;
        coeffs[6] = 0.22238103445337448;
        coeffs[1] = 0.22238103445337448;
        coeffs[5] = 0.31370664587788727;
        coeffs[2] = 0.31370664587788727;
        coeffs[4] = 0.362683783378362;
        coeffs[3] = 0.362683783378362;
        for (int n = 0; n < N; ++n) {
            for (int i = 0; i < zeros.length; ++i) {
                A += coeffs[i] * func.eval(a + (zeros[i] + 1.0) * h2);
            }
            a += h;
        }
        return A * h2;
    }

    public static double[] differentiate(int N, F1D func, double a, double b) {
        double[] diff = new double[N];
        double x = a;
        double dx = (b - a) / (double)N;
        double dx2 = dx / 2.0;
        for (int i = 0; i < N; ++i) {
            diff[i] = (func.eval(x + dx2) - func.eval(x - dx2)) / dx;
            x += dx;
        }
        return diff;
    }

    public static double[][] differentiate(F1D func, double[] x, double[] dx) {
        int i;
        double[] xplus = new double[x.length];
        double[] xminus = new double[x.length];
        System.arraycopy(x, 0, xplus, 0, x.length);
        System.arraycopy(x, 0, xminus, 0, x.length);
        xplus[0] = xplus[0] + dx[0];
        xminus[0] = xminus[0] - dx[0];
        double[] funcdiff = ArrayMath.scalarMultiply(0.5 / dx[0], ArrayMath.subtract(func.eval(xplus), func.eval(xminus)));
        double[][] diff = new double[funcdiff.length][x.length];
        for (i = 0; i < funcdiff.length; ++i) {
            diff[i][0] = funcdiff[i];
        }
        for (int j = 1; j < x.length; ++j) {
            System.arraycopy(x, 0, xplus, 0, x.length);
            System.arraycopy(x, 0, xminus, 0, x.length);
            int n = j;
            xplus[n] = xplus[n] + dx[j];
            int n2 = j;
            xminus[n2] = xminus[n2] - dx[j];
            funcdiff = ArrayMath.scalarMultiply(0.5 / dx[j], ArrayMath.subtract(func.eval(xplus), func.eval(xminus)));
            for (i = 0; i < funcdiff.length; ++i) {
                diff[i][j] = funcdiff[i];
            }
        }
        return diff;
    }

    public static double[] metropolis(double[] list, F1D func, double dx) {
        for (int i = 0; i < list.length - 1; ++i) {
            list[i + 1] = list[i] + dx * (2.0 * Math.random() - 1.0);
            if (!(func.eval(list[i + 1]) / func.eval(list[i]) < Math.random())) continue;
            list[i + 1] = list[i];
        }
        return list;
    }
}

